/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.wcp.namespace;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryBatchService;
import com.vmware.cis.data.api.QueryCommand;
import com.vmware.cis.data.api.QueryResult;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vcenter.namespace_management.stats.TimeSeries;
import com.vmware.vcenter.namespace_management.stats.TimeSeriesTypes;
import com.vmware.vcenter.namespaces.InstancesTypes;
import com.vmware.vcenter.namespaces.events.Events;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.uri.resolve.VapiUriSchemeUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.vapi.util.VapiUtil;
import com.vmware.vsphere.client.h5.wcp.util.VcCapabilityCache;
import com.vmware.vsphere.client.spbm.PbmServiceFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class NamespacePropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(NamespacePropertyProvider.class);
    private QueryService _queryService;
    private QueryBatchService _queryBatchService;
    private PbmServiceFactory _pbmServiceFactory;
    private TimeSeries _timeSeries;
    private Events _events;
    private VcCapabilityCache _vcCapabilityCache;
    private final String PROPERTY_NETWORK_PROVIDER = "networkProvider";
    private final String PROPERTY_NAMESPACE = "namespace";
    private final String PROPERTY_VALUE = "group-d1";
    private final String PROPERTY_TYPE = "Folder";
    private final String PROPERTY_CLUSTER = "cluster";
    private final String PROPERTY_GRANTED_PRIVILEGES = "grantedPrivileges";
    private final String PROPERTY_RP_MEMORY_USED = "ResourcePool/runtime/memory/reservationUsed";
    private final String PROPERTY_RP_CPU_USED = "ResourcePool/runtime/cpu/reservationUsed";
    private final String WORKLOAD_CONFIG_STATUS_PROPERTY = "config_status";
    private final String INVERSE_SUFFIX = "/@deprecatedInverse";
    private final String PRIVILEGE_NAMESPACE_CONFIGURE = "Namespaces.Configure";
    private final String SUPERVISOR_ID_PROP = "supervisor_id";
    private final String CLUSTER_ID_PROP = "cluster";
    private final String SUPERVISOR_NAME_PROP = "supervisor_name";
    private final String CLUSTER_NAME_PROP = "cluster_name";
    private HashMap<String, String> vcGuidNameMap = new HashMap();
    private final long TWENTY_FOUR_HOURS = 86400000L;

    @Autowired
    public NamespacePropertyProvider(DataService dataService, QueryServiceFactory queryServiceFactory, PbmServiceFactory pbmServiceFactory, TimeSeries timeSeries, Events events, QueryBatchService queryBatchService, VcCapabilityCache vcCapabilityCache) {
        Validate.notNull((Object)dataService, (String)"dataService is null");
        Validate.notNull((Object)pbmServiceFactory, (String)"pbmServiceFactory is null");
        this._queryService = queryServiceFactory.getQueryService();
        this._pbmServiceFactory = pbmServiceFactory;
        this._timeSeries = timeSeries;
        this._events = events;
        this._queryBatchService = queryBatchService;
        this._vcCapabilityCache = vcCapabilityCache;
    }

    @ModelMetadata(type={"com.vmware.wcp.WorkloadModel"}, property="com.vmware.wcp.WorkloadModel/namespaceStats")
    public List<TimeSeriesTypes.TimeSeries> getNamespaceStats(URI namespaceUri) throws Exception {
        TimeSeriesTypes.Spec spec = new TimeSeriesTypes.Spec();
        spec.setObjType(TimeSeriesTypes.Spec.ObjType.NAMESPACE);
        spec.setNamespace(VapiUriSchemeUtil.getId((URI)namespaceUri));
        spec.setStart(System.currentTimeMillis() - 86400000L);
        spec.setEnd(System.currentTimeMillis());
        String nodeUuid = VapiUriSchemeUtil.getNodeUuid((URI)namespaceUri);
        InvocationConfig invocationConfig = VapiUtil.newInvocationConfig((String)nodeUuid);
        ArrayList<TimeSeriesTypes.TimeSeries> result = new ArrayList();
        try {
            result = this._timeSeries.get(spec, invocationConfig);
        }
        catch (Exception e) {
            _logger.error((Object)("Exception while calling TimeSeries.get()" + e));
        }
        return result;
    }

    @ModelMetadata(type={"com.vmware.wcp.WorkloadModel"}, property="com.vmware.wcp.WorkloadModel/cpuAndMemory")
    public Long[] getCpuAndMemory(URI namespaceUri) throws Exception {
        Long[] result = new Long[]{0L, 0L};
        try {
            ResultSet queryResult = this._queryService.select(new String[]{"ResourcePool/runtime/cpu/reservationUsed", "ResourcePool/runtime/memory/reservationUsed"}).from(new String[]{ResourcePool.class.getSimpleName()}).where("namespace", PropertyPredicate.ComparisonOperator.EQUAL, (Object)namespaceUri).fetch();
            if (queryResult != null && queryResult.getItems().size() == 1) {
                ResourceItem item = (ResourceItem)queryResult.getItems().get(0);
                result[0] = (Long)item.get("ResourcePool/runtime/cpu/reservationUsed");
                result[1] = (Long)item.get("ResourcePool/runtime/memory/reservationUsed");
            }
        }
        catch (Throwable t) {
            _logger.error((Object)"Error in getCpuAndMemory(): ", t);
        }
        return result;
    }

    @ModelMetadata(type={"com.vmware.wcp.WorkloadModel"}, property="com.vmware.wcp.WorkloadModel/clusterNetworkProvider")
    public String getClusterNetworkProvider(URI namespaceUri) {
        try {
            ResultSet queryResult = this._queryService.select(new String[]{"networkProvider"}).from(new String[]{ClusterComputeResource.class.getSimpleName()}).where(new PropertyPredicate[]{this.newClusterByNamespacePropPredicate(namespaceUri)}).fetch();
            if (queryResult != null && queryResult.getItems().size() == 1) {
                ResourceItem item = (ResourceItem)queryResult.getItems().get(0);
                return (String)item.get("networkProvider");
            }
        }
        catch (Throwable t) {
            _logger.error((Object)"Error in getClusterNetworkProvider(): ", t);
        }
        return "";
    }

    @ModelMetadata(type={"com.vmware.wcp.WorkloadModel"}, property="com.vmware.wcp.WorkloadModel/vCenterName")
    public String getVCenterName(URI namespaceUri) throws Exception {
        String serverGuid = VapiUriSchemeUtil.getNodeUuid((URI)namespaceUri);
        String vcName = this.vcGuidNameMap.get(serverGuid);
        if (vcName != null) {
            return vcName;
        }
        vcName = VcServiceUtil.getServiceName((String)serverGuid);
        this.vcGuidNameMap.put(serverGuid, vcName);
        return vcName;
    }

    @ModelMetadata(type={"com.vmware.wcp.WorkloadModel"}, property="com.vmware.wcp.WorkloadModel/vCenter")
    public ManagedObjectReference getVCenter(URI namespaceUri) throws Exception {
        String serverGuid = VapiUriSchemeUtil.getNodeUuid((URI)namespaceUri);
        ManagedObjectReference vcenterRef = new ManagedObjectReference("Folder", "group-d1", serverGuid);
        return vcenterRef;
    }

    @ModelMetadata(type={"com.vmware.wcp.WorkloadModel"}, property="com.vmware.wcp.WorkloadModel/isRemoveAllowed")
    public Boolean getIsRemoveAllowed(URI namespaceUri) {
        ArrayList<QueryCommand> queries = new ArrayList<QueryCommand>();
        queries.add(this._queryService.select(new String[]{"config_status"}).from(new String[]{"com.vmware.wcp.WorkloadModel"}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)namespaceUri).build());
        queries.add(this._queryService.select(new String[]{"grantedPrivileges"}).from(new String[]{ClusterComputeResource.class.getSimpleName()}).where(new PropertyPredicate[]{this.newClusterByNamespacePropPredicate(namespaceUri)}).build());
        List results = this._queryBatchService.executeQueryBatch(queries);
        boolean isInRemovingState = false;
        boolean hasNamespaceConfigurePrivilege = true;
        for (QueryResult result : results) {
            List properties = result.getResultSet().getProperties();
            Optional item = result.getResultSet().getItems().stream().findFirst();
            if (properties.contains("config_status")) {
                isInRemovingState = item.isPresent() && InstancesTypes.ConfigStatus.REMOVING.name().equals(((ResourceItem)item.get()).get("config_status"));
                continue;
            }
            if (!properties.contains("grantedPrivileges")) continue;
            hasNamespaceConfigurePrivilege = item.isPresent() && Arrays.asList((Object[])((ResourceItem)item.get()).get("grantedPrivileges")).contains("Namespaces.Configure");
        }
        return hasNamespaceConfigurePrivilege && !isInRemovingState;
    }

    @ModelMetadata(type={"com.vmware.wcp.WorkloadModel"}, property="com.vmware.wcp.WorkloadModel/supervisorId")
    public String getSupervisorId(URI namespaceUrn) {
        String property;
        String serverGuid = VapiUriSchemeUtil.getNodeUuid((URI)namespaceUrn);
        boolean isZoneSupported = this._vcCapabilityCache.isZoneSupported(serverGuid);
        String string = property = isZoneSupported ? "supervisor_id" : "cluster";
        if (isZoneSupported) {
            String supervisorId = (String)this.queryProperty(property, namespaceUrn);
            if (supervisorId == null || supervisorId.isEmpty()) {
                return null;
            }
            return VapiUriSchemeUtil.createUri((String)"com.vmware.wcp.SupervisorModel", (String)supervisorId, (String)serverGuid).toString();
        }
        ManagedObjectReference clusterRef = (ManagedObjectReference)this.queryProperty(property, namespaceUrn);
        String clusterId = ManagedObjectUtil.morefToString((ManagedObjectReference)clusterRef);
        if (clusterId.isEmpty()) {
            return null;
        }
        return clusterId;
    }

    @ModelMetadata(type={"com.vmware.wcp.WorkloadModel"}, property="com.vmware.wcp.WorkloadModel/supervisorName")
    public String getSupervisorName(URI namespaceUrn) {
        boolean isZoneSupported = this._vcCapabilityCache.isZoneSupported(VapiUriSchemeUtil.getNodeUuid((URI)namespaceUrn));
        String property = isZoneSupported ? "supervisor_name" : "cluster_name";
        return (String)this.queryProperty(property, namespaceUrn);
    }

    private PropertyPredicate newClusterByNamespacePropPredicate(URI namespaceUri) {
        return new PropertyPredicate("cluster/@deprecatedInverse", PropertyPredicate.ComparisonOperator.EQUAL, (Object)namespaceUri);
    }

    private <T> T queryProperty(String property, URI namespaceUrn) {
        ResultSet resultSet = this._queryService.select(new String[]{property}).from(new String[]{"com.vmware.wcp.WorkloadModel"}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)namespaceUrn).fetch();
        if (resultSet.getItems().isEmpty() || resultSet.getItems().get(0) == null) {
            return null;
        }
        return (T)((ResourceItem)resultSet.getItems().get(0)).get(property);
    }
}

