/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.wcp.util;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.HashMap;
import java.util.Map;

public class VcCapabilityCache {
    private final String ZONE_SUPPORTED_CAPABILITY_PROPERTY = "capability.zoneSupported";
    private final QueryService _queryService;
    private final Map<String, Map<String, Boolean>> _cache = new HashMap<String, Map<String, Boolean>>();

    public VcCapabilityCache(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    public boolean isZoneSupported(String serverGuid) {
        return this.isCapabilitySupported("capability.zoneSupported", serverGuid);
    }

    private boolean isCapabilitySupported(String capability, String serverGuid) {
        if (!this._cache.containsKey(serverGuid)) {
            this._cache.put(serverGuid, new HashMap());
        }
        if (!this._cache.get(serverGuid).containsKey(capability)) {
            ManagedObjectReference serviceInstanceRef = new ManagedObjectReference(ServiceInstance.class.getSimpleName(), ServiceInstance.class.getSimpleName(), serverGuid);
            ResultSet rs = this._queryService.select(new String[]{capability}).from(new String[]{ServiceInstance.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)serviceInstanceRef).fetch();
            boolean isCapabilitySupported = Boolean.TRUE.equals(((ResourceItem)rs.getItems().get(0)).get(capability));
            this._cache.get(serverGuid).put(capability, isCapabilitySupported);
        }
        return this._cache.get(serverGuid).get(capability);
    }
}

