/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.wcp.util;

import com.vmware.vsphere.client.commonservice.util.model.CertificateExtendedInfo;
import com.vmware.vsphere.client.h5.wcp.util.CertificateSchema;
import com.vmware.vsphere.client.h5.wcp.util.StoreEntityAdapter;
import java.math.BigInteger;

public final class WcpCertificateHelper {
    public static StoreEntityAdapter tlsTypesToVecsEntry(CertificateExtendedInfo info, String alias, String certType) {
        StoreEntityAdapter vecsEntryAdapter = new StoreEntityAdapter();
        vecsEntryAdapter.certificateChain = new CertificateSchema[1];
        vecsEntryAdapter.alias = alias;
        vecsEntryAdapter.type = certType;
        vecsEntryAdapter.date = info.certificateInfo.validTo.getTime();
        vecsEntryAdapter.certificateChain[0] = WcpCertificateHelper.getCertScheme(info, alias);
        return vecsEntryAdapter;
    }

    private static CertificateSchema getCertScheme(CertificateExtendedInfo info, String alias) {
        CertificateSchema certificateSchema = new CertificateSchema();
        certificateSchema.alias = alias;
        certificateSchema.issuer = info.certificateInfo.issuerNameCN;
        certificateSchema.subject = info.certificateInfo.subjectName;
        certificateSchema.version = info.certificateInfo.version;
        certificateSchema.validFrom = info.certificateInfo.validFrom.getTime();
        certificateSchema.validTo = info.certificateInfo.validTo.getTime();
        certificateSchema.algorithm = info.certificateInfo.algorithmName;
        certificateSchema.isExpired = info.isExpired;
        certificateSchema.issuerDnMap = info.issuerDnMap;
        certificateSchema.subjectDnMap = info.subjectDnMap;
        BigInteger serialNumber = new BigInteger(info.serialNumber);
        if (BigInteger.valueOf(0L).compareTo(serialNumber) < 0) {
            certificateSchema.serialNumberInHex = serialNumber.toString(16);
        }
        return certificateSchema;
    }
}

