/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.ls.authz.impl;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.authz.AuthorizationManager;
import com.vmware.sso.tokenmgmt.SsoDomainHelper;
import com.vmware.vcenter.apigw.api.sso.SsoDomain;
import com.vmware.vcenter.apigw.api.sso.tokenmgmt.SamlTokenEx;
import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class AuthorizationManagerImpl
implements AuthorizationManager {
    private static final String LS_ADMIN_SSO_GROUP = "LicenseService.Administrators";
    private static final String ADMINISTRATOR_SSO_GROUP = "Administrators";

    private static boolean isGroupInToken(String groupName, String groupDomain, SamlToken token) {
        if (token == null || token.getGroupList() == null) {
            return false;
        }
        boolean result = false;
        List tokenGroups = token.getGroupList();
        for (PrincipalId tokenGroup : tokenGroups) {
            if (!groupName.equals(tokenGroup.getName()) || !groupDomain.equals(tokenGroup.getDomain())) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public boolean isLicensingAdminPrivilegeGranted(LicenseScope scope) {
        Validate.notNull((Object)scope);
        boolean result = this.isCurrentLoggedInUserLicenseAdmin(scope);
        return result;
    }

    private boolean isCurrentLoggedInUserLicenseAdmin(LicenseScope scope) {
        String systemDomainName;
        SamlTokenEx currentLoggedInUserTokenEx;
        SsoDomain ssoDomain = this.getSsoDomain(scope);
        if (ssoDomain != null) {
            currentLoggedInUserTokenEx = AuthSessionUtil.getSsoTokenEx((SsoDomain)ssoDomain);
            systemDomainName = ssoDomain.getName();
        } else {
            SsoDomain localDomain = SsoDomainHelper.getLocal();
            currentLoggedInUserTokenEx = AuthSessionUtil.getSsoTokenEx((SsoDomain)localDomain);
            systemDomainName = localDomain.getName();
        }
        boolean result = AuthorizationManagerImpl.isGroupInToken(LS_ADMIN_SSO_GROUP, systemDomainName, currentLoggedInUserTokenEx.getToken());
        if (!result) {
            result = AuthorizationManagerImpl.isGroupInToken(ADMINISTRATOR_SSO_GROUP, systemDomainName, currentLoggedInUserTokenEx.getToken());
        }
        return result;
    }

    private SsoDomain getSsoDomain(LicenseScope scope) {
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        for (LinkedVcGroup linkedVcGroup : linkedVcGroupRegistry.getLinkedVcGroups()) {
            for (VcService vcService : linkedVcGroup.getVcServices()) {
                if (!vcService.getServiceGuid().equals(scope.getId())) continue;
                return vcService.getSsoDomain();
            }
        }
        return null;
    }
}

