/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.ls.impl;

import com.vmware.cis.license.client.LicenseClient;
import com.vmware.cis.license.client.LicenseClientFactory;
import com.vmware.cis.license.client.vmomi.VmodlContextLoader;
import com.vmware.license.client.cis.ls.InternalLicenseClientFactory;
import com.vmware.license.client.cis.ls.LsVmodlVersionSelector;
import com.vmware.license.client.cis.ls.impl.DomainSpecificLicenseClientImpl;
import com.vmware.vcenter.apigw.api.sso.SsoDomain;
import com.vmware.vim.binding.cis.license.management.SystemManagementService;
import com.vmware.vim.vmomi.client.ext.InvocationInterceptor;
import com.vmware.vim.vmomi.client.ext.ResultInterceptor;
import com.vmware.vim.vmomi.client.ext.ServerEndpointProvider;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import java.net.URI;
import java.util.concurrent.Executor;

public class OsgiLicenseClientFactoryImpl
implements InternalLicenseClientFactory {
    private final LsVmodlVersionSelector _lsVmodlVersionSelector;
    private final String _vmodlPackage;
    private final Executor _threadPool;
    private LicenseClientFactory.LicenseClientAutomaticAuthenticator _clientAuthenticator;
    private InvocationInterceptor _invocationInterceptor;
    private ResultInterceptor _resultInterceptor;

    public OsgiLicenseClientFactoryImpl(LsVmodlVersionSelector lsVmodlVersionSelectorImpl, String vmodlPackage, Executor threadPool) {
        this._lsVmodlVersionSelector = lsVmodlVersionSelectorImpl;
        this._vmodlPackage = vmodlPackage;
        this._threadPool = threadPool;
    }

    public void setClientAuthenticator(LicenseClientFactory.LicenseClientAutomaticAuthenticator clientAuthenticator) {
        this._clientAuthenticator = clientAuthenticator;
    }

    public void setInvocationInterceptor(InvocationInterceptor invocationInterceptor) {
        this._invocationInterceptor = invocationInterceptor;
    }

    public void setResultInterceptor(ResultInterceptor resultInterceptor) {
        this._resultInterceptor = resultInterceptor;
    }

    public void initVmodl() {
        ClassLoader bundleClassLoader = SystemManagementService.class.getClassLoader();
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleClassLoader);
            VmodlContextLoader.initContext((String[])new String[]{this._vmodlPackage});
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    @Override
    public LicenseClient createClient(URI licenseUri, Class<?> lsVmodlVersion, SsoDomain ssoDomain, HttpConfiguration httpConfig) {
        DomainSpecificLicenseClientImpl client = new DomainSpecificLicenseClientImpl(lsVmodlVersion, this._threadPool, licenseUri, httpConfig, this._clientAuthenticator, this._invocationInterceptor, this._resultInterceptor, ssoDomain);
        return client;
    }

    @Override
    public LicenseClient createClient(ServerEndpointProvider licenseUriProvider, Class<?> lsVmodlVersion, SsoDomain ssoDomain, HttpConfiguration httpConfig) {
        DomainSpecificLicenseClientImpl client = new DomainSpecificLicenseClientImpl(lsVmodlVersion, this._threadPool, licenseUriProvider, httpConfig, this._clientAuthenticator, this._invocationInterceptor, this._resultInterceptor, ssoDomain);
        return client;
    }
}

