/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.ls.impl;

import com.vmware.cis.license.client.LicenseClient;
import com.vmware.cis.license.client.LicenseClientFactory;
import com.vmware.license.client.cis.ls.DomainInfo;
import com.vmware.sso.tokenmgmt.SsoDomainHelper;
import com.vmware.vcenter.apigw.api.sso.ServicePrincipal;
import com.vmware.vcenter.apigw.api.sso.SsoDomain;
import com.vmware.vcenter.apigw.api.sso.tokenmgmt.SamlTokenEx;
import com.vmware.vim.sso.client.SamlToken;
import java.security.PrivateKey;
import org.apache.commons.lang3.Validate;

public class ServicePrincipalLicenseClientAutomaticAuthenticatorImpl
implements LicenseClientFactory.LicenseClientAutomaticAuthenticator {
    private final ServicePrincipal _servicePrincipal;

    public ServicePrincipalLicenseClientAutomaticAuthenticatorImpl(ServicePrincipal servicePrincipal) {
        this._servicePrincipal = (ServicePrincipal)Validate.notNull((Object)servicePrincipal);
    }

    public void login(LicenseClient licenseClient) {
        Validate.notNull((Object)licenseClient);
        SsoDomain ssoDomain = null;
        if (licenseClient instanceof DomainInfo) {
            DomainInfo domainSpecificLicenseClient = (DomainInfo)licenseClient;
            ssoDomain = domainSpecificLicenseClient.getSsoDomain();
        }
        if (ssoDomain == null) {
            ssoDomain = SsoDomainHelper.getLocal();
        }
        SamlTokenEx tokenEx = this._servicePrincipal.getToken(ssoDomain);
        SamlToken token = tokenEx.getToken();
        PrivateKey privateKey = tokenEx.getPrivateKey().orElse(null);
        licenseClient.login(token, privateKey);
    }
}

