/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.ls.topology.impl;

import com.vmware.cis.license.common.cache.Cache;
import com.vmware.cis.license.common.cache.impl.SimpleTimeBasedCacheImpl;
import com.vmware.license.client.cis.ls.topology.Folder;
import com.vmware.license.client.cis.ls.topology.LookupClient;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;

public class CacheLookupClientWrapperImpl
implements LookupClient {
    private static final int CACHE_CAPACITY = 100;
    private static final long CACHE_EXPIRATION_INTERVAL_IN_MS = TimeUnit.MINUTES.toMillis(20L);
    private static final String SERVICE_TYPE_IDENTIFIER_DELIM = "~";
    private final LookupClient _lookupClient;
    private final Cache<String, ServiceRegistration.Info[]> _serviceTypeIdentifierToServiceInfosCache;
    private final Object _serviceTypeIdentifierToServiceInfosCacheLock = new Object();

    public CacheLookupClientWrapperImpl(LookupClient lookupClient) {
        this._lookupClient = lookupClient;
        this._serviceTypeIdentifierToServiceInfosCache = new SimpleTimeBasedCacheImpl(CACHE_EXPIRATION_INTERVAL_IN_MS, 100);
    }

    private static String buildServiceTypeIdentifier(ServiceRegistration.ServiceType serviceType, Folder folder) {
        String serviceTypeId;
        Validate.notNull((Object)serviceType);
        String resultIdentifier = serviceTypeId = serviceType.getProduct() + serviceType.getType();
        if (folder != null) {
            resultIdentifier = resultIdentifier + SERVICE_TYPE_IDENTIFIER_DELIM;
            resultIdentifier = resultIdentifier + folder.getNodeId();
            resultIdentifier = resultIdentifier + SERVICE_TYPE_IDENTIFIER_DELIM;
            resultIdentifier = resultIdentifier + folder.getSiteId();
        }
        return resultIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceRegistration.Info[] searchServiceInfos(ServiceRegistration.ServiceType serviceType, Folder folder) {
        String serviceTypeIdentifier = CacheLookupClientWrapperImpl.buildServiceTypeIdentifier(serviceType, folder);
        ServiceRegistration.Info[] serviceInfos = (ServiceRegistration.Info[])this._serviceTypeIdentifierToServiceInfosCache.get((Object)serviceTypeIdentifier);
        if (serviceInfos == null) {
            Object object = this._serviceTypeIdentifierToServiceInfosCacheLock;
            synchronized (object) {
                serviceInfos = (ServiceRegistration.Info[])this._serviceTypeIdentifierToServiceInfosCache.get((Object)serviceTypeIdentifier);
                if (serviceInfos == null) {
                    serviceInfos = this._lookupClient.searchServiceInfos(serviceType, folder);
                    if (serviceInfos == null) {
                        serviceInfos = new ServiceRegistration.Info[]{};
                    }
                    this._serviceTypeIdentifierToServiceInfosCache.put((Object)serviceTypeIdentifier, (Object)serviceInfos);
                }
            }
        }
        return serviceInfos;
    }
}

