/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.ls.topology.impl;

import com.vmware.license.client.cis.ls.topology.SsoSpecificTopologyInfoProvider;
import com.vmware.license.client.cis.ls.topology.TopologyInfoRetrievalException;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;

public class SsoSpecificTopologyInfoProviderImpl
implements SsoSpecificTopologyInfoProvider {
    private final String _ssoDomainId;
    private Map<String, String> vcIdToNodeId = new HashMap<String, String>();
    private Map<String, String> nodeIdToVcId = new HashMap<String, String>();
    private List<ServiceRegistration.Info> licenseServiceInfos = new ArrayList<ServiceRegistration.Info>();
    private String _localVcId;

    public SsoSpecificTopologyInfoProviderImpl(String ssoDomainId) {
        this._ssoDomainId = ssoDomainId;
    }

    public void addLicenseServiceInfo(ServiceRegistration.Info licenseServiceInfo) {
        this.licenseServiceInfos.add(licenseServiceInfo);
    }

    public void addVcIdToNodeIdMappings(String vcId, String nodeId) {
        this.vcIdToNodeId.put(vcId, nodeId);
        this.nodeIdToVcId.put(nodeId, vcId);
    }

    @Override
    public String getSsoDomainId() {
        return this._ssoDomainId;
    }

    @Override
    public boolean containsNodeId(String nodeId) {
        return this.nodeIdToVcId.containsKey(nodeId);
    }

    @Override
    public boolean containsVcId(String vcId) {
        return this.vcIdToNodeId.containsKey(vcId);
    }

    public void setLocalVcId(String vcId) {
        this._localVcId = vcId;
    }

    @Override
    public int getLicenseServicesCount() throws TopologyInfoRetrievalException {
        return this.licenseServiceInfos.size();
    }

    @Override
    public String getLicenseServiceVersion() throws TopologyInfoRetrievalException {
        if (CollectionUtils.isEmpty(this.licenseServiceInfos)) {
            throw new TopologyInfoRetrievalException("No license services are found!");
        }
        ServiceRegistration.Info lsServiceInfo = this.licenseServiceInfos.get(0);
        return lsServiceInfo.serviceVersion;
    }

    @Override
    public String getLocalVcId() throws TopologyInfoRetrievalException {
        Iterator<Map.Entry<String, String>> iterator;
        if (this._localVcId == null && (iterator = this.vcIdToNodeId.entrySet().iterator()).hasNext()) {
            this._localVcId = iterator.next().getKey();
        }
        return this._localVcId;
    }

    @Override
    public Map<String, String> getVcIdToNodeId(List<String> vcIds) throws TopologyInfoRetrievalException {
        HashMap<String, String> vcIdToNodeId = new HashMap<String, String>();
        if (vcIds == null || vcIds.isEmpty()) {
            return vcIdToNodeId;
        }
        HashSet<String> uniqueVcIds = new HashSet<String>(vcIds);
        for (String vcId : uniqueVcIds) {
            String nodeId = this.vcIdToNodeId.get(vcId);
            if (nodeId == null) continue;
            vcIdToNodeId.put(vcId, nodeId);
        }
        return vcIdToNodeId;
    }

    @Override
    public Map<String, String> getNodeIdToVcId(List<String> nodeIds) throws TopologyInfoRetrievalException {
        HashMap<String, String> nodeIdToVcId = new HashMap<String, String>();
        if (nodeIds == null || nodeIds.isEmpty()) {
            return nodeIdToVcId;
        }
        HashSet<String> uniqueNodeIds = new HashSet<String>(nodeIds);
        for (String nodeId : uniqueNodeIds) {
            String vcId = this.nodeIdToVcId.get(nodeId);
            if (vcId == null) continue;
            nodeIdToVcId.put(nodeId, vcId);
        }
        return nodeIdToVcId;
    }
}

