/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.adapter;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.authz.AuthorizationException;
import com.vmware.license.client.cis.ls.authz.AuthorizationManager;
import com.vmware.license.client.cis.management.AssetType;
import com.vmware.license.client.cis.management.AssetUpdateLicenseSpec;
import com.vmware.license.client.cis.management.AssetUpdateNewLicenseSpec;
import com.vmware.license.client.cis.management.LicenseSearchProperties;
import com.vmware.license.client.cis.management.ManagementException;
import com.vmware.license.client.cis.management.ManagementObjectsFormatter;
import com.vmware.license.client.cis.management.VpxManagementEditor;
import com.vmware.license.client.cis.management.VsphereObjectAssetSpec;
import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.management.ds.AssetLicenseState;
import com.vmware.license.client.cis.management.ds.AssignLicenseAggregatedUsages;
import com.vmware.license.client.cis.management.ds.AssignLicenseUnsupportedFeatures;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.LicenseAssignInfo;
import com.vmware.license.client.cis.management.ds.LicenseAssignRestriction;
import com.vmware.license.client.cis.management.ds.LicenseType;
import com.vmware.license.client.cis.management.ds.ProductCapability;
import com.vmware.license.client.cis.management.ds.results.AssetAssignLicenseValidationResult;
import com.vmware.license.client.cis.management.ds.specs.AddLicensePreviewSpec;
import com.vmware.license.client.cis.management.ds.specs.AssetAssignLicenseConnectInfoValidateSpec;
import com.vmware.license.client.cis.management.ds.specs.AssetAssignLicenseSpec;
import com.vmware.license.client.cis.management.ds.specs.AssetAssignLicenseValidateSpec;
import com.vmware.license.client.cis.management.ds.specs.AssetAssignSubscriptionConnectInfoValidateSpec;
import com.vmware.license.client.cis.management.ds.specs.AssetRemoveSpec;
import com.vmware.license.client.cis.management.ds.specs.LicenseCreateSpec;
import com.vmware.license.client.cis.management.ds.specs.LicensePreviewSpec;
import com.vmware.license.client.cis.management.util.AssetUtil;
import com.vmware.license.client.cis.management.util.AssignLicenseUnsupportedFeaturesUtil;
import com.vmware.license.client.cis.management.util.AssignLicenseUsageCalculationUtil;
import com.vmware.license.client.cis.management.util.HostConnectionUtil;
import com.vmware.license.client.cis.management.util.LicenseUtil;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.license.client.cis.util.MutationUtil;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.uri.resolve.VapiUriSchemeUtil;
import com.vmware.vise.util.ObjectUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AssetMutationProvider
implements MutationProvider {
    private static final String SOURCE_ID_KEY = "sourceId";
    private static final String SOURCE_ID_VC_VALUE = "vc";
    private final Log _logger = LogFactory.getLog(AssetMutationProvider.class);
    private final VpxManagementEditor _vpxManagementEditor;
    private final ManagementObjectsFormatter _managementObjectsFormatter;
    private final AuthorizationManager _authorizationManager;

    public AssetMutationProvider(VpxManagementEditor vpxManagementEditor, ManagementObjectsFormatter managementObjectsFormatter, AuthorizationManager authorizationManager) {
        this._vpxManagementEditor = vpxManagementEditor;
        this._managementObjectsFormatter = managementObjectsFormatter;
        this._authorizationManager = authorizationManager;
    }

    public OperationResult[] applyOnMultiEntity(URI[] assetUris, AssetAssignLicenseSpec spec) {
        try {
            URI licenseRef = spec.licenseRef;
            UriUtil.validateLicenseUri(licenseRef);
            boolean isEvaluationLicense = LicenseUtil.EVALUATION_LICENSE_URI.equals(licenseRef);
            AssetUpdateLicenseSpec[] assetUpdateLicenseSpecs = this.createAssetUpdateLicenseSpecs(assetUris, licenseRef, isEvaluationLicense);
            this._vpxManagementEditor.updateAssetsLicense(assetUpdateLicenseSpecs);
            return MutationUtil.createOperationResults(assetUris);
        }
        catch (Exception e) {
            this.logError(e);
            return MutationUtil.createOperationResults(e);
        }
    }

    public OperationResult[] applyOnMultiEntity(URI[] assetUris, LicenseCreateSpec licenseCreateSpec) {
        try {
            AssetUpdateNewLicenseSpec[] assetUpdateLicenseSpecs = this.createAssetUpdateLicenseSpecsForNonExistingLicense(assetUris, licenseCreateSpec.serialKeys, licenseCreateSpec.name);
            this._vpxManagementEditor.updateAssetsWithNewLicense(assetUpdateLicenseSpecs);
            return MutationUtil.createOperationResults(assetUris);
        }
        catch (Throwable t) {
            this.logError(t);
            return MutationUtil.createOperationResults(t);
        }
    }

    public OperationResult[] removeOnMultiEntity(URI[] assetUris, AssetRemoveSpec removeSpec) {
        try {
            this._vpxManagementEditor.unregisterAssets(assetUris);
            return MutationUtil.createOperationResults(assetUris);
        }
        catch (Exception e) {
            this.logError(e);
            return MutationUtil.createOperationResults(e);
        }
    }

    public ValidationResult[] validateOnMultiEntity(Object[] assetRefs, AssetAssignLicenseValidateSpec spec) {
        try {
            if (ArrayUtils.isEmpty((Object[])assetRefs)) {
                throw new IllegalArgumentException("The entities array should not be empty");
            }
            Asset[] assets = this.getAssets(assetRefs, spec.assetType);
            License[] licenses = this.getSkLicenses(LicenseScopeUtil.getLicenseScopeByUiObjectUri(assets[0].getUri()));
            boolean isSubscription = LicenseUtil.areLicensesOnSubscription(licenses);
            return this.validateMultiAssetsAssignments(assets, licenses, spec.initialLicensesRefs, isSubscription);
        }
        catch (Exception e) {
            this.logError(e);
            return MutationUtil.createValidationResults(e);
        }
    }

    public ValidationResult validate(AssetAssignLicenseConnectInfoValidateSpec spec) {
        try {
            License[] licenses;
            if (spec.scope == null || spec.connectInfo == null) {
                throw new IllegalArgumentException("Scope and connectInfo should not be empty");
            }
            LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiScope(spec.scope);
            boolean licensingAdminPrivilegeGranted = this.checkLicensingAdminPrivilege(scope);
            if (licensingAdminPrivilegeGranted) {
                try {
                    if (spec.licenses != null) {
                        licenses = spec.licenses;
                    }
                    licenses = this.getSkLicenses(scope);
                }
                catch (ManagementException e) {
                    if (ManagementException.ReasonType.NOT_AUTHORIZED.equals((Object)e.getReasonType())) {
                        this._logger.warn((Object)"No licensing privilege is granted. Continuing add host wizard with eval option only.");
                        licenses = new License[]{};
                    }
                    throw e;
                }
            } else if (LicenseUtil.areLicensesOnSubscription(spec.licenses)) {
                this._logger.warn((Object)"No licensing privilege is granted. The retrieved licenses are for subscription so proceed with them.");
                licenses = spec.licenses;
            } else {
                this._logger.warn((Object)"No licensing privilege is granted. Continuing add host wizard with eval option only.");
                licenses = new License[]{};
            }
            boolean isSubscription = LicenseUtil.areLicensesOnSubscription(licenses);
            Asset hostAsset = HostConnectionUtil.previewHostAsset(spec.connectInfo, licenses, isSubscription);
            return this.validateAddHostAssignment(hostAsset, licenses, spec.initialLicensesRefs, isSubscription);
        }
        catch (Exception e) {
            this.logError(e);
            return MutationUtil.createValidationResult(e);
        }
    }

    public ValidationResult validate(AssetAssignSubscriptionConnectInfoValidateSpec spec) {
        try {
            AssetAssignLicenseConnectInfoValidateSpec licenseSpec = this.buildAssignLicenseSpec(spec);
            return this.validate(licenseSpec);
        }
        catch (Exception e) {
            this.logError(e);
            return MutationUtil.createValidationResult(e);
        }
    }

    public ValidationResult[] validateOnMultiEntity(Object[] assetRefs, AddLicensePreviewSpec spec) {
        try {
            License[] skLicenses;
            if (ArrayUtils.isEmpty((Object[])assetRefs)) {
                throw new IllegalArgumentException("The entities array should not be empty");
            }
            if (spec == null || ArrayUtils.isEmpty((Object[])spec.serialKeys) || spec.serialKeys.length != 1) {
                throw new IllegalArgumentException("A single serial key is expected");
            }
            LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiScope(spec.scope);
            License[] allLicenses = this._vpxManagementEditor.getLicenses(licenseScope, null);
            String[] newLicensesNames = LicenseUtil.getNewLicensesNames(1, allLicenses.length);
            License existingLicense = LicenseUtil.getLicenseBySerialKey(spec.serialKeys[0], allLicenses);
            if (existingLicense == null) {
                LicensePreviewSpec[] licensePreviewSpecs = LicenseUtil.buildLicensePreviewSpecs(new AddLicensePreviewSpec[]{spec}, newLicensesNames);
                skLicenses = this._vpxManagementEditor.previewLicenses(licensePreviewSpecs);
                skLicenses[0].setUri(LicenseUtil.NEW_LICENSE_URI);
            } else {
                skLicenses = new License[]{existingLicense};
            }
            License[] allSerialKeyLicenses = LicenseUtil.getSerialKeyLicenses(allLicenses);
            LicenseUtil.validateSkLicenses(skLicenses, allSerialKeyLicenses);
            Asset[] assets = this.getAssets(assetRefs, spec.assetType);
            boolean isSubscription = LicenseUtil.areLicensesOnSubscription(allSerialKeyLicenses);
            return this.validateMultiAssetsAssignments(assets, skLicenses, null, isSubscription);
        }
        catch (Throwable t) {
            this.logError(t);
            return MutationUtil.createValidationResults(t);
        }
    }

    private boolean checkLicensingAdminPrivilege(LicenseScope scope) {
        boolean licensingAdminPrivilegeGranted = false;
        try {
            licensingAdminPrivilegeGranted = this._authorizationManager.isLicensingAdminPrivilegeGranted(scope);
        }
        catch (AuthorizationException e) {
            this._logger.warn((Object)"Cannot retrieve privileges data: ", (Throwable)e);
        }
        return licensingAdminPrivilegeGranted;
    }

    private AssetAssignLicenseConnectInfoValidateSpec buildAssignLicenseSpec(AssetAssignSubscriptionConnectInfoValidateSpec spec) {
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiScope(spec.scope);
        LicenseSearchProperties licenseSearchProperties = new LicenseSearchProperties();
        licenseSearchProperties.setLicenseType(LicenseType.SUBSCRIPTION);
        License[] licenses = this._vpxManagementEditor.getLicenses(new URI[]{spec.subscriptionLicenseRef}, scope, licenseSearchProperties);
        AssetAssignLicenseConnectInfoValidateSpec licenseSpec = new AssetAssignLicenseConnectInfoValidateSpec();
        licenseSpec.scope = spec.scope;
        licenseSpec.connectInfo = spec.connectInfo;
        licenseSpec.licenses = licenses;
        return licenseSpec;
    }

    private Asset[] getAssets(Object[] assetRefs, AssetType assetType) {
        LicenseScope scope;
        URI[] assetUris;
        boolean areLicenseServiceAssetUris = false;
        if (assetRefs instanceof URI[]) {
            assetUris = (URI[])assetRefs;
            areLicenseServiceAssetUris = !VapiUriSchemeUtil.isVapiUri((URI)assetUris[0]);
            scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(assetUris[0]);
        } else if (assetRefs instanceof ManagedObjectReference[]) {
            ManagedObjectReference[] assetMoRefs = (ManagedObjectReference[])assetRefs;
            if (!LicenseScopeUtil.doAssetsHaveSameScope(assetMoRefs)) {
                throw new IllegalArgumentException("The entities array should have the same license scope");
            }
            scope = LicenseScopeUtil.getLicenseScopeByMoRef(assetMoRefs[0]);
        } else {
            throw new IllegalArgumentException("The entities array should be either a URI array or an array with a single ManagedObjectReference");
        }
        if (areLicenseServiceAssetUris) {
            assetUris = (URI[])assetRefs;
            return this._vpxManagementEditor.getAssets(assetUris, scope);
        }
        VsphereObjectAssetSpec[] vsphereObjectAssetSpecs = Arrays.asList(assetRefs).stream().collect(Collectors.mapping(assetRef -> new VsphereObjectAssetSpec<Object>(assetRef, assetType), Collectors.toList())).toArray(new VsphereObjectAssetSpec[0]);
        return this._vpxManagementEditor.getAssetsByVsphereObjectRefs(vsphereObjectAssetSpecs, scope);
    }

    private void logError(Throwable t) {
        if (this._logger.isErrorEnabled()) {
            this._logger.error((Object)"Unable to execute asset mutation operation: ", t);
        }
    }

    private AssetUpdateLicenseSpec[] createAssetUpdateLicenseSpecs(URI[] assetUris, URI licenseUri, boolean placeInEvaluation) {
        if (ArrayUtils.isEmpty((Object[])assetUris)) {
            return new AssetUpdateLicenseSpec[0];
        }
        AssetUpdateLicenseSpec[] result = new AssetUpdateLicenseSpec[assetUris.length];
        for (int i = 0; i < assetUris.length; ++i) {
            result[i] = new AssetUpdateLicenseSpec(assetUris[i], licenseUri, placeInEvaluation);
        }
        return result;
    }

    private AssetUpdateNewLicenseSpec[] createAssetUpdateLicenseSpecsForNonExistingLicense(URI[] assetUris, String[] serialKeys, String newLicenseName) {
        if (ArrayUtils.isEmpty((Object[])assetUris) || ArrayUtils.isEmpty((Object[])serialKeys) || StringUtils.isEmpty((String)newLicenseName.trim())) {
            return new AssetUpdateNewLicenseSpec[0];
        }
        AssetUpdateNewLicenseSpec[] result = new AssetUpdateNewLicenseSpec[assetUris.length];
        for (int i = 0; i < assetUris.length; ++i) {
            AssetUpdateNewLicenseSpec spec = new AssetUpdateNewLicenseSpec();
            spec.assetUri = assetUris[i];
            spec.serialKeys = serialKeys;
            spec.newLicenseName = newLicenseName;
            result[i] = spec;
        }
        return result;
    }

    private License[] getSkLicenses(LicenseScope scope) {
        LicenseSearchProperties properties = new LicenseSearchProperties();
        properties.setLicenseType(LicenseType.SERIAL_KEY);
        License[] resultSkLicenses = this._vpxManagementEditor.getLicenses(scope, properties);
        return resultSkLicenses;
    }

    private ValidationResult[] validateMultiAssetsAssignments(Asset[] assets, License[] licenses, URI[] initialLicensesRefs, boolean isSubscription) {
        ValidationResult result = this.createAssignLicenseValidationResult(assets, licenses, true, null, false, initialLicensesRefs, isSubscription);
        return new ValidationResult[]{result};
    }

    private ValidationResult createAssignLicenseValidationResult(Asset[] assets, License[] licenses, boolean isAssetDlfVersionSupported, URI licenseFromAnotherVcRef, boolean allEoemlicensesRestricted, URI[] initialLicensesRefs, boolean isSubscription) {
        LicenseAssignInfo[] applicableLicensesAssignInfos = this.getApplicableLicensesAssignInfos(assets, licenses, isAssetDlfVersionSupported, allEoemlicensesRestricted, isSubscription);
        License[] applicableLicenses = this.getLicensesFromLicenseAssignInfos(applicableLicensesAssignInfos);
        AssignLicenseAggregatedUsages assignLicenseAggregatedUsages = AssignLicenseUsageCalculationUtil.createAssignLicenseAggregatedUsages(assets, applicableLicenses);
        AssignLicenseUnsupportedFeatures assignLicenseUnsupportedFeatures = AssignLicenseUnsupportedFeaturesUtil.createAssignLicenseUnsupportedFeatures(assets, applicableLicenses);
        this._managementObjectsFormatter.formatLicenses(applicableLicenses);
        this._managementObjectsFormatter.formatAssets(assets);
        AssetAssignLicenseValidationResult result = this.createAssetAssignLicenseValidationResult(assets, applicableLicensesAssignInfos, assignLicenseAggregatedUsages, assignLicenseUnsupportedFeatures, isAssetDlfVersionSupported, licenseFromAnotherVcRef, initialLicensesRefs, isSubscription);
        return MutationUtil.createValidationResult(result);
    }

    private LicenseAssignInfo[] getApplicableLicensesAssignInfos(Asset[] assets, License[] licenses, boolean checkLicenseCapability, boolean allEoemLicensesRestricted, boolean isSubscription) {
        ArrayList<LicenseAssignInfo> licensesAssignInfos = new ArrayList<LicenseAssignInfo>();
        LicenseAssignInfo evaluationLicenseAssignInfo = this.createEvaluationLicenseAssignInfo(assets);
        if (evaluationLicenseAssignInfo != null && !isSubscription) {
            licensesAssignInfos.add(evaluationLicenseAssignInfo);
        }
        if (!ArrayUtils.isEmpty((Object[])licenses)) {
            for (License license : licenses) {
                if (!AssetUtil.isLicenseApplicableForAssets(license, assets, checkLicenseCapability)) continue;
                Set<LicenseAssignRestriction> licenseAssignRestrictions = AssetUtil.getLicenseAssignRestrictionsForAssets(license, assets);
                if (allEoemLicensesRestricted && LicenseUtil.isEmbeddedOemLicense(license)) {
                    licenseAssignRestrictions.add(LicenseAssignRestriction.EmbeddedOemLicense);
                }
                LicenseAssignInfo licenseAssignInfo = this.createLicenseAssignInfo(license, licenseAssignRestrictions, false);
                licensesAssignInfos.add(licenseAssignInfo);
            }
        }
        return licensesAssignInfos.toArray(new LicenseAssignInfo[licensesAssignInfos.size()]);
    }

    private LicenseAssignInfo createEvaluationLicenseAssignInfo(Asset[] assets) {
        HashSet<LicenseAssignRestriction> licenseAssignRestrictions = new HashSet<LicenseAssignRestriction>();
        boolean doAllAssetsHaveEvaluationInfo = true;
        boolean isEvaluationExpirationTimeMixed = false;
        Long commonEvaluationExpirationTime = assets[0].getEvaluationLicense() == null ? null : assets[0].getEvaluationLicense().getExpirationTime();
        for (Asset asset : assets) {
            License assetEvaluationLicense = asset.getEvaluationLicense();
            if (assetEvaluationLicense == null) {
                doAllAssetsHaveEvaluationInfo = false;
                break;
            }
            Set<LicenseAssignRestriction> assignRestrictions = AssetUtil.getLicenseAssignRestrictionsForAsset(assetEvaluationLicense, asset);
            licenseAssignRestrictions.addAll(assignRestrictions);
            Long assetEvaluationExpirationTime = assetEvaluationLicense.getExpirationTime();
            if (isEvaluationExpirationTimeMixed || ObjectUtil.compare((Comparable)commonEvaluationExpirationTime, (Comparable)assetEvaluationExpirationTime) == 0) continue;
            isEvaluationExpirationTimeMixed = true;
            commonEvaluationExpirationTime = null;
        }
        if (!doAllAssetsHaveEvaluationInfo) {
            return null;
        }
        License evaluationLicense = LicenseUtil.createEvaluationLicense(commonEvaluationExpirationTime);
        return this.createLicenseAssignInfo(evaluationLicense, licenseAssignRestrictions, isEvaluationExpirationTimeMixed);
    }

    private LicenseAssignInfo createLicenseAssignInfo(License license, Set<LicenseAssignRestriction> licenseAssignRestrictions, boolean isExpirationTimeMixed) {
        LicenseAssignInfo result = new LicenseAssignInfo();
        result.setLicense(license);
        result.setExpirationTimeMixed(isExpirationTimeMixed);
        result.setAssignRestrictions(licenseAssignRestrictions.toArray(new LicenseAssignRestriction[licenseAssignRestrictions.size()]));
        return result;
    }

    private License[] getLicensesFromLicenseAssignInfos(LicenseAssignInfo[] licenseAssignInfos) {
        License[] result = new License[licenseAssignInfos.length];
        for (int i = 0; i < licenseAssignInfos.length; ++i) {
            result[i] = licenseAssignInfos[i].getLicense();
        }
        return result;
    }

    private AssetAssignLicenseValidationResult createAssetAssignLicenseValidationResult(Asset[] assets, LicenseAssignInfo[] licensesAssignInfos, AssignLicenseAggregatedUsages assignLicenseAggregatedUsages, AssignLicenseUnsupportedFeatures assignLicenseUnsupportedFeatures, boolean isAssetDlfVersionSupported, URI licenseFromAnotherVcRef, URI[] existingLicenseRefs, boolean isSubscription) {
        AssetAssignLicenseValidationResult result = new AssetAssignLicenseValidationResult();
        this.initializeAssetProperties(result, assets, licensesAssignInfos, isAssetDlfVersionSupported, isSubscription);
        this.initializeLicenseProperties(result, licensesAssignInfos, assignLicenseAggregatedUsages, assignLicenseUnsupportedFeatures, licenseFromAnotherVcRef, existingLicenseRefs);
        return result;
    }

    private void initializeAssetProperties(AssetAssignLicenseValidationResult result, Asset[] assets, LicenseAssignInfo[] licensesAssignInfos, boolean isAssetDlfVersionSupported, boolean isSubscription) {
        result.assets = assets;
        result.assetRefToName = this.buildAssetRefToNameMap(assets);
        result.isAssetDlfVersionSupported = isAssetDlfVersionSupported;
        Asset firstAsset = assets[0];
        AssetLicenseState assetsCommonLicenseState = firstAsset.getLicenseState();
        URI assetsCommonLicenseRef = firstAsset.getLicense() == null ? null : firstAsset.getLicense().getUri();
        int embeddedOemLicensedAssetsCount = 0;
        for (Asset asset : assets) {
            URI assetLicenseRef;
            if (assetsCommonLicenseState != asset.getLicenseState()) {
                assetsCommonLicenseState = null;
            }
            URI uRI = assetLicenseRef = asset.getLicense() == null ? null : asset.getLicense().getUri();
            if (assetsCommonLicenseRef != null && !assetsCommonLicenseRef.equals(assetLicenseRef)) {
                assetsCommonLicenseRef = null;
            }
            if (!LicenseUtil.isEmbeddedOemLicense(asset.getLicense())) continue;
            ++embeddedOemLicensedAssetsCount;
        }
        result.assetsCommonLicenseState = assetsCommonLicenseState;
        if (AssetLicenseState.EVALUATION.equals((Object)assetsCommonLicenseState) && !isSubscription) {
            LicenseAssignInfo evaluationLicenseAssignInfo = this.getEvaluationLicenseAssignInfo(licensesAssignInfos);
            result.assetsCommonLicenseRef = evaluationLicenseAssignInfo.getLicense().getUri();
        } else {
            result.assetsCommonLicenseRef = assetsCommonLicenseRef;
        }
        result.embeddedOemLicensedAssetsCount = embeddedOemLicensedAssetsCount;
    }

    private void initializeLicenseProperties(AssetAssignLicenseValidationResult result, LicenseAssignInfo[] licensesAssignInfos, AssignLicenseAggregatedUsages assignLicenseAggregatedUsages, AssignLicenseUnsupportedFeatures assignLicenseUnsupportedFeatures, URI licenseFromAnotherVcRef, URI[] existingLicenseRefs) {
        this.updateLicensesAssignRestrictions(result, licensesAssignInfos);
        result.aggregatedUsages = assignLicenseAggregatedUsages;
        result.unsupportedFeatures = assignLicenseUnsupportedFeatures;
        result.licenseFromAnotherVcRef = licenseFromAnotherVcRef;
        LicenseAssignInfo evaluationLicenseAssignInfo = this.getEvaluationLicenseAssignInfo(licensesAssignInfos);
        if (evaluationLicenseAssignInfo != null) {
            result.isEvaluationExpirationTimeMixed = evaluationLicenseAssignInfo.isExpirationTimeMixed();
        }
        LicensesAssignInfosData licenseAssignInfosData = new LicensesAssignInfosData(licensesAssignInfos, existingLicenseRefs, result.assetsCommonLicenseRef);
        result.licensesAssignInfos = licenseAssignInfosData.getSortedLicensesAssignInfos();
        result.newLicensesRefs = licenseAssignInfosData._newLicensesRefs;
        result.areAllLicensesUnassignable = licenseAssignInfosData.areAllLicensesUnassignable();
    }

    private Map<URI, String> buildAssetRefToNameMap(Asset[] assets) {
        HashMap<URI, String> assetRefToName = new HashMap<URI, String>();
        for (Asset asset : assets) {
            assetRefToName.put(asset.getUri(), asset.getName());
        }
        return assetRefToName;
    }

    private LicenseAssignInfo getEvaluationLicenseAssignInfo(LicenseAssignInfo[] licensesAssignInfos) {
        if (ArrayUtils.isEmpty((Object[])licensesAssignInfos)) {
            return null;
        }
        LicenseAssignInfo firstLicenseAssignInfo = licensesAssignInfos[0];
        if (firstLicenseAssignInfo.getLicense().getIsEvaluation()) {
            return firstLicenseAssignInfo;
        }
        return null;
    }

    private void updateLicensesAssignRestrictions(AssetAssignLicenseValidationResult result, LicenseAssignInfo[] licensesAssignInfos) {
        for (LicenseAssignInfo licenseAssignInfo : licensesAssignInfos) {
            URI licenseRef = licenseAssignInfo.getLicense().getUri();
            if (!licenseRef.equals(result.assetsCommonLicenseRef)) continue;
            licenseAssignInfo.setAssignRestrictions(null);
        }
    }

    private ValidationResult validateAddHostAssignment(Asset hostAsset, License[] licenses, URI[] initialLicensesRefs, boolean isSubscription) {
        License hostLicense;
        boolean isAssetDlfVersionSupported = this.isHostDlfVersionSupported(hostAsset, licenses);
        URI licenseFromAnotherVcRef = null;
        if (AssetLicenseState.LICENSED.equals((Object)hostAsset.getLicenseState()) && !this.isHostLicensePresent(hostLicense = hostAsset.getLicense(), licenses)) {
            licenses = !isSubscription ? (License[])ArrayUtils.add((Object[])licenses, (Object)hostLicense) : licenses;
            licenseFromAnotherVcRef = this.isHostAssetLicensedInAnotherVc(hostAsset) ? hostLicense.getUri() : null;
        }
        return this.createAssignLicenseValidationResult(new Asset[]{hostAsset}, licenses, isAssetDlfVersionSupported, licenseFromAnotherVcRef, true, initialLicensesRefs, isSubscription);
    }

    private boolean isHostDlfVersionSupported(Asset hostAsset, License[] licenses) {
        for (License license : licenses) {
            if (!AssetUtil.isLicenseApplicableForAsset(license, hostAsset, true)) continue;
            return true;
        }
        return false;
    }

    private boolean isHostLicensePresent(License hostLicense, License[] licenses) {
        String serialKey = hostLicense.getSerialKeys()[0];
        for (License license : licenses) {
            if (!LicenseUtil.hasSerialKey(serialKey, license)) continue;
            return true;
        }
        return false;
    }

    private boolean isHostAssetLicensedInAnotherVc(Asset hostAsset) {
        ProductCapability assetProductCapability = AssetUtil.getAssetProductCapability(hostAsset);
        if (assetProductCapability == null) {
            throw new IllegalArgumentException("No capability found for host: " + hostAsset.getName());
        }
        KeyAnyValue[] assetLicenseProperties = assetProductCapability.getProperties();
        String sourceIdValue = (String)ManagementUtil.getKeyAnyValuePropertyValue(SOURCE_ID_KEY, assetLicenseProperties);
        return SOURCE_ID_VC_VALUE.equals(sourceIdValue);
    }

    private class LicensesAssignInfosData {
        private Set<URI> _newLicensesRefs = new HashSet<URI>();
        private URI _assetsCommonLicenseRef;
        private List<LicenseAssignInfo> _assignableLicensesAssignInfos = new ArrayList<LicenseAssignInfo>();
        private List<LicenseAssignInfo> _unassignableLicensesAssignInfos = new ArrayList<LicenseAssignInfo>();

        public LicensesAssignInfosData(LicenseAssignInfo[] licensesAssignInfos, URI[] initialLicensesRefs, URI assetsCommonLicenseRef) {
            HashSet<URI> newLicensesRefs = new HashSet<URI>();
            ArrayList<LicenseAssignInfo> assignableLicensesAssignInfos = new ArrayList<LicenseAssignInfo>();
            ArrayList<LicenseAssignInfo> unassignableLicensesAssignInfos = new ArrayList<LicenseAssignInfo>();
            LicenseAssignInfo[] licenseAssignInfoArray = licensesAssignInfos;
            int n = licenseAssignInfoArray.length;
            for (int i = 0; i < n; ++i) {
                LicenseAssignInfo licenseAssignInfo;
                URI licenseRef;
                HashSet<Object> initialLicensesRefsSet = initialLicensesRefs == null ? new HashSet() : new HashSet<URI>(Arrays.asList(initialLicensesRefs));
                if (!initialLicensesRefsSet.contains(licenseRef = (licenseAssignInfo = licenseAssignInfoArray[i]).getLicense().getUri())) {
                    newLicensesRefs.add(licenseRef);
                }
                if (this.isAssignable(licenseAssignInfo)) {
                    assignableLicensesAssignInfos.add(licenseAssignInfo);
                    continue;
                }
                unassignableLicensesAssignInfos.add(licenseAssignInfo);
            }
            this._assetsCommonLicenseRef = assetsCommonLicenseRef;
            this._newLicensesRefs = newLicensesRefs;
            this._assignableLicensesAssignInfos = assignableLicensesAssignInfos;
            this._unassignableLicensesAssignInfos = unassignableLicensesAssignInfos;
        }

        private boolean isAssignable(LicenseAssignInfo licenseAssignInfo) {
            if (licenseAssignInfo == null) {
                return false;
            }
            LicenseAssignRestriction[] licenseAssignRestrictions = licenseAssignInfo.getAssignRestrictions();
            return ArrayUtils.isEmpty((Object[])licenseAssignRestrictions);
        }

        public LicenseAssignInfo[] getSortedLicensesAssignInfos() {
            ArrayList<LicenseAssignInfo> result = new ArrayList<LicenseAssignInfo>();
            List<LicenseAssignInfo> sortedAssignableLicensesAssignInfos = this.getSortedAssignableLicenseAssignInfos();
            result.addAll(sortedAssignableLicensesAssignInfos);
            result.addAll(this._unassignableLicensesAssignInfos);
            return result.toArray(new LicenseAssignInfo[result.size()]);
        }

        public boolean areAllLicensesUnassignable() {
            return CollectionUtils.isEmpty(this._assignableLicensesAssignInfos);
        }

        private List<LicenseAssignInfo> getSortedAssignableLicenseAssignInfos() {
            LicenseAssignInfo assetsCommonLicenseAssignInfo = null;
            ArrayList<LicenseAssignInfo> newLicensesAssignInfos = new ArrayList<LicenseAssignInfo>();
            ArrayList<LicenseAssignInfo> unassignedLicensesAssignInfos = new ArrayList<LicenseAssignInfo>();
            ArrayList<LicenseAssignInfo> assignedLicensesAssignInfos = new ArrayList<LicenseAssignInfo>();
            LicenseAssignInfo evaluationLicenseAssignInfo = null;
            for (LicenseAssignInfo licenseAssignInfo : this._assignableLicensesAssignInfos) {
                URI licenseRef = licenseAssignInfo.getLicense().getUri();
                if (licenseRef.equals(this._assetsCommonLicenseRef)) {
                    assetsCommonLicenseAssignInfo = licenseAssignInfo;
                    continue;
                }
                if (this.isNewLicense(licenseAssignInfo)) {
                    newLicensesAssignInfos.add(licenseAssignInfo);
                    continue;
                }
                if (this.isEvaluationLicense(licenseAssignInfo)) {
                    evaluationLicenseAssignInfo = licenseAssignInfo;
                    continue;
                }
                if (this.isAssignedLicense(licenseAssignInfo)) {
                    assignedLicensesAssignInfos.add(licenseAssignInfo);
                    continue;
                }
                unassignedLicensesAssignInfos.add(licenseAssignInfo);
            }
            ArrayList<LicenseAssignInfo> result = new ArrayList<LicenseAssignInfo>();
            result.addAll(newLicensesAssignInfos);
            this.addIfNotNull(result, assetsCommonLicenseAssignInfo);
            result.addAll(unassignedLicensesAssignInfos);
            result.addAll(assignedLicensesAssignInfos);
            this.addIfNotNull(result, evaluationLicenseAssignInfo);
            return result;
        }

        private boolean isNewLicense(LicenseAssignInfo licenseAssignInfo) {
            URI licenseRef = licenseAssignInfo.getLicense().getUri();
            return this._newLicensesRefs.contains(licenseRef);
        }

        private boolean isEvaluationLicense(LicenseAssignInfo licenseAssignInfo) {
            return licenseAssignInfo.getLicense().getIsEvaluation();
        }

        private boolean isAssignedLicense(LicenseAssignInfo licenseAssignInfo) {
            return licenseAssignInfo.getLicense().isAssigned();
        }

        private void addIfNotNull(List<LicenseAssignInfo> resultItems, LicenseAssignInfo item) {
            if (item != null) {
                resultItems.add(item);
            }
        }
    }
}

