/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.adapter;

import com.vmware.license.client.cis.ds.LicenseUiScope;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.LicenseSearchProperties;
import com.vmware.license.client.cis.management.ManagementEditor;
import com.vmware.license.client.cis.management.adapter.BaseManagementDataProviderAdapterImpl;
import com.vmware.license.client.cis.management.adapter.BasePropertyProviderBean;
import com.vmware.license.client.cis.management.adapter.LicensePropertyProviderBean;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.LicenseType;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.type;
import java.net.URI;

@type(value="License")
public class LicenseDataProviderAdapterImpl
extends BaseManagementDataProviderAdapterImpl<License> {
    private static final String RELATION_LICENSES = "licenses";
    private static final String PROPERTY_NAME_LICENSE_TYPE = "licenseType";
    private static final String PROPERTY_NAME_LICENSE_ASSIGNED = "licenseAssigned";
    private final ManagementEditor _managementEditor;

    private static boolean canHandleRelation(Object[] objectsRefs, String relation) {
        return RELATION_LICENSES.equals(relation) && UriUtil.containsSingleUriWithType(objectsRefs, "Product");
    }

    private static URI getProductUri(Object[] objectsRefs) {
        return (URI)objectsRefs[0];
    }

    public LicenseDataProviderAdapterImpl(ManagementEditor managementEditor) {
        this._managementEditor = managementEditor;
    }

    @Override
    protected BasePropertyProviderBean<License> getPropertyProvider() {
        return new LicensePropertyProviderBean();
    }

    @Override
    protected String getProvidedType() {
        return "License";
    }

    @Override
    protected URI getUri(License license) {
        return license.getUri();
    }

    protected License[] getObjectsByScope(LicenseScope scope) {
        return this._managementEditor.getLicenses(scope, null);
    }

    protected License[] getObjectsByCompositeConstraint(CompositeConstraint cc) {
        if (cc.nestedConstraints.length > 1 && !Conjoiner.AND.equals((Object)cc.conjoiner)) {
            return (License[])super.getObjectsByCompositeConstraint(cc);
        }
        LicenseConstraintProperties constraintProperties = this.getConstraintProperties(cc.nestedConstraints);
        LicenseSearchProperties searchProperties = new LicenseSearchProperties();
        searchProperties.setLicenseType(constraintProperties.licenseType);
        searchProperties.setLicenseAssigned(constraintProperties.licenseAssigned);
        License[] resultLicenses = null;
        if (constraintProperties.licenseUiScope != null) {
            LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiScope(constraintProperties.licenseUiScope);
            resultLicenses = this._managementEditor.getLicenses(scope, searchProperties);
        } else {
            resultLicenses = constraintProperties.productUri != null ? this._managementEditor.getLicensesForProduct(constraintProperties.productUri, searchProperties) : (License[])super.getObjectsByCompositeConstraint(cc);
        }
        return resultLicenses;
    }

    protected License[] getObjectsByUrisAndScope(URI[] licenseUris, LicenseScope scope) {
        return this._managementEditor.getLicenses(licenseUris, scope, null);
    }

    protected License[] getRelatedObjects(Object[] objectsRefs, String relation) {
        if (!LicenseDataProviderAdapterImpl.canHandleRelation(objectsRefs, relation)) {
            return (License[])super.getRelatedObjects(objectsRefs, relation);
        }
        URI productUri = LicenseDataProviderAdapterImpl.getProductUri(objectsRefs);
        return this._managementEditor.getLicensesForProduct(productUri, null);
    }

    private LicenseConstraintProperties getConstraintProperties(Constraint[] constraints) {
        LicenseConstraintProperties constraintProperties = new LicenseConstraintProperties();
        for (Constraint constraint : constraints) {
            if (constraint instanceof PropertyConstraint) {
                PropertyConstraint pc = (PropertyConstraint)constraint;
                this.updateLicenseConstraintProperties(constraintProperties, pc);
                continue;
            }
            if (!(constraint instanceof RelationalConstraint)) continue;
            RelationalConstraint rc = (RelationalConstraint)constraint;
            this.updateLicenseConstraintProperties(constraintProperties, rc);
        }
        return constraintProperties;
    }

    private void updateLicenseConstraintProperties(LicenseConstraintProperties constraintProperties, PropertyConstraint pc) {
        if ("scope".equals(pc.propertyName)) {
            if (pc.comparableValue instanceof String) {
                constraintProperties.licenseUiScope = new LicenseUiScope();
                constraintProperties.licenseUiScope.setId((String)pc.comparableValue);
            } else {
                constraintProperties.licenseUiScope = (LicenseUiScope)pc.comparableValue;
            }
        } else if (PROPERTY_NAME_LICENSE_TYPE.equals(pc.propertyName)) {
            constraintProperties.licenseType = pc.comparableValue instanceof String ? LicenseType.valueOf((String)pc.comparableValue) : (LicenseType)((Object)pc.comparableValue);
        } else if (PROPERTY_NAME_LICENSE_ASSIGNED.equals(pc.propertyName)) {
            constraintProperties.licenseAssigned = (Boolean)pc.comparableValue;
        }
    }

    private void updateLicenseConstraintProperties(LicenseConstraintProperties constraintProperties, RelationalConstraint rc) {
        Object[] queriedObjectsRefs = Utils.getEnumeratedObjects((RelationalConstraint)rc);
        if (!LicenseDataProviderAdapterImpl.canHandleRelation(queriedObjectsRefs, rc.relation)) {
            return;
        }
        constraintProperties.productUri = LicenseDataProviderAdapterImpl.getProductUri(queriedObjectsRefs);
    }

    private static class LicenseConstraintProperties {
        public LicenseUiScope licenseUiScope;
        public LicenseType licenseType;
        public Boolean licenseAssigned;
        public URI productUri;

        private LicenseConstraintProperties() {
        }
    }
}

