/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.adapter;

import com.vmware.license.client.cis.ds.LicenseUiScope;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.ManagementEditor;
import com.vmware.license.client.cis.management.ManagementObjectsFormatter;
import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.results.AssignLicensePreviewResult;
import com.vmware.license.client.cis.management.ds.results.LicensePreviewResult;
import com.vmware.license.client.cis.management.ds.specs.AddLicensePreviewSpec;
import com.vmware.license.client.cis.management.ds.specs.AssignLicensePreviewSpec;
import com.vmware.license.client.cis.management.ds.specs.LicenseCreateSpec;
import com.vmware.license.client.cis.management.ds.specs.LicensePreviewSpec;
import com.vmware.license.client.cis.management.ds.specs.LicenseUpdateSpec;
import com.vmware.license.client.cis.management.ds.specs.LicensesRemoveSpec;
import com.vmware.license.client.cis.management.util.AssetUtil;
import com.vmware.license.client.cis.management.util.LicenseUtil;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.license.client.cis.util.MutationUtil;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LicenseMutationProvider
implements MutationProvider {
    private final Log _logger = LogFactory.getLog(LicenseMutationProvider.class);
    private final ManagementEditor _managementEditor;
    private final ManagementObjectsFormatter _managementObjectsFormatter;

    public LicenseMutationProvider(ManagementEditor managementEditor, ManagementObjectsFormatter managementObjectsFormatter) {
        this._managementEditor = managementEditor;
        this._managementObjectsFormatter = managementObjectsFormatter;
    }

    public OperationResult[] addMulti(LicenseCreateSpec[] createSpecs) {
        try {
            Object[] licenseUris = this._managementEditor.addLicenses(createSpecs);
            return MutationUtil.createOperationResults(licenseUris);
        }
        catch (Exception e) {
            this.logError(e);
            return MutationUtil.createOperationResults(e);
        }
    }

    public OperationResult apply(URI licenseUri, LicenseUpdateSpec updateSpec) {
        try {
            this._managementEditor.updateLicenses(new LicenseUpdateSpec[]{updateSpec});
            return MutationUtil.createOperationResult(licenseUri);
        }
        catch (Exception e) {
            this.logError(e);
            return MutationUtil.createOperationResult(e);
        }
    }

    public OperationResult[] removeOnMultiEntity(URI[] licenseUris, LicensesRemoveSpec removeSpec) {
        try {
            this._managementEditor.removeLicenses(licenseUris);
            return MutationUtil.createOperationResults(licenseUris);
        }
        catch (Exception e) {
            this.logError(e);
            return MutationUtil.createOperationResults(e);
        }
    }

    public ValidationResult[] validateMultiSpec(AddLicensePreviewSpec[] specs) {
        try {
            ValidationResult[] validationResults;
            LicenseUiScope licenseUiScope = specs[0].scope;
            boolean areAllVcsOnSubscription = specs[0].areAllVcsOnSubscription;
            LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiScope(licenseUiScope);
            License[] allLicenses = this._managementEditor.getLicenses(scope, null);
            String[] newLicensesNames = LicenseUtil.getNewLicensesNames(specs.length, allLicenses.length);
            LicensePreviewSpec[] licensePreviewSpecs = LicenseUtil.buildLicensePreviewSpecs(specs, newLicensesNames);
            License[] allSerialKeyLicenses = LicenseUtil.getSerialKeyLicenses(allLicenses);
            License[] skLicenses = this._managementEditor.previewLicenses(licensePreviewSpecs);
            if (areAllVcsOnSubscription) {
                LicenseUtil.validateSkLicensesOnSubscription(skLicenses);
            }
            LicenseUtil.validateSkLicenses(skLicenses, allSerialKeyLicenses);
            this._managementObjectsFormatter.formatLicenses(skLicenses);
            if (specs instanceof AssignLicensePreviewSpec[]) {
                AssignLicensePreviewSpec[] assignSpecs = (AssignLicensePreviewSpec[])specs;
                validationResults = this.createAssignLicensePreviewResults(skLicenses, assignSpecs[0].assets, assignSpecs[0].areAssetsDlfVersionsSupported);
            } else {
                validationResults = this.createLicensePreviewResults(skLicenses);
            }
            return validationResults;
        }
        catch (Exception e) {
            this.logError(e);
            return MutationUtil.createValidationResults(e);
        }
    }

    private void logError(Throwable t) {
        if (this._logger.isErrorEnabled()) {
            this._logger.error((Object)"Unable to execute license mutation operation: ", t);
        }
    }

    private ValidationResult[] createAssignLicensePreviewResults(License[] licenses, Asset[] assets, boolean areAssetsDlfVersionsSupported) {
        ValidationResult[] results = new ValidationResult[licenses.length];
        for (int i = 0; i < results.length; ++i) {
            AssignLicensePreviewResult result = new AssignLicensePreviewResult();
            result.license = licenses[i];
            result.isApplicableForAllAssets = AssetUtil.isLicenseApplicableForAssets(licenses[i], assets, areAssetsDlfVersionsSupported);
            results[i] = MutationUtil.createValidationResult(result);
        }
        return results;
    }

    private ValidationResult[] createLicensePreviewResults(License[] licenses) {
        ValidationResult[] results = new ValidationResult[licenses.length];
        for (int i = 0; i < results.length; ++i) {
            LicensePreviewResult result = new LicensePreviewResult();
            result.license = licenses[i];
            results[i] = MutationUtil.createValidationResult(result);
        }
        return results;
    }
}

