/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.impl;

import com.vmware.cis.license.client.LicenseClient;
import com.vmware.license.client.cis.ds.LicenseUiScope;
import com.vmware.license.client.cis.ls.LicenseClientProvider;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.AssetSearchProperties;
import com.vmware.license.client.cis.management.AssetType;
import com.vmware.license.client.cis.management.AssetUpdateLicenseSpec;
import com.vmware.license.client.cis.management.AssetUpdateNewLicenseSpec;
import com.vmware.license.client.cis.management.LicenseSearchProperties;
import com.vmware.license.client.cis.management.ManagementEditor;
import com.vmware.license.client.cis.management.ManagementException;
import com.vmware.license.client.cis.management.ds.LicenseType;
import com.vmware.license.client.cis.management.ds.Product;
import com.vmware.license.client.cis.management.ds.ProductAggregation;
import com.vmware.license.client.cis.management.ds.ProductRestriction;
import com.vmware.license.client.cis.management.ds.specs.BaseLicenseSpec;
import com.vmware.license.client.cis.management.ds.specs.LicenseCreateSpec;
import com.vmware.license.client.cis.management.ds.specs.LicensePreviewSpec;
import com.vmware.license.client.cis.management.ds.specs.LicenseUpdateSpec;
import com.vmware.license.client.cis.management.util.AssetUtil;
import com.vmware.license.client.cis.management.util.LicenseUtil;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.management.util.ProductUtil;
import com.vmware.license.client.cis.management.util.SubscriptionLicensingUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.vim.binding.cis.license.Asset;
import com.vmware.vim.binding.cis.license.License;
import com.vmware.vim.binding.cis.license.LicenseInfo;
import com.vmware.vim.binding.cis.license.LicenseUtilization;
import com.vmware.vim.binding.cis.license.ProductUtilization;
import com.vmware.vim.binding.cis.license.management.AssetSearchSpec;
import com.vmware.vim.binding.cis.license.management.AssetSearchSpecByLicenseState;
import com.vmware.vim.binding.cis.license.management.LicenseAddSpec;
import com.vmware.vim.binding.cis.license.management.LicenseSearchSpec;
import com.vmware.vim.binding.cis.license.management.ProductSearchSpec;
import com.vmware.vim.binding.cis.license.management.SystemManagementService;
import com.vmware.vim.binding.impl.cis.license.management.AssetSearchSpecByIdsImpl;
import com.vmware.vim.binding.impl.cis.license.management.AssetSearchSpecByLicenseIdImpl;
import com.vmware.vim.binding.impl.cis.license.management.AssetSearchSpecByLicenseStateImpl;
import com.vmware.vim.binding.impl.cis.license.management.AssetSearchSpecByProductFamilyNamesImpl;
import com.vmware.vim.binding.impl.cis.license.management.AssetSearchSpecByProductIdImpl;
import com.vmware.vim.binding.impl.cis.license.management.AssetSearchSpecImpl;
import com.vmware.vim.binding.impl.cis.license.management.AssetUpdateLicenseSpecImpl;
import com.vmware.vim.binding.impl.cis.license.management.LicenseSearchSpecByIdsImpl;
import com.vmware.vim.binding.impl.cis.license.management.LicenseSearchSpecByProductIdImpl;
import com.vmware.vim.binding.impl.cis.license.management.ProductSearchSpecByIdsImpl;
import com.vmware.vim.binding.impl.cis.license.management.ProductSearchSpecByLicenseIdImpl;
import com.vmware.vim.binding.impl.cis.license.management.SerialKeyLicenseAddSpecImpl;
import com.vmware.vim.binding.impl.cis.license.management.SerialKeyLicenseUpdateSpecImpl;
import com.vmware.vim.binding.vmodl.MethodFault;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;

public class ManagementEditorImpl
implements ManagementEditor {
    private static final int ASSETS_REQUEST_SIZE = 200;
    private static final int MAX_ASSETS_SEARCH_STEP = 800;
    private static final int MAX_ALLOWED_ASSETS_REQUEST_SIZE = 15000;
    private final Map<String, Integer> _cachedTotalAssetsCountPerRequestObject;
    private final LicenseClientProvider _licenseClientProvider;

    private static LicenseUtilization[] filterLicenseUtilizationsBySearchProperties(LicenseUtilization[] licenseUtilizations, LicenseSearchProperties properties) {
        if (ArrayUtils.isEmpty((Object[])licenseUtilizations) || properties == null) {
            return licenseUtilizations;
        }
        LicenseType expectedLicenseType = properties.getLicenseType();
        Boolean expectedLicenesAssigned = properties.isLicenseAssigned();
        if (expectedLicenseType == null && expectedLicenesAssigned == null) {
            return licenseUtilizations;
        }
        ArrayList<LicenseUtilization> resultLicenseUtilizations = new ArrayList<LicenseUtilization>();
        for (LicenseUtilization licenseUtilization : licenseUtilizations) {
            boolean isLicenseAssigned;
            LicenseType licenseType;
            if (expectedLicenseType != null && !expectedLicenseType.equals((Object)(licenseType = ManagementEditorImpl.getLicenseType(licenseUtilization))) || expectedLicenesAssigned != null && !expectedLicenesAssigned.equals(isLicenseAssigned = licenseUtilization.isIsLicenseAssigned())) continue;
            resultLicenseUtilizations.add(licenseUtilization);
        }
        return resultLicenseUtilizations.toArray(new LicenseUtilization[resultLicenseUtilizations.size()]);
    }

    private static LicenseType getLicenseType(LicenseUtilization licenseUtilization) {
        LicenseType resultLicenseType = null;
        resultLicenseType = SubscriptionLicensingUtil.isSubscriptionLicenseUtilization(licenseUtilization) ? LicenseType.SUBSCRIPTION : LicenseType.SERIAL_KEY;
        return resultLicenseType;
    }

    private static AssetSearchSpec createAssetSearchSpecByProductFamilyNames(AssetSearchProperties properties) {
        AssetSearchSpecImpl searchSpec;
        String productFamilyName = ProductUtil.getProductFamilyName(properties.getType());
        if (AssetType.ALL.equals((Object)properties.getType())) {
            searchSpec = new AssetSearchSpecImpl();
        } else {
            AssetSearchSpecByProductFamilyNamesImpl productFamilyNameSpec = new AssetSearchSpecByProductFamilyNamesImpl();
            if (productFamilyName != null) {
                String[] productFamilyNames = new String[]{productFamilyName};
                productFamilyNameSpec.setProductFamilyNames(productFamilyNames);
            } else {
                String[] productFamilyNames = new String[]{"VMware ESX Server", "VMware VirtualCenter Server", "VMware VSAN", "VMware Tanzu"};
                productFamilyNameSpec.setProductFamilyNames(productFamilyNames);
                productFamilyNameSpec.setInverseSearch(Boolean.valueOf(true));
            }
            searchSpec = productFamilyNameSpec;
        }
        ManagementEditorImpl.updateAssetSearchSpecByProperties((AssetSearchSpec)searchSpec, properties);
        return searchSpec;
    }

    private static void updateAssetSearchSpecByProperties(AssetSearchSpec assetSearchSpec, AssetSearchProperties properties) {
        String scopeId = properties.getScopeId();
        Boolean excludeSubscribed = properties.getExcludeSubscribed();
        Integer maxResults = properties.getMaxResultObjects();
        Integer offset = properties.getOffset();
        assetSearchSpec.setScopeId(scopeId);
        assetSearchSpec.setExcludeSubscribed(excludeSubscribed);
        assetSearchSpec.setMaxResults(maxResults);
        assetSearchSpec.setOffset(offset);
    }

    private static AssetSearchSpec createAssetSearchSpecByProductId(String productId, AssetSearchProperties properties) {
        AssetSearchSpecByProductIdImpl searchSpec = new AssetSearchSpecByProductIdImpl();
        ManagementEditorImpl.updateAssetSearchSpecByProperties((AssetSearchSpec)searchSpec, properties);
        searchSpec.setProductId(productId);
        return searchSpec;
    }

    private static AssetSearchSpec createAssetSearchSpecByLicenseState(AssetSearchSpecByLicenseState.LicenseState licenseState, AssetSearchProperties properties) {
        AssetSearchSpecByLicenseStateImpl searchSpec = new AssetSearchSpecByLicenseStateImpl();
        ManagementEditorImpl.updateAssetSearchSpecByProperties((AssetSearchSpec)searchSpec, properties);
        searchSpec.setLicenseState(licenseState.name());
        return searchSpec;
    }

    private static AssetSearchSpec createAssetSearchSpecByLicenseId(URI licenseId, String productFamilyName, AssetSearchProperties properties) {
        AssetSearchSpecByLicenseIdImpl searchSpec = new AssetSearchSpecByLicenseIdImpl();
        ManagementEditorImpl.updateAssetSearchSpecByProperties((AssetSearchSpec)searchSpec, properties);
        searchSpec.setLicenseId(licenseId);
        searchSpec.setProductFamilyName(productFamilyName);
        return searchSpec;
    }

    private static Asset[] filterAssetsByLicenseId(Asset[] assets, URI licenseId) {
        if (ArrayUtils.isEmpty((Object[])assets)) {
            return new Asset[0];
        }
        ArrayList<Asset> resultAssets = new ArrayList<Asset>();
        for (Asset asset : assets) {
            URI assetLicenseId;
            License assetLicense = asset.getInfo().getLicense();
            if (assetLicense == null || !(assetLicenseId = assetLicense.getId()).equals(licenseId)) continue;
            resultAssets.add(asset);
        }
        return resultAssets.toArray(new Asset[resultAssets.size()]);
    }

    private static ProductAggregation[] createProductAggregations(ProductUtilization[] productUtilizations, LicenseUtilization[] licenseUtilizations, LicenseScope scope, boolean filterSubscription) {
        if (ArrayUtils.isEmpty((Object[])productUtilizations)) {
            return new ProductAggregation[0];
        }
        com.vmware.license.client.cis.management.ds.License[] licenses = LicenseUtil.createLicenses(licenseUtilizations, scope);
        Map<URI, List<com.vmware.license.client.cis.management.ds.License>> licensesByProductUri = ManagementEditorImpl.getLicensesByProductUri(licenses);
        ArrayList<ProductAggregation> productAggregations = new ArrayList<ProductAggregation>();
        for (int i = 0; i < productUtilizations.length; ++i) {
            ProductUtilization productUtilization = productUtilizations[i];
            com.vmware.vim.binding.cis.license.Product cisProduct = productUtilization.getProduct();
            Product product = ProductUtil.createProduct(cisProduct, productUtilization.getCostUnitsUsage(), productUtilization.getCostUnitsLimit(), scope);
            if (product == null) continue;
            ProductAggregation productAggregation = new ProductAggregation();
            productAggregation.setProduct(product);
            List<com.vmware.license.client.cis.management.ds.License> productLicenses = licensesByProductUri.get(product.getUri());
            if (filterSubscription) {
                productLicenses = ManagementEditorImpl.extractNonSubscriptionLicenses(productLicenses);
            }
            productAggregation.setLicenses(productLicenses.toArray(new com.vmware.license.client.cis.management.ds.License[productLicenses.size()]));
            if (filterSubscription && productLicenses.size() == 0) continue;
            productAggregations.add(productAggregation);
        }
        return productAggregations.toArray(new ProductAggregation[productAggregations.size()]);
    }

    private static Map<URI, List<com.vmware.license.client.cis.management.ds.License>> getLicensesByProductUri(com.vmware.license.client.cis.management.ds.License[] licenses) {
        HashMap<URI, List<com.vmware.license.client.cis.management.ds.License>> result = new HashMap<URI, List<com.vmware.license.client.cis.management.ds.License>>();
        for (com.vmware.license.client.cis.management.ds.License license : licenses) {
            for (ProductRestriction productRestriction : license.getProductRestrictions()) {
                URI productUri = productRestriction.getProduct().getUri();
                ArrayList<com.vmware.license.client.cis.management.ds.License> productLicenses = (ArrayList<com.vmware.license.client.cis.management.ds.License>)result.get(productUri);
                if (productLicenses == null) {
                    productLicenses = new ArrayList<com.vmware.license.client.cis.management.ds.License>();
                    result.put(productUri, productLicenses);
                }
                productLicenses.add(license);
            }
        }
        return result;
    }

    private static LicenseAddSpec[] createLicenseAddSpecs(BaseLicenseSpec[] clientSpecs) {
        LicenseAddSpec[] result = new LicenseAddSpec[clientSpecs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new SerialKeyLicenseAddSpecImpl(clientSpecs[i].name, clientSpecs[i].serialKeys);
        }
        return result;
    }

    private static com.vmware.vim.binding.cis.license.management.LicenseUpdateSpec[] createServiceLicenseUpdateSpecs(LicenseUpdateSpec[] clientSpecs) {
        com.vmware.vim.binding.cis.license.management.LicenseUpdateSpec[] result = new com.vmware.vim.binding.cis.license.management.LicenseUpdateSpec[clientSpecs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new SerialKeyLicenseUpdateSpecImpl(UriUtil.extractObjectIdAsUri(clientSpecs[i].uri), clientSpecs[i].name, clientSpecs[i].serialKeys);
        }
        return result;
    }

    private static com.vmware.vim.binding.cis.license.management.AssetUpdateLicenseSpec[] createAssetUpdateLicenseSpecs(AssetUpdateLicenseSpec[] specs) {
        com.vmware.vim.binding.cis.license.management.AssetUpdateLicenseSpec[] serviceSpecs = new com.vmware.vim.binding.cis.license.management.AssetUpdateLicenseSpec[specs.length];
        for (int i = 0; i < specs.length; ++i) {
            UriUtil.validateAssetUri(specs[i].getAssetRef());
            URI licenseId = null;
            if (specs[i].getLicenseRef() != null && !specs[i].isPlaceInEvaluation()) {
                UriUtil.validateLicenseUri(specs[i].getLicenseRef());
                licenseId = UriUtil.extractObjectIdAsUri(specs[i].getLicenseRef());
            }
            URI assetId = UriUtil.extractObjectIdAsUri(specs[i].getAssetRef());
            serviceSpecs[i] = new AssetUpdateLicenseSpecImpl(assetId, licenseId, null, specs[i].isPlaceInEvaluation());
        }
        return serviceSpecs;
    }

    private static com.vmware.vim.binding.cis.license.management.AssetUpdateLicenseSpec[] createAssetUpdateLicenseSpecs(AssetUpdateNewLicenseSpec[] specs) {
        com.vmware.vim.binding.cis.license.management.AssetUpdateLicenseSpec[] serviceSpecs = new com.vmware.vim.binding.cis.license.management.AssetUpdateLicenseSpec[specs.length];
        for (int i = 0; i < specs.length; ++i) {
            UriUtil.validateAssetUri(specs[i].assetUri);
            SerialKeyLicenseAddSpecImpl licenseAddSpec = new SerialKeyLicenseAddSpecImpl(specs[i].newLicenseName, specs[i].serialKeys);
            AssetUpdateLicenseSpecImpl serviceSpec = new AssetUpdateLicenseSpecImpl();
            serviceSpec.setLicenseAddSpec((LicenseAddSpec)licenseAddSpec);
            serviceSpec.setAssetId(UriUtil.extractObjectIdAsUri(specs[i].assetUri));
            serviceSpec.setPlaceInEval(false);
            serviceSpecs[i] = serviceSpec;
        }
        return serviceSpecs;
    }

    private static List<com.vmware.license.client.cis.management.ds.License> extractNonSubscriptionLicenses(List<com.vmware.license.client.cis.management.ds.License> licenses) {
        ArrayList<com.vmware.license.client.cis.management.ds.License> nonSubsriptionLicenses = new ArrayList<com.vmware.license.client.cis.management.ds.License>();
        if (CollectionUtils.isEmpty(licenses)) {
            return nonSubsriptionLicenses;
        }
        for (com.vmware.license.client.cis.management.ds.License license : licenses) {
            if (license.isSubscription()) continue;
            nonSubsriptionLicenses.add(license);
        }
        return nonSubsriptionLicenses;
    }

    public ManagementEditorImpl(LicenseClientProvider licenseClientProvider) {
        this._licenseClientProvider = licenseClientProvider;
        this._cachedTotalAssetsCountPerRequestObject = new ConcurrentHashMap<String, Integer>();
    }

    @Override
    public com.vmware.license.client.cis.management.ds.License[] getLicenses(URI[] licenseUris, LicenseScope scope, LicenseSearchProperties properties) {
        UriUtil.validateLicenseUris(licenseUris);
        URI[] licenseUrisWithoutEvaluationLicense = this.excludeEvaluationLicenseUri(licenseUris);
        LicenseUtilization[] licenseUtilizations = null;
        if (licenseUrisWithoutEvaluationLicense.length > 0) {
            Object[] licenseIds = UriUtil.extractObjectIdsAsUris(licenseUrisWithoutEvaluationLicense);
            LicenseSearchSpecByIdsImpl searchSpec = null;
            if (!ArrayUtils.isEmpty((Object[])licenseIds)) {
                searchSpec = new LicenseSearchSpecByIdsImpl((URI[])licenseIds);
            }
            licenseUtilizations = this.searchLicenseUtilizations((LicenseSearchSpec)searchSpec, scope);
            licenseUtilizations = ManagementEditorImpl.filterLicenseUtilizationsBySearchProperties(licenseUtilizations, properties);
        }
        ArrayList<com.vmware.license.client.cis.management.ds.License> licensesResult = new ArrayList<com.vmware.license.client.cis.management.ds.License>();
        if (licenseUris.length > licenseUrisWithoutEvaluationLicense.length) {
            licensesResult.add(LicenseUtil.createEvaluationLicense(0L));
        }
        Collections.addAll(licensesResult, LicenseUtil.createLicenses(licenseUtilizations, scope));
        return licensesResult.toArray(new com.vmware.license.client.cis.management.ds.License[0]);
    }

    @Override
    public com.vmware.license.client.cis.management.ds.License[] getLicenses(LicenseScope scope, LicenseSearchProperties properties) {
        Validate.notNull((Object)scope);
        LicenseUtilization[] licenseUtilizations = this.searchLicenseUtilizations(null, scope);
        licenseUtilizations = ManagementEditorImpl.filterLicenseUtilizationsBySearchProperties(licenseUtilizations, properties);
        com.vmware.license.client.cis.management.ds.License[] resultLicenses = LicenseUtil.createLicenses(licenseUtilizations, scope);
        return resultLicenses;
    }

    @Override
    public com.vmware.license.client.cis.management.ds.License[] getLicensesForProduct(URI productUri, LicenseSearchProperties properties) {
        UriUtil.validateProductUri(productUri);
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(productUri);
        String productId = UriUtil.extractObjectIdAsString(productUri);
        LicenseSearchSpecByProductIdImpl searchSpec = new LicenseSearchSpecByProductIdImpl(productId);
        LicenseUtilization[] licenseUtilizations = this.searchLicenseUtilizations((LicenseSearchSpec)searchSpec, scope);
        licenseUtilizations = ManagementEditorImpl.filterLicenseUtilizationsBySearchProperties(licenseUtilizations, properties);
        return LicenseUtil.createLicenses(licenseUtilizations, scope);
    }

    @Override
    public ProductAggregation[] getProductAggregations(URI[] productUris, LicenseScope scope) {
        UriUtil.validateProductUris(productUris);
        ProductSearchSpecByIdsImpl searchSpec = null;
        boolean filterSubscription = true;
        if (!ArrayUtils.isEmpty((Object[])productUris)) {
            String[] productIds = UriUtil.extractObjectIdsAsStrings(productUris);
            searchSpec = new ProductSearchSpecByIdsImpl(productIds);
            filterSubscription = false;
        }
        ProductUtilization[] productUtilizations = this.searchProductUtilizations((ProductSearchSpec)searchSpec, scope);
        LicenseUtilization[] licenseUtilizations = this.searchLicenseUtilizations(null, scope);
        return ManagementEditorImpl.createProductAggregations(productUtilizations, licenseUtilizations, scope, filterSubscription);
    }

    @Override
    public ProductAggregation[] getProductAggregationsForLicense(URI licenseUri) {
        UriUtil.validateLicenseUri(licenseUri);
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(licenseUri);
        URI licenseId = UriUtil.extractObjectIdAsUri(licenseUri);
        ProductSearchSpecByLicenseIdImpl searchSpec = new ProductSearchSpecByLicenseIdImpl(licenseId);
        ProductUtilization[] productUtilizations = this.searchProductUtilizations((ProductSearchSpec)searchSpec, scope);
        LicenseUtilization[] licenseUtilizations = this.searchLicenseUtilizations(null, scope);
        return ManagementEditorImpl.createProductAggregations(productUtilizations, licenseUtilizations, scope, false);
    }

    @Override
    public com.vmware.license.client.cis.management.ds.Asset[] getAssets(URI[] assetUris, LicenseScope scope) {
        UriUtil.validateAssetUris(assetUris);
        Object[] assetIds = UriUtil.extractObjectIdsAsUris(assetUris);
        AssetSearchSpecByIdsImpl searchSpec = null;
        if (!ArrayUtils.isEmpty((Object[])assetIds)) {
            searchSpec = new AssetSearchSpecByIdsImpl();
            searchSpec.setAssetIds((URI[])assetIds);
            searchSpec.setMaxResults(Integer.valueOf(assetIds.length));
        }
        Asset[] assets = this.searchAssets((AssetSearchSpec)searchSpec, scope);
        return this.createAssets(assets, scope);
    }

    @Override
    public com.vmware.license.client.cis.management.ds.Asset[] getAssets(LicenseScope scope, AssetSearchProperties properties) {
        Validate.notNull((Object)properties);
        Validate.notNull((Object)scope);
        AssetSearchSpec searchSpec = ManagementEditorImpl.createAssetSearchSpecByProductFamilyNames(properties);
        Asset[] serviceAssets = this.searchAssets(searchSpec, scope);
        com.vmware.license.client.cis.management.ds.Asset[] assets = this.createAssets(serviceAssets, scope);
        return assets;
    }

    @Override
    public com.vmware.license.client.cis.management.ds.Asset[] getAssetsByLicenseState(AssetSearchProperties properties, AssetSearchSpecByLicenseState.LicenseState licenseState) {
        Validate.notNull((Object)licenseState);
        Validate.notNull((Object)properties);
        AssetSearchSpec searchSpec = ManagementEditorImpl.createAssetSearchSpecByLicenseState(licenseState, properties);
        Asset[] serviceAssets = this.searchAssets(searchSpec, ManagementUtil.SCOPE_CIS_LICENSING);
        com.vmware.license.client.cis.management.ds.Asset[] assets = this.createAssets(serviceAssets, ManagementUtil.SCOPE_CIS_LICENSING);
        return assets;
    }

    @Override
    public com.vmware.license.client.cis.management.ds.Asset[] getAssetsForProduct(URI productUri, AssetSearchProperties properties) {
        UriUtil.validateProductUri(productUri);
        Validate.notNull((Object)properties);
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(productUri);
        String productId = UriUtil.extractObjectIdAsString(productUri);
        AssetSearchSpec searchSpec = ManagementEditorImpl.createAssetSearchSpecByProductId(productId, properties);
        Asset[] serviceAssets = this.searchAssets(searchSpec, scope);
        com.vmware.license.client.cis.management.ds.Asset[] assets = this.createAssets(serviceAssets, scope);
        return assets;
    }

    @Override
    public com.vmware.license.client.cis.management.ds.Asset[] getAssetsForLicense(URI licenseUri, AssetSearchProperties properties) {
        AssetSearchSpec searchSpec;
        UriUtil.validateLicenseUri(licenseUri);
        Validate.notNull((Object)properties);
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(licenseUri);
        URI licenseId = UriUtil.extractObjectIdAsUri(licenseUri);
        Asset[] serviceAssetsForLicense = null;
        String productFamilyName = ProductUtil.getProductFamilyName(properties.getType());
        if (productFamilyName != null) {
            searchSpec = ManagementEditorImpl.createAssetSearchSpecByLicenseId(licenseId, productFamilyName, properties);
            serviceAssetsForLicense = this.searchAssets(searchSpec, scope);
        } else {
            searchSpec = ManagementEditorImpl.createAssetSearchSpecByProductFamilyNames(properties);
            Asset[] serviceAssets = this.searchAssets(searchSpec, scope);
            serviceAssetsForLicense = ManagementEditorImpl.filterAssetsByLicenseId(serviceAssets, licenseId);
        }
        com.vmware.license.client.cis.management.ds.Asset[] assets = this.createAssets(serviceAssetsForLicense, scope);
        return assets;
    }

    @Override
    public Integer getTotalAssetsCount(LicenseScope scope, AssetSearchProperties properties) {
        Validate.notNull((Object)properties);
        Validate.notNull((Object)scope);
        AssetSearchSpec searchSpec = ManagementEditorImpl.createAssetSearchSpecByProductFamilyNames(properties);
        return this.getTotalAssetsCountInt(searchSpec, scope, scope.getId(), properties.getType());
    }

    @Override
    public Integer getTotalAssetsCountForLicense(URI licenseUri, AssetSearchProperties properties) {
        UriUtil.validateLicenseUri(licenseUri);
        Validate.notNull((Object)properties);
        AssetSearchSpec searchSpec = null;
        LicenseScope scope = null;
        if (LicenseUtil.EVALUATION_LICENSE_URI.equals(licenseUri)) {
            if (!AssetType.HOST.equals((Object)properties.getType())) {
                return 1;
            }
            searchSpec = ManagementEditorImpl.createAssetSearchSpecByLicenseState(AssetSearchSpecByLicenseState.LicenseState.evaluation, properties);
            scope = ManagementUtil.SCOPE_CIS_LICENSING;
        } else {
            scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(licenseUri);
            URI licenseId = UriUtil.extractObjectIdAsUri(licenseUri);
            String productFamilyName = ProductUtil.getProductFamilyName(properties.getType());
            searchSpec = ManagementEditorImpl.createAssetSearchSpecByLicenseId(licenseId, productFamilyName, properties);
        }
        return this.getTotalAssetsCountInt(searchSpec, scope, licenseUri.toString(), properties.getType());
    }

    @Override
    public Integer getTotalAssetsCountForProduct(URI productUri, AssetSearchProperties properties) {
        UriUtil.validateProductUri(productUri);
        Validate.notNull((Object)properties);
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(productUri);
        String productId = UriUtil.extractObjectIdAsString(productUri);
        AssetSearchSpec searchSpec = ManagementEditorImpl.createAssetSearchSpecByProductId(productId, properties);
        return this.getTotalAssetsCountInt(searchSpec, scope, productUri.toString(), properties.getType());
    }

    @Override
    public URI[] addLicenses(LicenseCreateSpec[] createSpecs) {
        Validate.notNull((Object)createSpecs);
        LicenseUiScope licenseUiScope = createSpecs[0].scope;
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiScope(licenseUiScope);
        SystemManagementService sms = this.getSystemManagementService(scope);
        LicenseAddSpec[] licenseAddSpecs = ManagementEditorImpl.createLicenseAddSpecs(createSpecs);
        License[] licenses = null;
        try {
            licenses = sms.addLicenses(licenseAddSpecs);
        }
        catch (MethodFault fault) {
            throw new ManagementException(fault);
        }
        return LicenseUtil.getLicenseUris(licenses, scope);
    }

    @Override
    public void updateLicenses(LicenseUpdateSpec[] updateSpecs) {
        Validate.notNull((Object)updateSpecs);
        for (LicenseUpdateSpec updateSpec : updateSpecs) {
            UriUtil.validateLicenseUri(updateSpec.uri);
        }
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(updateSpecs[0].uri);
        SystemManagementService sms = this.getSystemManagementService(scope);
        com.vmware.vim.binding.cis.license.management.LicenseUpdateSpec[] serviceUpdateSpecs = ManagementEditorImpl.createServiceLicenseUpdateSpecs(updateSpecs);
        try {
            sms.updateLicenses(serviceUpdateSpecs);
        }
        catch (MethodFault fault) {
            throw new ManagementException(fault);
        }
    }

    @Override
    public void removeLicenses(URI[] licenseUris) {
        Validate.notNull((Object)licenseUris);
        UriUtil.validateLicenseUris(licenseUris);
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(licenseUris[0]);
        SystemManagementService sms = this.getSystemManagementService(scope);
        URI[] licenseIds = UriUtil.extractObjectIdsAsUris(licenseUris);
        try {
            sms.removeLicenses(licenseIds);
        }
        catch (MethodFault fault) {
            throw new ManagementException(fault);
        }
    }

    @Override
    public com.vmware.license.client.cis.management.ds.License[] previewLicenses(LicensePreviewSpec[] previewSpecs) {
        Validate.notNull((Object)previewSpecs);
        LicenseUiScope licenseUiScope = previewSpecs[0].scope;
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiScope(licenseUiScope);
        SystemManagementService sms = this.getSystemManagementService(scope);
        LicenseAddSpec[] licenseAddSpecs = ManagementEditorImpl.createLicenseAddSpecs(previewSpecs);
        LicenseInfo[] licenseInfos = sms.previewLicenses(licenseAddSpecs);
        return LicenseUtil.createLicenses(licenseInfos, scope);
    }

    @Override
    public void updateAssetsLicense(AssetUpdateLicenseSpec[] updateSpecs) {
        Validate.notNull((Object)updateSpecs);
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(updateSpecs[0].getAssetRef());
        SystemManagementService sms = this.getSystemManagementService(scope);
        com.vmware.vim.binding.cis.license.management.AssetUpdateLicenseSpec[] serviceSpecs = ManagementEditorImpl.createAssetUpdateLicenseSpecs(updateSpecs);
        try {
            sms.updateAssetsLicense(serviceSpecs);
        }
        catch (MethodFault fault) {
            throw new ManagementException(fault);
        }
    }

    @Override
    public void updateAssetsWithNewLicense(AssetUpdateNewLicenseSpec[] assetUpdateNewLicenseSpecs) {
        Validate.notNull((Object)assetUpdateNewLicenseSpecs);
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(assetUpdateNewLicenseSpecs[0].assetUri);
        SystemManagementService sms = this.getSystemManagementService(scope);
        com.vmware.vim.binding.cis.license.management.AssetUpdateLicenseSpec[] serviceSpecs = ManagementEditorImpl.createAssetUpdateLicenseSpecs(assetUpdateNewLicenseSpecs);
        try {
            sms.updateAssetsLicense(serviceSpecs);
        }
        catch (MethodFault fault) {
            throw new ManagementException(fault);
        }
    }

    @Override
    public void unregisterAssets(URI[] assetUris) {
        Validate.notNull((Object)assetUris);
        UriUtil.validateAssetUris(assetUris);
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(assetUris[0]);
        SystemManagementService sms = this.getSystemManagementService(scope);
        URI[] assetIds = UriUtil.extractObjectIdsAsUris(assetUris);
        try {
            sms.unregisterAssets(assetIds);
        }
        catch (MethodFault fault) {
            throw new ManagementException(fault);
        }
    }

    protected Asset[] searchAssets(AssetSearchSpec searchSpec, LicenseScope scope) {
        SystemManagementService sms = this.getSystemManagementService(scope);
        Asset[] serviceAssets = null;
        if (searchSpec == null) {
            try {
                serviceAssets = sms.searchAssets(null);
            }
            catch (MethodFault fault) {
                throw new ManagementException(fault);
            }
        } else {
            serviceAssets = this.searchAssetsInt(searchSpec, sms, 200);
        }
        return serviceAssets;
    }

    Asset[] searchAssetsInt(AssetSearchSpec searchSpec, SystemManagementService sms, int pageSize) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("Page size cannot be zero or less!");
        }
        Integer maxResults = searchSpec.getMaxResults();
        maxResults = maxResults != null && maxResults > 0 ? maxResults : 15000;
        Integer offset = searchSpec.getOffset();
        offset = offset != null && offset > 0 ? offset : 0;
        List<Asset> resultAssets = new ArrayList();
        boolean hasMoreAssets = true;
        while (hasMoreAssets && resultAssets.size() < maxResults) {
            searchSpec.setMaxResults(Integer.valueOf(pageSize));
            searchSpec.setOffset(Integer.valueOf(offset + resultAssets.size()));
            Asset[] pagedAssets = null;
            try {
                pagedAssets = sms.searchAssets(searchSpec);
            }
            catch (MethodFault fault) {
                throw new ManagementException(fault);
            }
            boolean bl = hasMoreAssets = pagedAssets != null && pagedAssets.length >= pageSize;
            if (pagedAssets == null) continue;
            resultAssets.addAll(Arrays.asList(pagedAssets));
        }
        if (resultAssets.size() > maxResults) {
            resultAssets = resultAssets.subList(0, maxResults);
        }
        return resultAssets.toArray(new Asset[resultAssets.size()]);
    }

    protected com.vmware.license.client.cis.management.ds.Asset[] createAssets(Asset[] serviceAssets, LicenseScope scope) {
        if (ArrayUtils.isEmpty((Object[])serviceAssets)) {
            return new com.vmware.license.client.cis.management.ds.Asset[0];
        }
        com.vmware.license.client.cis.management.ds.Asset[] assets = new com.vmware.license.client.cis.management.ds.Asset[serviceAssets.length];
        for (int i = 0; i < assets.length; ++i) {
            assets[i] = AssetUtil.createAsset(serviceAssets[i], scope);
        }
        return assets;
    }

    private LicenseUtilization[] searchLicenseUtilizations(LicenseSearchSpec searchSpec, LicenseScope scope) {
        LicenseUtilization[] licenseUtilizations;
        SystemManagementService sms = this.getSystemManagementService(scope);
        try {
            licenseUtilizations = sms.searchLicenseUtilizations(searchSpec);
        }
        catch (MethodFault fault) {
            throw new ManagementException(fault);
        }
        return licenseUtilizations;
    }

    private SystemManagementService getSystemManagementService(LicenseScope scope) {
        LicenseClient client = this.getLicenseClient(scope);
        return client.getSystemManagementService();
    }

    private LicenseClient getLicenseClient(LicenseScope scope) {
        try {
            return this._licenseClientProvider.getLicenseClient(scope);
        }
        catch (Exception e) {
            throw new ManagementException(e);
        }
    }

    private ProductUtilization[] searchProductUtilizations(ProductSearchSpec searchSpec, LicenseScope scope) {
        ProductUtilization[] productUtilizations;
        SystemManagementService sms = this.getSystemManagementService(scope);
        try {
            productUtilizations = sms.searchProductUtilizations(searchSpec);
        }
        catch (MethodFault fault) {
            throw new ManagementException(fault);
        }
        return productUtilizations;
    }

    private URI[] excludeEvaluationLicenseUri(URI[] licenseUris) {
        ArrayList<URI> licenseUrisWithoutEvaluationLicense = new ArrayList<URI>();
        for (URI licenseUri : licenseUris) {
            if (LicenseUtil.EVALUATION_LICENSE_URI.equals(licenseUri)) continue;
            licenseUrisWithoutEvaluationLicense.add(licenseUri);
        }
        return licenseUrisWithoutEvaluationLicense.toArray(new URI[0]);
    }

    private Integer getTotalAssetsCountInt(AssetSearchSpec searchSpec, LicenseScope scope, String requestObjectId, AssetType assetType) {
        int totalItems = 0;
        String cacheKey = requestObjectId + "_" + (Object)((Object)assetType);
        Integer cachedTotalItems = this._cachedTotalAssetsCountPerRequestObject.get(cacheKey);
        totalItems = this.getTotalAssetsCountFromBaseIndex(searchSpec, scope, cachedTotalItems != null ? cachedTotalItems : 0);
        this._cachedTotalAssetsCountPerRequestObject.put(cacheKey, totalItems);
        return totalItems;
    }

    private Integer getTotalAssetsCountFromBaseIndex(AssetSearchSpec searchSpec, LicenseScope scope, int cachedTotalAssetsCount) {
        int totalItems = cachedTotalAssetsCount / 200 * 200;
        int foundUpperBound = -1;
        int foundLowerBound = -1;
        int stepSize = 0;
        int direction = 1;
        boolean hasReachedAssetsListEnd = false;
        boolean emptyResult = false;
        Asset[] assets = null;
        searchSpec.setMaxResults(Integer.valueOf(200));
        while (!hasReachedAssetsListEnd) {
            searchSpec.setOffset(Integer.valueOf(totalItems));
            assets = this.searchAssets(searchSpec, scope);
            emptyResult = assets == null || assets.length == 0;
            hasReachedAssetsListEnd = emptyResult && totalItems == 0;
            if (hasReachedAssetsListEnd |= !emptyResult && assets.length < 200) {
                stepSize = assets != null ? assets.length : 0;
                direction = 1;
            } else if (emptyResult) {
                foundUpperBound = totalItems;
                stepSize = this.calculateNextAssetsSearchStepSize(foundLowerBound, foundUpperBound);
                direction = -1;
            } else if (assets.length == 200) {
                foundLowerBound = totalItems;
                stepSize = this.calculateNextAssetsSearchStepSize(foundLowerBound, foundUpperBound);
                direction = 1;
            }
            hasReachedAssetsListEnd |= foundLowerBound != -1 && foundUpperBound != -1 && foundLowerBound + 200 >= foundUpperBound;
            totalItems += stepSize * direction;
            totalItems = Math.max(0, totalItems);
        }
        return totalItems;
    }

    private int calculateNextAssetsSearchStepSize(int lowerBound, int upperBound) {
        int stepSize = lowerBound > -1 && upperBound > -1 ? (upperBound - lowerBound) / 2 : 800;
        return Math.max(stepSize, 200);
    }
}

