/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.impl;

import com.vmware.license.client.cis.ls.LicenseClientProvider;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.topology.SsoSpecificTopologyInfoProvider;
import com.vmware.license.client.cis.ls.topology.SsoSpecificTopologyInfoProviderFactory;
import com.vmware.license.client.cis.ls.topology.TopologyInfoRetrievalException;
import com.vmware.license.client.cis.management.AssetType;
import com.vmware.license.client.cis.management.ManagementException;
import com.vmware.license.client.cis.management.VpxManagementEditor;
import com.vmware.license.client.cis.management.VsphereObjectAssetSpec;
import com.vmware.license.client.cis.management.impl.ManagementEditorImpl;
import com.vmware.license.client.cis.management.util.AssetUtil;
import com.vmware.vim.binding.cis.license.Asset;
import com.vmware.vim.binding.cis.license.AssetIdentifier;
import com.vmware.vim.binding.cis.license.management.AssetSearchSpec;
import com.vmware.vim.binding.impl.cis.license.AssetIdentifierImpl;
import com.vmware.vim.binding.impl.cis.license.management.AssetSearchSpecByIdentifiersImpl;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.uri.resolve.VapiUriSchemeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VpxManagementEditorImpl
extends ManagementEditorImpl
implements VpxManagementEditor {
    private static final String HOST_MO_TYPE = "HostSystem";
    private static final String CLUSTER_MO_TYPE = "ClusterComputeResource";
    private static final String SUPERVISOR_VAPI_TYPE = "com.vmware.wcp.SupervisorModel";
    private static final String VC_MO_VALUE = "group-d1";
    private static final String VC_MO_TYPE = "Folder";
    private static final String WCP_CLUSTER_INSTANCE_ID_PREFIX = "wcp-";
    private static final String WCP_SUPERVISOR_INSTANCE_ID_PREFIX = "wcp-supervisor-";
    private final Log _logger = LogFactory.getLog(VpxManagementEditorImpl.class);
    private final SsoSpecificTopologyInfoProviderFactory _topologyInfoProviderFactory;

    public VpxManagementEditorImpl(LicenseClientProvider licenseClientProvider, SsoSpecificTopologyInfoProviderFactory topologyInfoProviderFactory) {
        super(licenseClientProvider);
        this._topologyInfoProviderFactory = topologyInfoProviderFactory;
    }

    private static String getVsphereObjectRefInstanceId(VsphereObjectAssetSpec vsphereObjectAssetSpec) {
        String vsphereObjectType = vsphereObjectAssetSpec.getType();
        if (HOST_MO_TYPE.equals(vsphereObjectType)) {
            return vsphereObjectAssetSpec.getValue();
        }
        if (CLUSTER_MO_TYPE.equals(vsphereObjectType)) {
            String vspehreObjectInstanceId = vsphereObjectAssetSpec.getValue();
            if (AssetType.WCP_CLUSTER.equals((Object)vsphereObjectAssetSpec.getAssetType())) {
                vspehreObjectInstanceId = WCP_CLUSTER_INSTANCE_ID_PREFIX.concat(vspehreObjectInstanceId);
            }
            return vspehreObjectInstanceId;
        }
        if (SUPERVISOR_VAPI_TYPE.equals(vsphereObjectType)) {
            return WCP_SUPERVISOR_INSTANCE_ID_PREFIX.concat(vsphereObjectAssetSpec.getValue());
        }
        if (VC_MO_TYPE.equals(vsphereObjectType)) {
            return vsphereObjectAssetSpec.getServerGuid();
        }
        throw new ManagementException("vSphere object with type: " + vsphereObjectAssetSpec.getType() + " passed. The MO types handled by licensing UI are: " + HOST_MO_TYPE + ", " + VC_MO_TYPE + ", " + CLUSTER_MO_TYPE + ", " + SUPERVISOR_VAPI_TYPE);
    }

    private static List<String> getVsphereObjectRefsVcIds(VsphereObjectAssetSpec[] vsphereObjectAssetSpecs) {
        ArrayList<String> result = new ArrayList<String>();
        if (vsphereObjectAssetSpecs == null) {
            return result;
        }
        for (VsphereObjectAssetSpec vsphereObjectAssetSpec : vsphereObjectAssetSpecs) {
            String vcId = VpxManagementEditorImpl.getVsphereObjectRefVcId(vsphereObjectAssetSpec);
            if (vcId == null) continue;
            result.add(vcId);
        }
        return result;
    }

    private static String getVsphereObjectRefVcId(VsphereObjectAssetSpec vsphereObjectAssetSpec) {
        if (vsphereObjectAssetSpec == null) {
            throw new IllegalArgumentException("Null vsphereObjectRef passed");
        }
        return vsphereObjectAssetSpec.getServerGuid();
    }

    private static Map<Asset, Object> getMoRefsByAssets(Asset[] serviceAssets, Map<String, String> vpxAssetScopeIdToVcId) {
        HashMap<Asset, Object> result = new HashMap<Asset, Object>();
        for (Asset serviceAsset : serviceAssets) {
            String assetScopeId = serviceAsset.getInfo().getScopeId();
            String vcId = vpxAssetScopeIdToVcId == null ? null : vpxAssetScopeIdToVcId.get(assetScopeId);
            Object moRef = vcId == null ? null : VpxManagementEditorImpl.buildMoRefForVpxAsset(serviceAsset, vcId);
            result.put(serviceAsset, moRef);
        }
        return result;
    }

    private static Object buildMoRefForVpxAsset(Asset serviceAsset, String vcId) {
        if (!VpxManagementEditorImpl.isVpxAsset(serviceAsset)) {
            return null;
        }
        AssetType assetType = AssetUtil.getServiceAssetType(serviceAsset);
        String instanceId = serviceAsset.getInfo().getInstanceId();
        Object result = null;
        if (AssetType.HOST.equals((Object)assetType)) {
            result = new ManagedObjectReference(HOST_MO_TYPE, instanceId, vcId);
        } else if (AssetType.CLUSTER.equals((Object)assetType)) {
            result = new ManagedObjectReference(CLUSTER_MO_TYPE, instanceId, vcId);
        } else if (AssetType.WCP_CLUSTER.equals((Object)assetType)) {
            if (instanceId.startsWith(WCP_SUPERVISOR_INSTANCE_ID_PREFIX)) {
                String supervisorId = instanceId != null ? instanceId.replaceFirst(WCP_SUPERVISOR_INSTANCE_ID_PREFIX, "") : null;
                result = VapiUriSchemeUtil.createUri((String)SUPERVISOR_VAPI_TYPE, (String)supervisorId, (String)vcId);
            } else {
                String clusterId = instanceId != null ? instanceId.replaceFirst(WCP_CLUSTER_INSTANCE_ID_PREFIX, "") : null;
                result = new ManagedObjectReference(CLUSTER_MO_TYPE, clusterId, vcId);
            }
        } else if (AssetType.VC.equals((Object)assetType)) {
            result = new ManagedObjectReference(VC_MO_TYPE, VC_MO_VALUE, vcId);
        }
        return result;
    }

    private static List<String> getVpxAssetsScopeIds(Asset[] assets) {
        ArrayList<String> result = new ArrayList<String>();
        if (ArrayUtils.isEmpty((Object[])assets)) {
            return result;
        }
        for (Asset asset : assets) {
            String assetScopeId = asset.getInfo().getScopeId();
            if (assetScopeId == null || !VpxManagementEditorImpl.isVpxAsset(asset)) continue;
            result.add(assetScopeId);
        }
        return result;
    }

    private static boolean isVpxAsset(Asset serviceAsset) {
        AssetType assetType = AssetUtil.getServiceAssetType(serviceAsset);
        return AssetType.VC.equals((Object)assetType) || AssetType.HOST.equals((Object)assetType) || AssetType.CLUSTER.equals((Object)assetType) || AssetType.WCP_CLUSTER.equals((Object)assetType);
    }

    @Override
    public com.vmware.license.client.cis.management.ds.Asset[] getAssetsByVsphereObjectRefs(VsphereObjectAssetSpec[] vsphereObjectsAssetSpecs, LicenseScope scope) {
        Validate.notNull((Object)vsphereObjectsAssetSpecs);
        Validate.notNull((Object)scope);
        AssetSearchSpecByIdentifiersImpl searchSpec = null;
        if (!ArrayUtils.isEmpty((Object[])vsphereObjectsAssetSpecs)) {
            AssetIdentifier[] assetIdentifiers = this.getAssetIdentifiers(vsphereObjectsAssetSpecs);
            searchSpec = new AssetSearchSpecByIdentifiersImpl();
            searchSpec.setAssetIdentifiers(assetIdentifiers);
        }
        Asset[] assets = this.searchAssets((AssetSearchSpec)searchSpec, scope);
        return this.createAssets(assets, scope);
    }

    @Override
    protected com.vmware.license.client.cis.management.ds.Asset[] createAssets(Asset[] serviceAssets, LicenseScope scope) {
        if (ArrayUtils.isEmpty((Object[])serviceAssets)) {
            return new com.vmware.license.client.cis.management.ds.Asset[0];
        }
        Map<Asset, Object> serviceAssetToMoRef = this.getAssetToMoRef(serviceAssets);
        com.vmware.license.client.cis.management.ds.Asset[] assets = new com.vmware.license.client.cis.management.ds.Asset[serviceAssets.length];
        for (int i = 0; i < assets.length; ++i) {
            com.vmware.license.client.cis.management.ds.Asset asset = AssetUtil.createAsset(serviceAssets[i], scope);
            Object moRef = serviceAssetToMoRef.get(serviceAssets[i]);
            asset.setRelatedManagedObjectRef(moRef);
            assets[i] = asset;
        }
        return assets;
    }

    private AssetIdentifier[] getAssetIdentifiers(VsphereObjectAssetSpec[] vsphereObjectsAssetSpecs) {
        Map<String, String> vcIdToAssetScopeId = this.getVcIdToAssetScopeId(vsphereObjectsAssetSpecs);
        AssetIdentifierImpl[] result = new AssetIdentifierImpl[vsphereObjectsAssetSpecs.length];
        for (int i = 0; i < vsphereObjectsAssetSpecs.length; ++i) {
            String instanceId = VpxManagementEditorImpl.getVsphereObjectRefInstanceId(vsphereObjectsAssetSpecs[i]);
            String vcId = VpxManagementEditorImpl.getVsphereObjectRefVcId(vsphereObjectsAssetSpecs[i]);
            String assetScopeIdToVcId = vcIdToAssetScopeId.get(vcId);
            result[i] = new AssetIdentifierImpl(instanceId, assetScopeIdToVcId);
        }
        return result;
    }

    private Map<String, String> getVcIdToAssetScopeId(VsphereObjectAssetSpec[] vsphereObjectAssetSpecs) {
        Map<String, String> vcIdToAssetScopeId = new HashMap<String, String>();
        List<String> vcIds = VpxManagementEditorImpl.getVsphereObjectRefsVcIds(vsphereObjectAssetSpecs);
        if (vcIds.isEmpty()) {
            return vcIdToAssetScopeId;
        }
        try {
            SsoSpecificTopologyInfoProvider ssoSpecificTopologyInfoProvider = this._topologyInfoProviderFactory.getTopologyInfoProviderForVc(vcIds.get(0));
            if (ssoSpecificTopologyInfoProvider != null) {
                vcIdToAssetScopeId = ssoSpecificTopologyInfoProvider.getVcIdToNodeId(vcIds);
            }
        }
        catch (TopologyInfoRetrievalException e) {
            throw new ManagementException(e);
        }
        return vcIdToAssetScopeId;
    }

    private Map<Asset, Object> getAssetToMoRef(Asset[] serviceAssets) {
        Map<Asset, Object> result = new HashMap<Asset, Object>();
        if (ArrayUtils.isEmpty((Object[])serviceAssets)) {
            return result;
        }
        List<String> assetsScopeIds = VpxManagementEditorImpl.getVpxAssetsScopeIds(serviceAssets);
        if (assetsScopeIds.isEmpty()) {
            return result;
        }
        Map<String, String> assetScopeIdToVcId = null;
        try {
            SsoSpecificTopologyInfoProvider ssoSpecificTopologyInfoProvider = this._topologyInfoProviderFactory.getTopologyInfoProviderForNode(assetsScopeIds.get(0));
            if (ssoSpecificTopologyInfoProvider != null) {
                assetScopeIdToVcId = ssoSpecificTopologyInfoProvider.getNodeIdToVcId(assetsScopeIds);
            }
        }
        catch (TopologyInfoRetrievalException e) {
            this._logger.warn((Object)("Topology information cannot be retrieved" + e));
        }
        result = VpxManagementEditorImpl.getMoRefsByAssets(serviceAssets, assetScopeIdToVcId);
        return result;
    }
}

