/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.AssetSearchProperties;
import com.vmware.license.client.cis.management.AssetType;
import com.vmware.license.client.cis.management.ds.AssetLicenseState;
import com.vmware.license.client.cis.management.ds.LicenseAssignRestriction;
import com.vmware.license.client.cis.management.ds.ProductCapability;
import com.vmware.license.client.cis.management.ds.ProductRestriction;
import com.vmware.license.client.cis.management.impl.CostUnitFactory;
import com.vmware.license.client.cis.management.util.FeatureUtil;
import com.vmware.license.client.cis.management.util.LicenseUtil;
import com.vmware.license.client.cis.management.util.ProductUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.vim.binding.cis.license.Asset;
import com.vmware.vim.binding.cis.license.AssetInfo;
import com.vmware.vim.binding.cis.license.License;
import com.vmware.vim.binding.cis.license.ProductFamily;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;

public class AssetUtil {
    public static com.vmware.license.client.cis.management.ds.Asset createAsset(Asset asset, LicenseScope scope) {
        if (asset == null) {
            return null;
        }
        com.vmware.license.client.cis.management.ds.Asset result = new com.vmware.license.client.cis.management.ds.Asset();
        URI assetUri = UriUtil.buildAssetUri(asset.getId(), scope);
        result.setUri(assetUri);
        AssetUtil.populateAssetInfo(result, asset.getInfo(), scope);
        return result;
    }

    public static boolean isAssetOfType(com.vmware.license.client.cis.management.ds.Asset asset, AssetType assetType) {
        if (asset == null || assetType == null) {
            return false;
        }
        return assetType.equals((Object)asset.getType());
    }

    public static AssetLicenseState getAssetLicenseState(com.vmware.license.client.cis.management.ds.License assetLicense) {
        if (assetLicense == null) {
            return AssetLicenseState.UNLICENSED;
        }
        if (assetLicense.getIsEvaluation()) {
            return AssetLicenseState.EVALUATION;
        }
        return AssetLicenseState.LICENSED;
    }

    public static boolean isLicenseApplicableForAssets(com.vmware.license.client.cis.management.ds.License license, com.vmware.license.client.cis.management.ds.Asset[] assets, boolean checkLicenseCapability) {
        if (ArrayUtils.isEmpty((Object[])license.getProductRestrictions())) {
            return false;
        }
        for (com.vmware.license.client.cis.management.ds.Asset asset : assets) {
            if (AssetUtil.isLicenseApplicableForAsset(license, asset, checkLicenseCapability)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLicenseApplicableForAsset(com.vmware.license.client.cis.management.ds.License license, com.vmware.license.client.cis.management.ds.Asset asset, boolean checkLicenseCapability) {
        if (license.isSubscription()) {
            return true;
        }
        ProductRestriction assetLicenseProductRestriction = AssetUtil.getAssetProductRestrictionFromLicense(asset, license);
        if (assetLicenseProductRestriction == null) {
            return false;
        }
        if (asset.getVersion() == null) {
            return true;
        }
        if (!checkLicenseCapability) {
            return true;
        }
        ProductCapability assetLicenseProductCapability = AssetUtil.getAssetProductCapabilityFromLicense(asset, license);
        return assetLicenseProductCapability != null;
    }

    public static Set<LicenseAssignRestriction> getLicenseAssignRestrictionsForAsset(com.vmware.license.client.cis.management.ds.License license, com.vmware.license.client.cis.management.ds.Asset asset) {
        if (asset == null) {
            return new HashSet<LicenseAssignRestriction>();
        }
        com.vmware.license.client.cis.management.ds.Asset[] assets = new com.vmware.license.client.cis.management.ds.Asset[]{asset};
        return AssetUtil.getLicenseAssignRestrictionsForAssets(license, assets);
    }

    public static Set<LicenseAssignRestriction> getLicenseAssignRestrictionsForAssets(com.vmware.license.client.cis.management.ds.License license, com.vmware.license.client.cis.management.ds.Asset[] assets) {
        HashSet<LicenseAssignRestriction> result = new HashSet<LicenseAssignRestriction>();
        if (license == null || ArrayUtils.isEmpty((Object[])assets)) {
            return result;
        }
        if (LicenseUtil.isExpiredLicense(license)) {
            result.add(LicenseAssignRestriction.ExpiredLicense);
        }
        if (LicenseUtil.isEmbeddedOemLicense(license)) {
            for (com.vmware.license.client.cis.management.ds.Asset asset : assets) {
                ProductCapability capability;
                if (LicenseUtil.isEmbeddedOemLicense(asset.getLicense()) || !LicenseUtil.isAssignmentFromNonEoemRestricted(capability = AssetUtil.getAssetProductCapabilityFromLicense(asset, license))) continue;
                result.add(LicenseAssignRestriction.EmbeddedOemLicense);
                break;
            }
        }
        return result;
    }

    public static ProductRestriction getAssetProductRestriction(com.vmware.license.client.cis.management.ds.Asset asset) {
        if (asset == null) {
            return null;
        }
        return AssetUtil.getAssetProductRestrictionFromLicense(asset, asset.getLicense());
    }

    public static ProductRestriction getAssetProductRestrictionFromLicense(com.vmware.license.client.cis.management.ds.Asset asset, com.vmware.license.client.cis.management.ds.License license) {
        Object[] assetLicenseProductRestrictions = AssetUtil.getAssetProductRestrictionsFromLicense(asset, license);
        return ArrayUtils.isEmpty((Object[])assetLicenseProductRestrictions) ? null : assetLicenseProductRestrictions[0];
    }

    public static ProductCapability getAssetProductCapability(com.vmware.license.client.cis.management.ds.Asset asset) {
        if (asset == null) {
            return null;
        }
        return AssetUtil.getAssetProductCapabilityFromLicense(asset, asset.getLicense());
    }

    public static ProductCapability getAssetProductCapabilityFromLicense(com.vmware.license.client.cis.management.ds.Asset asset, com.vmware.license.client.cis.management.ds.License license) {
        Object[] assetLicenseProductRestrictions = AssetUtil.getAssetProductRestrictionsFromLicense(asset, license);
        if (ArrayUtils.isEmpty((Object[])assetLicenseProductRestrictions)) {
            return null;
        }
        String version = asset.getVersion();
        if (version == null) {
            return ((ProductRestriction)assetLicenseProductRestrictions[0]).getLatestProductCapability();
        }
        ProductCapability resultProductCapability = null;
        for (Object productRestriction : assetLicenseProductRestrictions) {
            ProductCapability productCapability = license.isSubscription() ? ((ProductRestriction)productRestriction).getLatestProductCapability() : ((ProductRestriction)productRestriction).getVersionToProductCapability().get(version);
            if (productCapability == null) continue;
            resultProductCapability = productCapability;
            break;
        }
        return resultProductCapability;
    }

    public static AssetType getServiceAssetType(Asset serviceAsset) {
        if (serviceAsset == null) {
            return null;
        }
        return ProductUtil.getAssetsTypeByProductFamilyName(serviceAsset.getInfo().getProduct().getFamily().getName());
    }

    public static AssetSearchProperties createAssetSearchProperties(AssetType type2) {
        return AssetUtil.createAssetSearchProperties(type2, null, null, null);
    }

    public static AssetSearchProperties createAssetSearchProperties(AssetType type2, String scopeId, Integer maxResultObjects, Integer offset) {
        AssetSearchProperties result = new AssetSearchProperties();
        result.setType(type2);
        result.setScopeId(scopeId);
        result.setMaxResultObjects(maxResultObjects);
        result.setOffset(offset);
        if (AssetType.ALL.equals((Object)type2)) {
            result.setExcludeSubscribed(true);
        }
        return result;
    }

    private static void populateAssetInfo(com.vmware.license.client.cis.management.ds.Asset asset, AssetInfo assetInfo, LicenseScope scope) {
        String instanceId = assetInfo.getInstanceId();
        asset.setInstanceId(instanceId);
        asset.setName(assetInfo.getName());
        asset.setVersion(assetInfo.getVersion());
        asset.setCostUnitUsage(CostUnitFactory.INSTANCE.createCostUnits(assetInfo.getCostUnitUsage(), null));
        asset.setFeaturesInUse(FeatureUtil.createFeatures(assetInfo.getFeaturesInUse()));
        ProductFamily serviceAssetProductFamily = assetInfo.getProduct().getFamily();
        asset.setProductFamily(ProductUtil.createProductFamily(serviceAssetProductFamily));
        AssetType assetType = ProductUtil.getAssetsTypeByProductFamilyName(serviceAssetProductFamily.getName());
        asset.setType(assetType);
        License assetServiceLicense = assetInfo.getLicense();
        com.vmware.license.client.cis.management.ds.License assetLicense = LicenseUtil.createLicense(assetServiceLicense, assetInfo.isInEvaluation(), scope);
        asset.setLicense(assetLicense);
        asset.setEvaluationLicense(AssetUtil.getEvaluationInfo(assetInfo.getEvalInfo(), scope));
        AssetLicenseState assetLicenseState = AssetUtil.getAssetLicenseState(assetLicense);
        asset.setLicenseState(assetLicenseState);
    }

    private static com.vmware.license.client.cis.management.ds.License getEvaluationInfo(License serviceEvaluationInfo, LicenseScope scope) {
        if (serviceEvaluationInfo == null) {
            return null;
        }
        return LicenseUtil.createEvaluationInfo(serviceEvaluationInfo, scope);
    }

    private static ProductRestriction[] getAssetProductRestrictionsFromLicense(com.vmware.license.client.cis.management.ds.Asset asset, com.vmware.license.client.cis.management.ds.License license) {
        ProductRestriction[] productRestrictions;
        if (asset == null || license == null) {
            return null;
        }
        ArrayList<ProductRestriction> resultProductRestrictions = new ArrayList<ProductRestriction>();
        for (ProductRestriction productRestriction : productRestrictions = license.getProductRestrictions()) {
            boolean skipVersionCheck = license.isSubscription();
            if (!ProductUtil.areProductFamiliesEqual(productRestriction.getProduct().getFamily(), asset.getProductFamily(), skipVersionCheck)) continue;
            resultProductRestrictions.add(productRestriction);
        }
        return resultProductRestrictions.toArray(new ProductRestriction[resultProductRestrictions.size()]);
    }
}

