/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.ds.LimitEnforcementType;
import com.vmware.license.client.cis.management.AssetType;
import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.management.ds.AssetLicenseState;
import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.Product;
import com.vmware.license.client.cis.management.ds.ProductFamily;
import com.vmware.license.client.cis.management.ds.ProductRestriction;
import com.vmware.license.client.cis.management.impl.CostUnitFactory;
import com.vmware.license.client.cis.management.util.AssetUtil;
import com.vmware.license.client.cis.management.util.CostUnitUtil;
import com.vmware.license.client.cis.management.util.LicenseUtil;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.management.util.ProductUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.vim.binding.vim.AboutInfo;
import com.vmware.vim.binding.vim.LicenseManager;
import com.vmware.vim.binding.vim.host.ConnectInfo;
import com.vmware.vim.binding.vim.host.Summary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class HostConnectionUtil {
    private static final String HOST_LICENSE_DEFAULT_NAME = "License 1";

    public static Asset previewHostAsset(ConnectInfo connectInfo, License[] inventoryLicenses, boolean isSubscription) {
        CostUnit[] costUnitUsages;
        if (connectInfo == null) {
            return null;
        }
        Asset hostAsset = new Asset();
        hostAsset.setUri(UriUtil.buildExternalAssetUri());
        hostAsset.setType(AssetType.HOST);
        String name = HostConnectionUtil.getHostAssetName(connectInfo);
        hostAsset.setName(name);
        License evaluationInfo = HostConnectionUtil.previewHostEvaluationInfo(connectInfo);
        hostAsset.setEvaluationLicense(evaluationInfo);
        ProductFamily productFamily = HostConnectionUtil.getProductFamily(connectInfo);
        hostAsset.setProductFamily(productFamily);
        String version = HostConnectionUtil.getHostVersion(connectInfo);
        hostAsset.setVersion(version);
        if (isSubscription) {
            costUnitUsages = HostConnectionUtil.calculateHostCostUnitUsagesForSubscription(connectInfo, inventoryLicenses[0], hostAsset);
        } else {
            Set<String> uniqueCostUnitIds = HostConnectionUtil.getUniqueCostUnitIdsFromLicenses(inventoryLicenses, hostAsset);
            costUnitUsages = HostConnectionUtil.calculateHostCostUnitUsages(connectInfo, uniqueCostUnitIds);
        }
        License license = HostConnectionUtil.previewHostLicense(connectInfo, inventoryLicenses, costUnitUsages, hostAsset);
        hostAsset.setLicense(license);
        AssetLicenseState licenseState = AssetUtil.getAssetLicenseState(license);
        hostAsset.setLicenseState(licenseState);
        if (AssetLicenseState.UNLICENSED.equals((Object)licenseState) || costUnitUsages == null) {
            costUnitUsages = new CostUnit[]{};
        }
        hostAsset.setCostUnitUsage(costUnitUsages);
        return hostAsset;
    }

    private static CostUnit[] calculateHostCostUnitUsagesForSubscription(ConnectInfo connectInfo, License subscriptionLicense, Asset hostAsset) {
        if (subscriptionLicense == null) {
            return new CostUnit[0];
        }
        ProductRestriction licenseProductRestriction = AssetUtil.getAssetProductRestrictionFromLicense(hostAsset, subscriptionLicense);
        CostUnit[] licenseCostUnits = new CostUnit[]{};
        if (licenseProductRestriction != null) {
            licenseCostUnits = licenseProductRestriction.getProduct().getCostUnits();
        }
        if (licenseCostUnits == null) {
            return new CostUnit[0];
        }
        ArrayList<CostUnit> costUnits = new ArrayList<CostUnit>();
        for (CostUnit licenseCostUnit : licenseCostUnits) {
            String costUnitId = licenseCostUnit.getId();
            Number usage = null;
            if ("cpuCore".equals(costUnitId)) {
                usage = HostConnectionUtil.getHostCpuCores(connectInfo);
            } else if ("cpuPackage".equals(costUnitId)) {
                usage = HostConnectionUtil.getHostCpuPackages(connectInfo);
            } else if ("vm".equals(costUnitId)) {
                usage = HostConnectionUtil.getHostVms(connectInfo);
            } else {
                CostUnitUtil.ConfigurableCostUnitKey configurableCostUnit = CostUnitUtil.buildConfigurableCostUnitKey(costUnitId);
                if (configurableCostUnit != null) {
                    CostUnit cpuPackageCoreLimitCostUnit;
                    if ("cpuPackage".equals(configurableCostUnit.costUnitIdentifier)) {
                        cpuPackageCoreLimitCostUnit = HostConnectionUtil.buildNCoresCostUnit(configurableCostUnit.cores, connectInfo);
                        usage = cpuPackageCoreLimitCostUnit.getUsage();
                    } else if ("cpuCore".equals(configurableCostUnit.costUnitIdentifier)) {
                        cpuPackageCoreLimitCostUnit = HostConnectionUtil.buildNMinimumCoresCostUnit(configurableCostUnit.cores, connectInfo);
                        usage = cpuPackageCoreLimitCostUnit.getUsage();
                    }
                }
            }
            costUnits.add(HostConnectionUtil.createCostUnit(costUnitId, usage));
        }
        return costUnits.toArray(new CostUnit[0]);
    }

    private static String getHostAssetName(ConnectInfo connectInfo) {
        return connectInfo.host.config.name;
    }

    private static License previewHostEvaluationInfo(ConnectInfo connectInfo) {
        ConnectInfo.LicenseInfo hostConnectionLicenseInfo = connectInfo.license;
        if (hostConnectionLicenseInfo == null) {
            return null;
        }
        return LicenseUtil.createEvaluationInfo(hostConnectionLicenseInfo.evaluation);
    }

    private static String getHostVersion(ConnectInfo connectInfo) {
        LicenseManager.LicenseInfo lmLicenseInfo = HostConnectionUtil.getLmLicenseInfo(connectInfo);
        if (lmLicenseInfo == null) {
            return null;
        }
        return (String)ManagementUtil.getKeyAnyValuePropertyValue("FileVersion", lmLicenseInfo.properties);
    }

    private static LicenseManager.LicenseInfo getLmLicenseInfo(ConnectInfo connectInfo) {
        ConnectInfo.LicenseInfo hostConnectionLicenseInfo = connectInfo.license;
        if (hostConnectionLicenseInfo == null) {
            return null;
        }
        return hostConnectionLicenseInfo.license;
    }

    private static Set<String> getUniqueCostUnitIdsFromLicenses(License[] inventoryLicenses, Asset hostAsset) {
        HashSet<String> uniqueCostUnitIds = new HashSet<String>();
        uniqueCostUnitIds.add(String.format("%s%d%s", "cpuPackage:", 32, "core"));
        uniqueCostUnitIds.add(String.format("%s%d%s", "cpuCore:", 16, "core"));
        for (License license : inventoryLicenses) {
            ProductRestriction licenseProductRestriction = AssetUtil.getAssetProductRestrictionFromLicense(hostAsset, license);
            CostUnit[] licenseCostUnits = new CostUnit[]{};
            if (licenseProductRestriction != null && licenseProductRestriction.getProduct().getCostUnits() != null) {
                licenseCostUnits = licenseProductRestriction.getProduct().getCostUnits();
            }
            for (CostUnit costUnit : licenseCostUnits) {
                uniqueCostUnitIds.add(costUnit.getId());
            }
        }
        return uniqueCostUnitIds;
    }

    private static CostUnit[] calculateHostCostUnitUsages(ConnectInfo connectInfo, Set<String> uniqueCostUnitIds) {
        LicenseManager.LicenseInfo lmLicenseInfo = HostConnectionUtil.getLmLicenseInfo(connectInfo);
        HashMap<String, CostUnit> costUnits = new HashMap<String, CostUnit>();
        CostUnit cpuPackage = HostConnectionUtil.createCostUnit("cpuPackage", HostConnectionUtil.getHostCpuPackages(connectInfo));
        costUnits.put(cpuPackage.getId(), cpuPackage);
        for (String uniqueCostUnitId : uniqueCostUnitIds) {
            CostUnitUtil.ConfigurableCostUnitKey configurableCostUnit = CostUnitUtil.buildConfigurableCostUnitKey(uniqueCostUnitId);
            if (configurableCostUnit == null) continue;
            if ("cpuPackage".equals(configurableCostUnit.costUnitIdentifier)) {
                CostUnit nCoresCostUnit = HostConnectionUtil.buildNCoresCostUnit(configurableCostUnit.cores, connectInfo);
                costUnits.put(nCoresCostUnit.getId(), nCoresCostUnit);
                continue;
            }
            if (!"cpuCore".equals(configurableCostUnit.costUnitIdentifier)) continue;
            CostUnit nMinimumCoresCostUnit = HostConnectionUtil.buildNMinimumCoresCostUnit(configurableCostUnit.cores, connectInfo);
            costUnits.put(nMinimumCoresCostUnit.getId(), nMinimumCoresCostUnit);
        }
        if (lmLicenseInfo != null && !"00000-00000-00000-00000-00000".equals(lmLicenseInfo.licenseKey)) {
            CostUnit assignedLicenseCostUnit = HostConnectionUtil.createCostUnit(lmLicenseInfo.costUnit, lmLicenseInfo.used);
            costUnits.put(assignedLicenseCostUnit.getId(), assignedLicenseCostUnit);
        }
        return costUnits.values().toArray(new CostUnit[costUnits.size()]);
    }

    private static ProductFamily getProductFamily(ConnectInfo connectInfo) {
        AboutInfo aboutInfo = connectInfo.host.config.product;
        if (aboutInfo == null) {
            return null;
        }
        ProductFamily resultProductFamily = ProductUtil.createProductFamily(aboutInfo.licenseProductName, aboutInfo.licenseProductVersion);
        return resultProductFamily;
    }

    private static License previewHostLicense(ConnectInfo connectInfo, License[] inventoryLicenses, CostUnit[] costUnitUsages, Asset hostAsset) {
        ConnectInfo.LicenseInfo hostConnectionLicenseInfo = connectInfo.license;
        if (hostConnectionLicenseInfo == null) {
            return null;
        }
        LicenseManager.LicenseInfo lmLicenseInfo = hostConnectionLicenseInfo.license;
        if (lmLicenseInfo == null) {
            return null;
        }
        License resultLicense = null;
        License matchingInventoryLicense = LicenseUtil.getLicenseBySerialKey(lmLicenseInfo.licenseKey, inventoryLicenses);
        if (matchingInventoryLicense != null) {
            ProductRestriction licenseProductRestriction = AssetUtil.getAssetProductRestrictionFromLicense(hostAsset, matchingInventoryLicense);
            if (licenseProductRestriction != null) {
                CostUnit[] licenseCostUnits = licenseProductRestriction.getProduct().getCostUnits();
                CostUnitUtil.addCostUnitUsages(costUnitUsages, licenseCostUnits);
            }
            resultLicense = matchingInventoryLicense;
        } else {
            resultLicense = HostConnectionUtil.previewHostConnectionLicense(connectInfo);
        }
        if (LicenseUtil.isExpiredLicense(resultLicense)) {
            resultLicense = null;
        }
        return resultLicense;
    }

    private static License previewHostConnectionLicense(ConnectInfo connectInfo) {
        ConnectInfo.LicenseInfo hostConnectionLicenseInfo = connectInfo.license;
        if (hostConnectionLicenseInfo == null) {
            return null;
        }
        License resultLicense = LicenseUtil.createLicense(hostConnectionLicenseInfo.license);
        if (resultLicense == null) {
            return null;
        }
        if (resultLicense.getIsEvaluation()) {
            Number hostCpuPackageUsage = HostConnectionUtil.getHostCpuPackages(connectInfo);
            CostUnit[] hostCostUnits = new CostUnit[]{CostUnitFactory.INSTANCE.createCostUnit("cpuPackage", hostCpuPackageUsage, CostUnitUtil.NO_LIMIT_VALUE, LimitEnforcementType.HARD_ENFORCED)};
            Product hostProduct = resultLicense.getProductRestrictions()[0].getProduct();
            hostProduct.setCostUnits(hostCostUnits);
        } else {
            resultLicense.setName(HOST_LICENSE_DEFAULT_NAME);
        }
        return resultLicense;
    }

    private static Number getHostCpuPackages(ConnectInfo connectInfo) {
        Summary.HardwareSummary hardwareSummary = connectInfo.host.hardware;
        return hardwareSummary != null ? Short.valueOf(hardwareSummary.numCpuPkgs) : null;
    }

    private static Number getHostVms(ConnectInfo connectInfo) {
        return connectInfo.vm != null ? Integer.valueOf(connectInfo.vm.length) : null;
    }

    private static Number getHostCpuCores(ConnectInfo connectInfo) {
        Summary.HardwareSummary hardwareSummary = connectInfo.host.hardware;
        return hardwareSummary != null ? Short.valueOf(hardwareSummary.numCpuCores) : null;
    }

    private static CostUnit buildNCoresCostUnit(int multipleCoresNumber, ConnectInfo connectInfo) {
        int hostCpus = HostConnectionUtil.getHostCpuPackages(connectInfo).intValue();
        int hostCores = HostConnectionUtil.getHostCpuCores(connectInfo).intValue();
        double avgCoresPerCpu = Math.ceil((double)hostCores / (double)hostCpus);
        long usage = (long)((double)hostCpus * Math.ceil(avgCoresPerCpu / (double)multipleCoresNumber));
        String costUnitId = "cpuPackage:" + multipleCoresNumber + "core";
        return HostConnectionUtil.createCostUnit(costUnitId, usage);
    }

    private static CostUnit buildNMinimumCoresCostUnit(int minimumCoresNumber, ConnectInfo connectInfo) {
        int hostCpus = HostConnectionUtil.getHostCpuPackages(connectInfo).intValue();
        int hostCores = HostConnectionUtil.getHostCpuCores(connectInfo).intValue();
        double avgCoresPerCpu = Math.floor((double)hostCores / (double)hostCpus);
        if (avgCoresPerCpu < (double)minimumCoresNumber) {
            hostCores = hostCpus * minimumCoresNumber;
        }
        String costUnitId = "cpuCore:" + minimumCoresNumber + "core";
        return HostConnectionUtil.createCostUnit(costUnitId, hostCores);
    }

    private static CostUnit createCostUnit(String costUnitId, Number usage) {
        return CostUnitFactory.INSTANCE.createCostUnit(costUnitId, usage, null, null);
    }
}

