/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.AssetType;
import com.vmware.license.client.cis.management.ManagementException;
import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.management.ds.Feature;
import com.vmware.license.client.cis.management.ds.Product;
import com.vmware.license.client.cis.management.ds.ProductCapability;
import com.vmware.license.client.cis.management.ds.ProductFamily;
import com.vmware.license.client.cis.management.ds.ProductRestriction;
import com.vmware.license.client.cis.management.ds.SuiteLicenseType;
import com.vmware.license.client.cis.management.ds.specs.AddLicensePreviewSpec;
import com.vmware.license.client.cis.management.ds.specs.LicensePreviewSpec;
import com.vmware.license.client.cis.management.impl.CostUnitFactory;
import com.vmware.license.client.cis.management.util.FeatureUtil;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.management.util.ProductUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareLicenseInfo;
import com.vmware.license.client.cis.myvmwaresync.util.MyVMwareSyncUtil;
import com.vmware.license.client.cis.util.DateUtil;
import com.vmware.license.client.cis.util.ErrorMessageBuilder;
import com.vmware.license.client.cis.util.Formatter;
import com.vmware.vim.binding.cis.license.CostUnitLimit;
import com.vmware.vim.binding.cis.license.CostUnitUsage;
import com.vmware.vim.binding.cis.license.License;
import com.vmware.vim.binding.cis.license.LicenseInfo;
import com.vmware.vim.binding.cis.license.LicenseProductCapability;
import com.vmware.vim.binding.cis.license.LicenseProductRestriction;
import com.vmware.vim.binding.cis.license.LicenseUtilization;
import com.vmware.vim.binding.cis.license.ProductUsage;
import com.vmware.vim.binding.cis.license.SerialKeyLicenseInfo;
import com.vmware.vim.binding.vim.KeyValue;
import com.vmware.vim.binding.vim.LicenseManager;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.data.uri.resolve.DefaultUriSchemeUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class LicenseUtil {
    public static final URI EVALUATION_LICENSE_URI = DefaultUriSchemeUtil.createUri((String)"License", (String)"EVALUATION_LICENSE_ID");
    public static final URI NEW_LICENSE_URI = DefaultUriSchemeUtil.createUri((String)"License", (String)"NEW_LICENSE_ID");
    public static final String SUPPORTED_DLF_VERSION_KEY = "FileVersion";
    public static final String EVALUATION_SERIAL_KEY = "00000-00000-00000-00000-00000";
    private static final String EMBEDDED_OEM_KEY = "eoem";
    private static final String EXPIRATION_HOURS_KEY = "expirationHours";
    private static final String EXPIRATION_DATE_KEY = "expirationDate";
    private static final String SYSTEM_TIME_KEY = "system_time";
    private static final String EXPIRATION_MINUTES_KEY = "expirationMinutes";
    private static final String SUITE_LICENSE_KEY = "suiteLicense";
    private static final String SUITE_LICENSE_VALUE_PRIMARY_EXTENDED = "primaryExtended";
    private static final String SUITE_LICENSE_VALUE_PRIMARY = "primary";
    private static final String SUITE_LICENSE_VALUE_SECONDARY = "secondary";
    private static final Long ONE_MINUTE_IN_MS = 60000L;
    private static final String LICENSE_INFO_KEY = "LicenseInfo";
    private static final String PRODUCT_FAMILY_NAME_KEY = "ProductName";
    private static final String PRODUCT_FAMILY_VERSION_KEY = "ProductVersion";
    private static final String FEATURE_KEY = "feature";
    private static final String DEFAULT_FILE_VERSION = "1.0";
    private static final Set<AssetType> ASSET_TYPES_NOT_VALID_IN_SUBSCRIPTION_ENV = new HashSet<AssetType>();

    public static com.vmware.license.client.cis.management.ds.License[] createLicenses(LicenseUtilization[] licenseUtilizations, LicenseScope scope) {
        if (ArrayUtils.isEmpty((Object[])licenseUtilizations)) {
            return new com.vmware.license.client.cis.management.ds.License[0];
        }
        ArrayList<com.vmware.license.client.cis.management.ds.License> licenses = new ArrayList<com.vmware.license.client.cis.management.ds.License>();
        for (int i = 0; i < licenseUtilizations.length; ++i) {
            com.vmware.license.client.cis.management.ds.License license = LicenseUtil.createLicense(licenseUtilizations[i], scope);
            if (license == null) continue;
            licenses.add(license);
        }
        return licenses.toArray(new com.vmware.license.client.cis.management.ds.License[licenses.size()]);
    }

    public static com.vmware.license.client.cis.management.ds.License createLicense(LicenseUtilization licenseUtilization, LicenseScope scope) {
        if (licenseUtilization == null) {
            return null;
        }
        com.vmware.license.client.cis.management.ds.License license = LicenseUtil.createLicense(licenseUtilization.getLicense(), licenseUtilization.getUsage(), licenseUtilization.isIsLicenseAssigned(), false, scope);
        return license;
    }

    public static com.vmware.license.client.cis.management.ds.License[] createLicenses(LicenseInfo[] licenseInfos, LicenseScope scope) {
        if (ArrayUtils.isEmpty((Object[])licenseInfos) || scope == null) {
            return new com.vmware.license.client.cis.management.ds.License[0];
        }
        com.vmware.license.client.cis.management.ds.License[] licenses = new com.vmware.license.client.cis.management.ds.License[licenseInfos.length];
        for (int i = 0; i < licenseInfos.length; ++i) {
            com.vmware.license.client.cis.management.ds.License license = new com.vmware.license.client.cis.management.ds.License();
            LicenseUtil.populateLicenseProperties(license, licenseInfos[i], null, scope);
            licenses[i] = license;
        }
        return licenses;
    }

    public static com.vmware.license.client.cis.management.ds.License createLicense(LicenseManager.LicenseInfo licenseInfo) {
        if (licenseInfo == null || StringUtils.isEmpty((CharSequence)licenseInfo.licenseKey) || StringUtils.isEmpty((CharSequence)licenseInfo.name)) {
            return null;
        }
        com.vmware.license.client.cis.management.ds.License license = new com.vmware.license.client.cis.management.ds.License();
        String productName = licenseInfo.getName();
        ProductFamily productFamily = LicenseUtil.getProductFamily(licenseInfo);
        CostUnit[] productCostUnits = new CostUnit[]{CostUnitFactory.INSTANCE.createCostUnit(licenseInfo)};
        Product product = null;
        String serialKey = licenseInfo.licenseKey;
        if (EVALUATION_SERIAL_KEY.equals(serialKey)) {
            license.setIsEvaluation(true);
            product = ProductUtil.createProduct(null, productName, null, productFamily, productCostUnits);
        } else {
            license.setUri(UriUtil.buildExternalLicenseUri());
            license.setIsEvaluation(false);
            product = ProductUtil.createProduct(UriUtil.buildExternalProductUri(), productName, null, productFamily, productCostUnits);
        }
        license.setSerialKeys(new String[]{serialKey});
        ProductRestriction productRestriction = LicenseUtil.createProductRestriction(licenseInfo, product);
        license.setProductRestrictions(new ProductRestriction[]{productRestriction});
        license.setAssigned(true);
        license.setProperties(licenseInfo.getProperties());
        LicenseUtil.populateDerivedProperties(license);
        return license;
    }

    public static com.vmware.license.client.cis.management.ds.License[] createLicenses(License[] serviceLicenses, LicenseScope scope) {
        if (ArrayUtils.isEmpty((Object[])serviceLicenses)) {
            return new com.vmware.license.client.cis.management.ds.License[0];
        }
        com.vmware.license.client.cis.management.ds.License[] resultUiLicenses = new com.vmware.license.client.cis.management.ds.License[serviceLicenses.length];
        for (int i = 0; i < serviceLicenses.length; ++i) {
            resultUiLicenses[i] = LicenseUtil.createLicense(serviceLicenses[i], null, false, false, scope);
        }
        return resultUiLicenses;
    }

    public static com.vmware.license.client.cis.management.ds.License createLicense(License serviceLicense, boolean isEvaluationLicense, LicenseScope scope) {
        return LicenseUtil.createLicense(serviceLicense, null, true, isEvaluationLicense, scope);
    }

    public static com.vmware.license.client.cis.management.ds.License createEvaluationInfo(License serviceLicense, LicenseScope scope) {
        return LicenseUtil.createLicense(serviceLicense, null, true, true, scope);
    }

    public static com.vmware.license.client.cis.management.ds.License createEvaluationInfo(LicenseManager.EvaluationInfo serviceEvaluationInfo) {
        if (serviceEvaluationInfo == null) {
            return null;
        }
        com.vmware.license.client.cis.management.ds.License evaluationInfo = new com.vmware.license.client.cis.management.ds.License();
        evaluationInfo.setIsEvaluation(true);
        Long expirationTimeInMs = LicenseUtil.getLicenseExpirationTimeInMs(serviceEvaluationInfo.properties);
        LicenseUtil.populateLicenseExpirationTime(evaluationInfo, expirationTimeInMs);
        return evaluationInfo;
    }

    public static com.vmware.license.client.cis.management.ds.License createEvaluationLicense(Long expirationTimeInMs) {
        com.vmware.license.client.cis.management.ds.License evaluationLicense = new com.vmware.license.client.cis.management.ds.License();
        evaluationLicense.setUri(EVALUATION_LICENSE_URI);
        evaluationLicense.setIsEvaluation(true);
        evaluationLicense.setSerialKeys(new String[]{EVALUATION_SERIAL_KEY});
        LicenseUtil.populateLicenseExpirationTime(evaluationLicense, expirationTimeInMs);
        return evaluationLicense;
    }

    public static URI[] getLicenseUris(License[] licenses, LicenseScope scope) {
        if (ArrayUtils.isEmpty((Object[])licenses)) {
            return new URI[0];
        }
        URI[] result = new URI[licenses.length];
        for (int i = 0; i < licenses.length; ++i) {
            result[i] = UriUtil.buildLicenseUri(licenses[i].getId(), scope);
        }
        return result;
    }

    public static boolean isExpiredLicense(com.vmware.license.client.cis.management.ds.License license) {
        if (license == null) {
            return false;
        }
        Long expirationTimeInMs = license.getExpirationTime();
        if (expirationTimeInMs == null) {
            return false;
        }
        return expirationTimeInMs <= 0L;
    }

    public static boolean hasSerialKey(String serialKey, com.vmware.license.client.cis.management.ds.License license) {
        Object[] serialKeys = license.getSerialKeys();
        if (ArrayUtils.isEmpty((Object[])serialKeys)) {
            return false;
        }
        return ArrayUtils.contains((Object[])serialKeys, (Object)serialKey);
    }

    public static com.vmware.license.client.cis.management.ds.License[] getSerialKeyLicenses(com.vmware.license.client.cis.management.ds.License[] licenses) {
        if (ArrayUtils.isEmpty((Object[])licenses)) {
            return new com.vmware.license.client.cis.management.ds.License[0];
        }
        ArrayList<com.vmware.license.client.cis.management.ds.License> resultSkLicenses = new ArrayList<com.vmware.license.client.cis.management.ds.License>();
        for (com.vmware.license.client.cis.management.ds.License license : licenses) {
            if (ArrayUtils.isEmpty((Object[])license.getSerialKeys())) continue;
            resultSkLicenses.add(license);
        }
        return resultSkLicenses.toArray(new com.vmware.license.client.cis.management.ds.License[resultSkLicenses.size()]);
    }

    public static com.vmware.license.client.cis.management.ds.License getLicenseBySerialKey(String serialKey, com.vmware.license.client.cis.management.ds.License[] licenses) {
        if (ArrayUtils.isEmpty((Object[])licenses)) {
            return null;
        }
        for (com.vmware.license.client.cis.management.ds.License license : licenses) {
            if (!LicenseUtil.hasSerialKey(serialKey, license)) continue;
            return license;
        }
        return null;
    }

    public static String getLicenseFormattedExpirationDate(Date licenseExpirationDate, Long licenseExpirationTimeInMs) {
        if (licenseExpirationTimeInMs == null) {
            return ManagementUtil.getLocalizedString("license.permanent");
        }
        if (licenseExpirationTimeInMs <= 0L) {
            return ManagementUtil.getLocalizedString("license.expired");
        }
        return ManagementUtil.getFormattedDate(licenseExpirationDate);
    }

    public static boolean isEmbeddedOemLicense(com.vmware.license.client.cis.management.ds.License license) {
        if (license == null) {
            return false;
        }
        return StringUtils.isNotEmpty((CharSequence)license.getEmbeddedOem());
    }

    public static boolean areLicensesOnSubscription(com.vmware.license.client.cis.management.ds.License[] licenses) {
        if (ArrayUtils.isEmpty((Object[])licenses)) {
            return false;
        }
        for (com.vmware.license.client.cis.management.ds.License license : licenses) {
            if (license.isSubscription()) continue;
            return false;
        }
        return true;
    }

    public static boolean isAssignmentFromNonEoemRestricted(ProductCapability capability) {
        if (capability == null) {
            return false;
        }
        String eoemValue = (String)ManagementUtil.getKeyAnyValuePropertyValue(EMBEDDED_OEM_KEY, capability.getProperties());
        return eoemValue != null && !eoemValue.endsWith(":3");
    }

    public static String[] getNewLicensesNames(int newLicensesCount, int existingLicensesCount) {
        if (newLicensesCount < 0 || existingLicensesCount < 0) {
            throw new IllegalArgumentException("The new licenses being created or the existing licenses in the inventory are less than 0. New licenses: " + newLicensesCount + ". Existing licenses: " + existingLicensesCount);
        }
        String[] newLicensesNames = new String[newLicensesCount];
        for (int i = 0; i < newLicensesNames.length; ++i) {
            String licenseNumber = Long.toString(existingLicensesCount + i + 1);
            newLicensesNames[i] = ManagementUtil.getLocalizedString("previewLicense.licenseNameFormat", licenseNumber);
        }
        return newLicensesNames;
    }

    public static LicensePreviewSpec[] buildLicensePreviewSpecs(AddLicensePreviewSpec[] addLicensePreviewSpecs, String[] newLicensesNames) {
        if (ArrayUtils.isEmpty((Object[])addLicensePreviewSpecs) || ArrayUtils.isEmpty((Object[])newLicensesNames)) {
            return new LicensePreviewSpec[0];
        }
        if (addLicensePreviewSpecs.length > newLicensesNames.length) {
            return new LicensePreviewSpec[0];
        }
        LicensePreviewSpec[] result = new LicensePreviewSpec[addLicensePreviewSpecs.length];
        for (int i = 0; i < addLicensePreviewSpecs.length; ++i) {
            LicensePreviewSpec licensePreviewSpec = new LicensePreviewSpec();
            licensePreviewSpec.name = newLicensesNames[i];
            licensePreviewSpec.scope = addLicensePreviewSpecs[i].scope;
            licensePreviewSpec.serialKeys = addLicensePreviewSpecs[i].serialKeys;
            result[i] = licensePreviewSpec;
        }
        return result;
    }

    public static HashSet<String> getSerialKeys(com.vmware.license.client.cis.management.ds.License[] skLicenses) {
        HashSet<String> result = new HashSet<String>();
        if (ArrayUtils.isEmpty((Object[])skLicenses)) {
            return result;
        }
        for (com.vmware.license.client.cis.management.ds.License skLicense : skLicenses) {
            String[] serialKeys = skLicense.getSerialKeys();
            result.addAll(Arrays.asList(serialKeys));
        }
        return result;
    }

    public static void validateSkLicenses(com.vmware.license.client.cis.management.ds.License[] skLicenses, com.vmware.license.client.cis.management.ds.License[] allSkLicenses) {
        ErrorMessageBuilder errorMessageBuilder = new ErrorMessageBuilder();
        SerialKeyFormatter formatter = new SerialKeyFormatter();
        Collection<String> existingSerialKeys = LicenseUtil.getExistingSerialKeys(skLicenses, allSkLicenses);
        errorMessageBuilder.buildErrorGroup("previewLicenseError.existingGroupFormat", existingSerialKeys, formatter);
        Collection<String> expiredSerialKeys = LicenseUtil.getExpiredSerialKeys(skLicenses);
        errorMessageBuilder.buildErrorGroup("previewLicenseError.expiredGroupFormat", expiredSerialKeys, formatter);
        String errorMessage = errorMessageBuilder.getErrorMessage("previewLicenseError.format");
        if (errorMessage != null) {
            throw new ManagementException(errorMessage);
        }
    }

    public static void validateSkLicensesOnSubscription(com.vmware.license.client.cis.management.ds.License[] skLicenses) {
        ErrorMessageBuilder errorMessageBuilder = new ErrorMessageBuilder();
        SerialKeyFormatter formatter = new SerialKeyFormatter();
        Collection<String> serialKeysNotNeededInSubscriptionEnvironment = LicenseUtil.getSerialKeysNotNeededInSubscriptionEnvironment(skLicenses);
        if (serialKeysNotNeededInSubscriptionEnvironment != null && !serialKeysNotNeededInSubscriptionEnvironment.isEmpty()) {
            errorMessageBuilder.buildErrorGroup("previewLicenseError.notNeededGroupFormat", serialKeysNotNeededInSubscriptionEnvironment, formatter);
            String errorMessage = errorMessageBuilder.getErrorMessage("previewLicenseError.notNeededInSubscriptionEnvironmentFormat");
            throw new ManagementException(errorMessage);
        }
    }

    private static Collection<String> getExistingSerialKeys(com.vmware.license.client.cis.management.ds.License[] skLicenses, com.vmware.license.client.cis.management.ds.License[] allSkLicenses) {
        HashSet<String> result = new HashSet<String>();
        if (ArrayUtils.isEmpty((Object[])skLicenses) || ArrayUtils.isEmpty((Object[])allSkLicenses)) {
            return result;
        }
        HashSet<String> serialKeys = LicenseUtil.getSerialKeys(skLicenses);
        for (com.vmware.license.client.cis.management.ds.License skLicense : allSkLicenses) {
            String[] licenseSerialKeys;
            for (String licenseSerialKey : licenseSerialKeys = skLicense.getSerialKeys()) {
                if (!serialKeys.contains(licenseSerialKey)) continue;
                result.add(licenseSerialKey);
            }
        }
        return result;
    }

    private static Collection<String> getExpiredSerialKeys(com.vmware.license.client.cis.management.ds.License[] skLicenses) {
        HashSet<String> result = new HashSet<String>();
        if (ArrayUtils.isEmpty((Object[])skLicenses)) {
            return result;
        }
        for (com.vmware.license.client.cis.management.ds.License skLicense : skLicenses) {
            if (!LicenseUtil.isExpiredLicense(skLicense)) continue;
            String[] serialKeys = skLicense.getSerialKeys();
            result.addAll(Arrays.asList(serialKeys));
        }
        return result;
    }

    private static com.vmware.license.client.cis.management.ds.License createLicense(License serviceLicense, ProductUsage[] productUsages, boolean isAssigned, boolean isEvaluationLicense, LicenseScope scope) {
        if (serviceLicense == null || LicenseUtil.isLicenseCorrupted(serviceLicense)) {
            return null;
        }
        com.vmware.license.client.cis.management.ds.License license = new com.vmware.license.client.cis.management.ds.License();
        license.setIsEvaluation(isEvaluationLicense);
        if (!isEvaluationLicense) {
            license.setUri(UriUtil.buildLicenseUri(serviceLicense.getId(), scope));
        }
        license.setAssigned(isAssigned);
        LicenseUtil.populateLicenseProperties(license, serviceLicense.getInfo(), productUsages, scope);
        return license;
    }

    private static boolean isLicenseCorrupted(License serviceLicense) {
        Object[] licenseProductRestrictions = serviceLicense.getInfo().getRestrictions();
        if (ArrayUtils.isEmpty((Object[])licenseProductRestrictions)) {
            return false;
        }
        for (Object licenseProductRestriction : licenseProductRestrictions) {
            if (!ProductUtil.isProductCorrupted(licenseProductRestriction.getProduct())) continue;
            return true;
        }
        return false;
    }

    private static void populateLicenseProperties(com.vmware.license.client.cis.management.ds.License license, LicenseInfo licenseInfo, ProductUsage[] productUsages, LicenseScope scope) {
        license.setName(licenseInfo.getName());
        if (licenseInfo instanceof SerialKeyLicenseInfo) {
            license.setSerialKeys(((SerialKeyLicenseInfo)licenseInfo).getSerialKeys());
        }
        MyVMwareLicenseInfo myVMwareLicenseInfo = MyVMwareSyncUtil.buildUiMyVMwareLicenseInfo(licenseInfo);
        license.setMyVMwareInfo(myVMwareLicenseInfo);
        license.setProperties(licenseInfo.getProperties());
        LicenseUtil.populateLicenseProperties(license, licenseInfo.getRestrictions(), productUsages, scope);
        LicenseUtil.populateDerivedProperties(license);
    }

    private static void populateLicenseProperties(com.vmware.license.client.cis.management.ds.License license, LicenseProductRestriction[] licenseProductRestrictions, ProductUsage[] productUsages, LicenseScope scope) {
        if (ArrayUtils.isEmpty((Object[])licenseProductRestrictions)) {
            return;
        }
        ArrayList<ProductRestriction> productRestrictions = new ArrayList<ProductRestriction>();
        HashMap<String, CostUnitUsage[]> productIdToCostUnitsUsage = LicenseUtil.createProductIdToCostUnitsUsageMap(productUsages);
        for (LicenseProductRestriction licenseProductRestriction : licenseProductRestrictions) {
            String serviceProductId = licenseProductRestriction.getProduct().getId();
            Product product = LicenseUtil.createProduct((CostUnitUsage[])productIdToCostUnitsUsage.get(serviceProductId), licenseProductRestriction, license.getIsEvaluation() ? null : scope);
            ProductRestriction productRestriction = LicenseUtil.createProductRestriction(licenseProductRestriction, product);
            productRestrictions.add(productRestriction);
        }
        license.setProductRestrictions(productRestrictions.toArray(new ProductRestriction[productRestrictions.size()]));
    }

    private static HashMap<String, CostUnitUsage[]> createProductIdToCostUnitsUsageMap(ProductUsage[] productsUsage) {
        HashMap<String, CostUnitUsage[]> productIdToCostUnitsUsage = new HashMap<String, CostUnitUsage[]>();
        if (productsUsage != null) {
            for (ProductUsage productUsage : productsUsage) {
                productIdToCostUnitsUsage.put(productUsage.getProductId(), productUsage.getCostUnitsUsage());
            }
        }
        return productIdToCostUnitsUsage;
    }

    private static Product createProduct(CostUnitUsage[] costUnitsUsage, LicenseProductRestriction licenseProductRestriction, LicenseScope scope) {
        com.vmware.vim.binding.cis.license.Product serviceProduct = licenseProductRestriction.getProduct();
        CostUnitLimit[] costUnitsLimits = licenseProductRestriction.getCostUnitsLimit();
        Product resultProduct = ProductUtil.createProduct(serviceProduct, costUnitsUsage, costUnitsLimits, scope);
        return resultProduct;
    }

    private static ProductRestriction createProductRestriction(LicenseProductRestriction licenseProductRestriction, Product product) {
        ProductRestriction productRestriction = new ProductRestriction();
        productRestriction.setProduct(product);
        LicenseUtil.populateProductRestrictionProperties(productRestriction, licenseProductRestriction.getCapability());
        LicenseUtil.populateDerivedProperties(productRestriction);
        return productRestriction;
    }

    private static void populateProductRestrictionProperties(ProductRestriction productRestriction, LicenseProductCapability[] licenseProductCapabilities) {
        if (ArrayUtils.isEmpty((Object[])licenseProductCapabilities)) {
            return;
        }
        HashMap<String, ProductCapability> versionToProductCapability = new HashMap<String, ProductCapability>();
        for (LicenseProductCapability capability : licenseProductCapabilities) {
            ProductCapability productCapability = LicenseUtil.createProductCapability(capability);
            versionToProductCapability.put(productCapability.getVersion(), productCapability);
        }
        productRestriction.setVersionToProductCapability(versionToProductCapability);
    }

    private static ProductCapability createProductCapability(LicenseProductCapability serviceProductCapability) {
        Feature[] features = FeatureUtil.createFeatures(serviceProductCapability.getFeatures());
        return LicenseUtil.createProductCapability(serviceProductCapability.getVersion(), features, serviceProductCapability.getProperties());
    }

    private static ProductCapability createProductCapability(String version, Feature[] features, KeyAnyValue[] properties) {
        ProductCapability result = new ProductCapability();
        result.setVersion(version);
        result.setFeatures(features);
        result.setProperties(properties);
        return result;
    }

    private static void populateDerivedProperties(ProductRestriction productRestriction) {
        ProductCapability latestProductCapability = LicenseUtil.getLatestProductCapability(productRestriction);
        productRestriction.setLatestProductCapability(latestProductCapability);
        KeyAnyValue[] properties = latestProductCapability.getProperties();
        String suiteLicenseValue = (String)ManagementUtil.getKeyAnyValuePropertyValue(SUITE_LICENSE_KEY, properties);
        SuiteLicenseType suiteLicenseType = LicenseUtil.getSuiteLicenseType(suiteLicenseValue);
        productRestriction.setSuiteLicenseType(suiteLicenseType);
    }

    private static ProductCapability getLatestProductCapability(ProductRestriction productRestriction) {
        String latestVersion = "";
        ProductCapability latestProductCapability = null;
        Map<String, ProductCapability> versionToProductCapability = productRestriction.getVersionToProductCapability();
        for (Map.Entry<String, ProductCapability> entry : versionToProductCapability.entrySet()) {
            if (entry.getKey().compareTo(latestVersion) <= 0) continue;
            latestVersion = entry.getKey();
            latestProductCapability = entry.getValue();
        }
        return latestProductCapability;
    }

    private static SuiteLicenseType getSuiteLicenseType(String suiteLicenseValue) {
        SuiteLicenseType suiteLicenseType = null;
        suiteLicenseType = SUITE_LICENSE_VALUE_PRIMARY_EXTENDED.equals(suiteLicenseValue) ? SuiteLicenseType.PRIMARY_EXENDED : (SUITE_LICENSE_VALUE_PRIMARY.equals(suiteLicenseValue) ? SuiteLicenseType.PRIMARY : (SUITE_LICENSE_VALUE_SECONDARY.equals(suiteLicenseValue) ? SuiteLicenseType.SECONDARY : SuiteLicenseType.NONE));
        return suiteLicenseType;
    }

    private static void populateDerivedProperties(com.vmware.license.client.cis.management.ds.License license) {
        if (license == null) {
            return;
        }
        String embeddedOemPropValue = (String)LicenseUtil.getLicensePropertyValue(license, EMBEDDED_OEM_KEY);
        license.setEmbeddedOem(embeddedOemPropValue);
        boolean subscription = LicenseUtil.isSubscriptionLicense(license);
        license.setSubscription(subscription);
        Long expirationTimeInMs = LicenseUtil.getLicenseExpirationTimeInMs(license);
        LicenseUtil.populateLicenseExpirationTime(license, expirationTimeInMs);
    }

    private static boolean isLicensePropertyPresent(com.vmware.license.client.cis.management.ds.License license, String propertyKey) {
        Object result = LicenseUtil.getLicensePropertyValue(license, propertyKey);
        return result != null;
    }

    private static <T> T getLicensePropertyValue(com.vmware.license.client.cis.management.ds.License license, String propertyKey) {
        T resultPropertyValue = license.getProperties() != null ? ManagementUtil.getKeyAnyValuePropertyValue(propertyKey, license.getProperties()) : LicenseUtil.getLicensePropertyValueFromProductCapabilitiesProperties(license, propertyKey);
        return resultPropertyValue;
    }

    private static <T> T getLicensePropertyValueFromProductCapabilitiesProperties(com.vmware.license.client.cis.management.ds.License license, String propertyKey) {
        Object[] productRestrictions = license.getProductRestrictions();
        if (ArrayUtils.isEmpty((Object[])productRestrictions)) {
            return null;
        }
        T resultPropertyValue = null;
        for (Object productRestriction : productRestrictions) {
            KeyAnyValue[] properties;
            Object propertyValue;
            ProductCapability latestProductCapability = ((ProductRestriction)productRestriction).getLatestProductCapability();
            if (latestProductCapability == null || (propertyValue = ManagementUtil.getKeyAnyValuePropertyValue(propertyKey, properties = latestProductCapability.getProperties())) == null) continue;
            resultPropertyValue = propertyValue;
            break;
        }
        return resultPropertyValue;
    }

    private static boolean isSubscriptionLicense(com.vmware.license.client.cis.management.ds.License license) {
        boolean isSubscriptionLicense = false;
        if (LicenseUtil.isLicensePropertyPresent(license, "cloudSubscription")) {
            Object isSubscriptionLicenseValue = LicenseUtil.getLicensePropertyValue(license, "cloudSubscription");
            isSubscriptionLicense = "1".equals(isSubscriptionLicenseValue);
        }
        return isSubscriptionLicense;
    }

    private static Long getLicenseExpirationTimeInMs(com.vmware.license.client.cis.management.ds.License license) {
        return LicenseUtil.getLicenseExpirationTimeInMs(license.getProperties());
    }

    private static Long getLicenseExpirationTimeInMs(KeyAnyValue[] licenseProperties) {
        if (ArrayUtils.isEmpty((Object[])licenseProperties)) {
            return null;
        }
        Calendar expirationDate = null;
        Calendar systemDate = null;
        Number expirationHours = null;
        Number expirationMinutes = null;
        for (KeyAnyValue property : licenseProperties) {
            if (EXPIRATION_DATE_KEY.equals(property.getKey())) {
                expirationDate = DateUtil.getCalendar(property.getValue());
                continue;
            }
            if (SYSTEM_TIME_KEY.equals(property.getKey())) {
                systemDate = DateUtil.getCalendar(property.getValue());
                continue;
            }
            if (EXPIRATION_HOURS_KEY.equals(property.getKey())) {
                expirationHours = (Number)property.getValue();
                continue;
            }
            if (!EXPIRATION_MINUTES_KEY.equals(property.getKey())) continue;
            expirationMinutes = (Number)property.getValue();
        }
        if (expirationHours == null && expirationMinutes == null) {
            return DateUtil.getRemainingTimeInMillis(systemDate, expirationDate);
        }
        Long expirationTimeInMs = DateUtil.getTimeInMillis(expirationHours, expirationMinutes);
        if (expirationTimeInMs != null && expirationTimeInMs > 0L) {
            expirationTimeInMs = expirationTimeInMs + ONE_MINUTE_IN_MS;
        }
        return expirationTimeInMs;
    }

    private static void populateLicenseExpirationTime(com.vmware.license.client.cis.management.ds.License license, Long expirationTimeInMs) {
        license.setExpirationTime(expirationTimeInMs);
        Date expirationDate = LicenseUtil.getLicenseExpirationDate(expirationTimeInMs);
        license.setExpirationDate(expirationDate);
    }

    private static Date getLicenseExpirationDate(Long licenseExpirationTimeInMs) {
        if (licenseExpirationTimeInMs == null || licenseExpirationTimeInMs <= 0L) {
            return null;
        }
        Date today = new Date();
        Date expirationDate = new Date(today.getTime() + licenseExpirationTimeInMs);
        return expirationDate;
    }

    private static ProductFamily getProductFamily(LicenseManager.LicenseInfo licenseInfo) {
        KeyAnyValue[] properties;
        if (licenseInfo == null) {
            return null;
        }
        ProductFamily resultProductFamily = new ProductFamily();
        for (KeyAnyValue licenseProperty : properties = licenseInfo.getProperties()) {
            if (PRODUCT_FAMILY_NAME_KEY.equals(licenseProperty.getKey())) {
                String productFamilyName = (String)licenseProperty.getValue();
                resultProductFamily.setName(productFamilyName);
                continue;
            }
            if (!PRODUCT_FAMILY_VERSION_KEY.equals(licenseProperty.getKey())) continue;
            String productFamilyVersion = (String)licenseProperty.getValue();
            resultProductFamily.setVersion(productFamilyVersion);
        }
        return resultProductFamily;
    }

    private static ProductRestriction createProductRestriction(LicenseManager.LicenseInfo licenseInfo, Product product) {
        if (licenseInfo == null) {
            return null;
        }
        ProductRestriction productRestriction = new ProductRestriction();
        productRestriction.setProduct(product);
        LicenseUtil.populateProductRestrictionProperties(productRestriction, licenseInfo);
        LicenseUtil.populateDerivedProperties(productRestriction);
        return productRestriction;
    }

    private static void populateProductRestrictionProperties(ProductRestriction productRestriction, LicenseManager.LicenseInfo licenseInfo) {
        HashMap<String, ProductCapability> versionToProductCapability = new HashMap<String, ProductCapability>();
        KeyAnyValue[] properties = licenseInfo.getProperties();
        LicenseUtil.populateProductRestrictionVersionToProductCapability(versionToProductCapability, properties);
        productRestriction.setVersionToProductCapability(versionToProductCapability);
    }

    private static void populateProductRestrictionVersionToProductCapability(Map<String, ProductCapability> productRestrictionVersionToProductCapability, KeyAnyValue[] licenseInfoProperties) {
        String supportedDlfVersion = DEFAULT_FILE_VERSION;
        ArrayList<Feature> availableFeatures = new ArrayList<Feature>();
        ArrayList<KeyAnyValue> availableProperties = new ArrayList<KeyAnyValue>();
        for (KeyAnyValue licenseInfoProperty : licenseInfoProperties) {
            if (FEATURE_KEY.equals(licenseInfoProperty.getKey())) {
                String featureId = ((KeyValue)licenseInfoProperty.getValue()).getKey();
                Feature feature = FeatureUtil.createFeature(featureId);
                availableFeatures.add(feature);
                continue;
            }
            if (LICENSE_INFO_KEY.equals(licenseInfoProperty.getKey())) {
                LicenseManager.LicenseInfo innerLicenseInfo = (LicenseManager.LicenseInfo)licenseInfoProperty.getValue();
                LicenseUtil.populateProductRestrictionVersionToProductCapability(productRestrictionVersionToProductCapability, innerLicenseInfo.properties);
                continue;
            }
            availableProperties.add(licenseInfoProperty);
            if (!SUPPORTED_DLF_VERSION_KEY.equals(licenseInfoProperty.getKey())) continue;
            supportedDlfVersion = (String)licenseInfoProperty.getValue();
        }
        ProductCapability productCapability = LicenseUtil.createProductCapability(supportedDlfVersion, availableFeatures.toArray(new Feature[availableFeatures.size()]), availableProperties.toArray(new KeyAnyValue[availableProperties.size()]));
        productRestrictionVersionToProductCapability.put(supportedDlfVersion, productCapability);
    }

    private static boolean isLicenseInvalidForSubscriptionEnvironment(com.vmware.license.client.cis.management.ds.License license) {
        if (license == null || license.getProductRestrictions() == null || license.getProductRestrictions().length == 0) {
            return false;
        }
        for (ProductRestriction productRestriction : license.getProductRestrictions()) {
            if (productRestriction == null || productRestriction.getProduct() == null || ASSET_TYPES_NOT_VALID_IN_SUBSCRIPTION_ENV.contains((Object)productRestriction.getProduct().getAssetsType())) continue;
            return false;
        }
        return true;
    }

    private static Collection<String> getSerialKeysNotNeededInSubscriptionEnvironment(com.vmware.license.client.cis.management.ds.License[] licenses) {
        HashSet<String> notNeededSkLicenses = new HashSet<String>();
        if (licenses == null || licenses.length == 0) {
            return notNeededSkLicenses;
        }
        for (com.vmware.license.client.cis.management.ds.License license : licenses) {
            if (!LicenseUtil.isLicenseInvalidForSubscriptionEnvironment(license)) continue;
            notNeededSkLicenses.addAll(Arrays.asList(license.getSerialKeys()));
        }
        return notNeededSkLicenses;
    }

    static {
        ASSET_TYPES_NOT_VALID_IN_SUBSCRIPTION_ENV.add(AssetType.HOST);
        ASSET_TYPES_NOT_VALID_IN_SUBSCRIPTION_ENV.add(AssetType.VC);
    }

    public static class SerialKeyFormatter
    implements Formatter<String> {
        @Override
        public String format(String serialKey) {
            return ManagementUtil.getLocalizedString("previewLicenseError.licenseFormat", serialKey);
        }
    }
}

