/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.myvmwaresync.adapter;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.myvmwaresync.MyVMwareSyncEditor;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareSyncPreviewResult;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareSyncCommitSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareSyncPreviewSpec;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.license.client.cis.util.MutationUtil;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MyVMwareSyncMutationProvider
implements MutationProvider {
    private final Log _logger = LogFactory.getLog(MyVMwareSyncMutationProvider.class);
    private final MyVMwareSyncEditor _myVMwareSyncEditor;

    public MyVMwareSyncMutationProvider(MyVMwareSyncEditor myVMwareSyncEditor) {
        this._myVMwareSyncEditor = myVMwareSyncEditor;
    }

    public OperationResult apply(URI dummyUri, MyVMwareSyncCommitSpec spec) {
        try {
            LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiScope(spec.scope);
            this._myVMwareSyncEditor.commitSyncFromMyVMware(spec, scope);
            return MutationUtil.createOperationResult(dummyUri);
        }
        catch (Exception e) {
            this.logError(e);
            return MutationUtil.createOperationResult(e);
        }
    }

    public ValidationResult validate(MyVMwareSyncPreviewSpec spec) {
        try {
            LicenseScope scope = LicenseScopeUtil.getLicenseScopeByUiScope(spec.scope);
            MyVMwareSyncPreviewResult previewResult = this._myVMwareSyncEditor.previewSyncFromMyVMware(spec, scope);
            return MutationUtil.createValidationResult(previewResult);
        }
        catch (Exception e) {
            this.logError(e);
            return MutationUtil.createValidationResult(e);
        }
    }

    private void logError(Throwable t) {
        if (this._logger.isErrorEnabled()) {
            this._logger.error((Object)"Unable to execute license mutation operation: ", t);
        }
    }
}

