/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.myvmwaresync.client.impl;

import com.vmware.license.client.cis.myvmwaresync.client.MyVMwareClientProvider;
import com.vmware.license.client.cis.myvmwaresync.client.MyVMwareClientProviderException;
import com.vmware.license.client.cis.myvmwaresync.client.MyVMwareClientProviderResult;
import com.vmware.license.client.cis.myvmwaresync.client.impl.MyVMwareClientAuthenticationConfig;
import com.vmware.license.client.cis.myvmwaresync.client.impl.MyVMwareClientHttpConfig;
import com.vmware.license.myvmware.client.authn.AuthenticationToken;
import com.vmware.license.myvmware.client.authn.AuthenticationTokenFactory;
import com.vmware.license.myvmware.client.authn.impl.AuthenticationTokenFactoryImpl;
import com.vmware.license.myvmware.client.entitlementreport.MyVMwareEntitlementReportClient;
import com.vmware.license.myvmware.client.entitlementreport.MyVMwareEntitlementReportClientFactory;
import com.vmware.license.myvmware.client.entitlementreport.impl.MyVMwareEntitlementReportClientFactoryImpl;
import java.net.URI;

public class MyVMwareClientProviderImpl
implements MyVMwareClientProvider {
    private String _apiBaseUri;
    private final MyVMwareEntitlementReportClientFactory _myVMwareClientFactory;
    private final AuthenticationTokenFactory _authenticationTokenFactory;

    public MyVMwareClientProviderImpl(String apiBaseUri) {
        this(apiBaseUri, null, null);
    }

    public MyVMwareClientProviderImpl(String apiBaseUri, MyVMwareClientAuthenticationConfig myVMwareClientAuthenticationConfig) {
        this(apiBaseUri, null, myVMwareClientAuthenticationConfig);
    }

    public MyVMwareClientProviderImpl(String apiBaseUri, MyVMwareClientHttpConfig myVMwareClientHttpConfig) {
        this(apiBaseUri, myVMwareClientHttpConfig, null);
    }

    public MyVMwareClientProviderImpl(String apiBaseUri, MyVMwareClientHttpConfig myVMwareClientHttpConfig, MyVMwareClientAuthenticationConfig myVMwareClientAuthenticationConfig) {
        this._apiBaseUri = apiBaseUri;
        this._myVMwareClientFactory = myVMwareClientHttpConfig == null ? new MyVMwareEntitlementReportClientFactoryImpl() : new MyVMwareEntitlementReportClientFactoryImpl(myVMwareClientHttpConfig.toMyVMwareEntitlementReportClientHttpConfig());
        this._authenticationTokenFactory = myVMwareClientAuthenticationConfig == null ? new AuthenticationTokenFactoryImpl() : new AuthenticationTokenFactoryImpl(myVMwareClientAuthenticationConfig.toAuthenticationConfig());
    }

    @Override
    public MyVMwareClientProviderResult newClient(AuthenticationToken authenticationToken) throws MyVMwareClientProviderException {
        MyVMwareEntitlementReportClient client;
        if (authenticationToken == null) {
            throw new IllegalArgumentException("The authentication token parameter cannot be null.");
        }
        try {
            client = this._myVMwareClientFactory.createClient(new URI(this._apiBaseUri), authenticationToken);
        }
        catch (Exception e) {
            throw new MyVMwareClientProviderException(e);
        }
        return new MyVMwareClientProviderResult(client, authenticationToken);
    }

    @Override
    public MyVMwareClientProviderResult newClient(String username, String password) throws MyVMwareClientProviderException {
        AuthenticationToken authenticationToken;
        if (username == null || password == null) {
            throw new IllegalArgumentException("Both the username and password parameters should be non-null.");
        }
        try {
            authenticationToken = this._authenticationTokenFactory.createToken(username, password);
        }
        catch (Exception e) {
            throw new MyVMwareClientProviderException(e);
        }
        MyVMwareClientProviderResult clientProviderResult = this.newClient(authenticationToken);
        return clientProviderResult;
    }
}

