/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.myvmwaresync.impl;

import com.vmware.license.client.cis.ls.LicenseClientProvider;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.myvmwaresync.MyVMwareSyncException;
import com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareSyncInfo;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareSyncCommitSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareSyncPreviewSpec;
import com.vmware.license.client.cis.myvmwaresync.impl.MyVMwareSyncEditorImpl;
import com.vmware.license.client.cis.myvmwaresync.util.MyVMwareSyncUtil;
import com.vmware.license.myvmware.client.sync.MyVMwareUtil;
import com.vmware.vim.binding.cis.license.management.LicenseAddSpec;
import com.vmware.vim.binding.cis.license.management.LicenseUpdateSpec;
import com.vmware.vim.binding.cis.license.management.MyVMwareLicenseReport;
import com.vmware.vim.binding.cis.license.management.MyVMwareSyncPreviewResult;
import com.vmware.vim.binding.cis.license.management.SystemManagementService;
import com.vmware.vim.binding.vmodl.MethodFault;
import java.io.IOException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MyVMwareSyncEditor65Impl
extends MyVMwareSyncEditorImpl {
    private final Log _logger = LogFactory.getLog(MyVMwareSyncEditorImpl.class);

    public MyVMwareSyncEditor65Impl(LicenseClientProvider licenseClientProvider) {
        super(licenseClientProvider);
    }

    @Override
    public com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareSyncPreviewResult previewSyncFromMyVMware(MyVMwareSyncPreviewSpec syncPreviewSpec, LicenseScope scope) {
        MyVMwareLicenseReport myVMwareLicenseReport;
        Validate.notNull((Object)syncPreviewSpec);
        Validate.notNull((Object)scope);
        Validate.notNull((Object)syncPreviewSpec.myVMwareFileContent);
        try {
            myVMwareLicenseReport = MyVMwareUtil.buildMyVMwareLicenseReport((byte[])syncPreviewSpec.myVMwareFileContent);
        }
        catch (IOException e) {
            throw new MyVMwareSyncException(e);
        }
        SystemManagementService sms = this.getSystemManagementService(scope);
        try {
            MyVMwareSyncPreviewResult serviceSyncPreviewResult = sms.previewMyVMwareSync(myVMwareLicenseReport);
            com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareSyncPreviewResult uiSyncPreviewResult = this.buildUiSyncPreviewResult(serviceSyncPreviewResult, scope);
            return uiSyncPreviewResult;
        }
        catch (MethodFault fault) {
            throw new MyVMwareSyncException(fault);
        }
    }

    @Override
    public void commitSyncFromMyVMware(MyVMwareSyncCommitSpec syncCommitSpec, LicenseScope scope) {
        Validate.notNull((Object)syncCommitSpec);
        Validate.notNull((Object)scope);
        SystemManagementService sms = this.getSystemManagementService(scope);
        boolean licensesUpdated = false;
        if (!ArrayUtils.isEmpty((Object[])syncCommitSpec.myVMwareLicenseUpdateSpecs)) {
            LicenseUpdateSpec[] licenseUpdateSpecs = MyVMwareSyncUtil.buildServiceLicenseUpdateSpecs(syncCommitSpec.myVMwareLicenseUpdateSpecs);
            try {
                sms.updateLicenses(licenseUpdateSpecs);
                licensesUpdated = true;
            }
            catch (MethodFault fault) {
                throw new MyVMwareSyncException(fault);
            }
        }
        if (!ArrayUtils.isEmpty((Object[])syncCommitSpec.myVMwareLicenseCreateSpecs)) {
            LicenseAddSpec[] licenseAddSpecs = MyVMwareSyncUtil.buildServiceLicenseAddSpecs(syncCommitSpec.myVMwareLicenseCreateSpecs);
            try {
                sms.addLicenses(licenseAddSpecs);
            }
            catch (MethodFault fault) {
                if (licensesUpdated) {
                    this._logger.warn((Object)"Incomplete sync performed. Some licenses My VMware metadata was updated, but other licenses were not added to the inventory.");
                }
                throw new MyVMwareSyncException(fault);
            }
        }
    }

    @Override
    public MyVMwareSyncInfo getSyncInfo(LicenseScope scope) throws MyVMwareSyncException {
        return null;
    }
}

