/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.subscription.global.impl;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.AssetSearchProperties;
import com.vmware.license.client.cis.management.AssetType;
import com.vmware.license.client.cis.management.ManagementEditor;
import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.subscription.global.SubscriptionGlobalInfoRetriever;
import com.vmware.vise.util.session.SessionUtil;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;

public class SubscriptionGlobalInfoRetrieverImpl
implements SubscriptionGlobalInfoRetriever {
    private final ManagementEditor _managementEditor;
    private final ExecutorService _exerciseService;
    private Future<?> _lastRunningAreAllVcsOnSubscriptionTask = null;
    private AtomicReference<HashSet<String>> _lastAllVcsOnSubscriptionValue = null;

    public SubscriptionGlobalInfoRetrieverImpl(ManagementEditor managementEditor, ExecutorService executorService) {
        this._managementEditor = managementEditor;
        this._exerciseService = executorService;
        this._lastAllVcsOnSubscriptionValue = new AtomicReference(new HashSet());
    }

    @Override
    public boolean areAnyVcsOnSubscription() {
        this.invalidateSubscriptionInfoIfNeeded();
        HashSet<String> vcIdsOnSubscription = this._lastAllVcsOnSubscriptionValue.get();
        return vcIdsOnSubscription.size() > 0;
    }

    @Override
    public boolean isVcOnSubscription(String vcId) {
        this.invalidateSubscriptionInfoIfNeeded();
        HashSet<String> vcIdsOnSubscription = this._lastAllVcsOnSubscriptionValue.get();
        return vcIdsOnSubscription.contains(vcId);
    }

    private void invalidateSubscriptionInfoIfNeeded() {
        if (this._lastRunningAreAllVcsOnSubscriptionTask == null || this._lastRunningAreAllVcsOnSubscriptionTask.isDone()) {
            Runnable areVcsOnSubscriptionTask = this.createGetAllVcsOnSubscriptionTask();
            this._lastRunningAreAllVcsOnSubscriptionTask = this._exerciseService.submit(areVcsOnSubscriptionTask);
        }
    }

    private Runnable createGetAllVcsOnSubscriptionTask() {
        final HttpServletRequest threadContext = SessionUtil.getHttpRequest();
        return new Runnable(){

            @Override
            public void run() {
                SessionUtil.setHttpRequest((HttpServletRequest)threadContext);
                LicenseScope scope = ManagementUtil.SCOPE_CIS_LICENSING;
                AssetSearchProperties searchProperties = new AssetSearchProperties();
                searchProperties.setType(AssetType.VC);
                searchProperties.setExcludeSubscribed(false);
                Asset[] assets = SubscriptionGlobalInfoRetrieverImpl.this._managementEditor.getAssets(scope, searchProperties);
                HashSet<String> subscribedVcIds = new HashSet<String>();
                if (assets != null) {
                    for (Asset asset : assets) {
                        if (asset.getLicense() == null || !asset.getLicense().isSubscription()) continue;
                        subscribedVcIds.add(asset.getInstanceId());
                    }
                    SubscriptionGlobalInfoRetrieverImpl.this._lastAllVcsOnSubscriptionValue.set(subscribedVcIds);
                }
            }
        };
    }
}

