/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.util;

public class MathUtil {
    private static final int PERCENTAGE_PRECISION = 2;

    public static Double calculatePercentage(Number value, Number total) {
        if (total == null || value == null || total.longValue() == 0L) {
            return null;
        }
        if (value.longValue() == 0L) {
            return 0.0;
        }
        double percentage = value.doubleValue() / total.doubleValue() * 100.0;
        return MathUtil.roundNumber(percentage, 2);
    }

    private static Double roundNumber(double value, int precision) {
        int multiplier = (int)Math.pow(10.0, precision);
        double roundedValue = (double)Math.round(value * (double)multiplier) / (double)multiplier;
        return roundedValue;
    }
}

