/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cluster.ha.proactive.impl;

import com.vmware.vim.binding.vim.HealthUpdateInfo;
import com.vmware.vim.binding.vim.HealthUpdateManager;
import com.vmware.vim.binding.vim.fault.NotFound;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.cluster.ha.proactive.FilterHealthUpdateInfo;
import com.vmware.vsphere.client.cluster.ha.proactive.FilterHostInfo;
import com.vmware.vsphere.client.cluster.ha.proactive.FilterModel;
import com.vmware.vsphere.client.cluster.ha.proactive.impl.InfraHelper;
import com.vmware.vsphere.client.cluster.ha.proactive.impl.ProviderManager;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilterManager {
    private static final Log _logger = LogFactory.getLog(ProviderManager.class);
    private static final String PREFIX_FILTERNAME = "ngc.";
    private InfraHelper _infraHelper;
    private String _targetFilterName = "";
    private String _providerId = "";

    private Boolean isReadyToBuild() {
        return this._infraHelper != null && this._infraHelper.isReady() && StringUtils.isNotEmpty((String)this._targetFilterName) && StringUtils.isNotEmpty((String)this._providerId);
    }

    private String getAutoFilterName(String providerId) {
        return PREFIX_FILTERNAME + this._infraHelper.getClusterMoid() + "." + providerId.replaceAll("\\s+", "");
    }

    public FilterManager reset() {
        this._targetFilterName = "";
        this._providerId = "";
        return this;
    }

    public FilterManager setProvider(String providerId) {
        this._providerId = providerId;
        this._targetFilterName = this.getAutoFilterName(providerId);
        return this;
    }

    public FilterManager(InfraHelper controller) {
        this._infraHelper = controller;
    }

    public Boolean checkFilterExists() {
        if (!this.isReadyToBuild().booleanValue()) {
            return false;
        }
        return StringUtils.isNotEmpty((String)this.getTargetFilterId(this._targetFilterName));
    }

    public FilterModel getFilter() throws Exception {
        if (!this.isReadyToBuild().booleanValue()) {
            return null;
        }
        String filterId = this.getTargetFilterId(this._targetFilterName);
        if (StringUtils.isNotEmpty((String)filterId)) {
            return this.buildFilter(filterId);
        }
        return this.buildFilterTemplate();
    }

    public void applyFilter(FilterModel filter) throws NotFound {
        assert (filter != null);
        assert (filter.providerId != null);
        assert (filter.name != null);
        String filterName = filter.name;
        String targetFilterId = filter.id;
        String providerId = filter.providerId;
        if (StringUtils.isEmpty((String)targetFilterId)) {
            targetFilterId = this.getTargetFilterId(filterName);
        }
        Boolean filterExists = !StringUtils.isEmpty((String)targetFilterId);
        HealthUpdateManager hm = this._infraHelper.getHealthManager();
        assert (hm != null);
        ArrayList<String> listHealthInfo = new ArrayList<String>();
        for (FilterHealthUpdateInfo hui : filter.filterHealthUpdateInfo) {
            listHealthInfo.add(hui.id);
        }
        if (listHealthInfo.size() == 0) {
            if (!filterExists.booleanValue()) {
                return;
            }
            hm.removeFilter(targetFilterId);
            return;
        }
        ArrayList<String> listEntities = new ArrayList<String>();
        if (filter.isClusterLevelSet.booleanValue()) {
            listEntities.add(this._infraHelper.getClusterMoid());
        } else {
            for (FilterHostInfo fhi : filter.filterHostInfo) {
                listEntities.add(fhi.hostMoref);
            }
        }
        if (listEntities.size() == 0) {
            return;
        }
        String[] arrayInfoIdsToSet = listHealthInfo.toArray(new String[listHealthInfo.size()]);
        String newId = null;
        if (!filterExists.booleanValue()) {
            newId = hm.addFilter(providerId, this._targetFilterName, arrayInfoIdsToSet);
        } else {
            hm.removeFilter(targetFilterId);
            newId = hm.addFilter(providerId, this._targetFilterName, arrayInfoIdsToSet);
            _logger.debug((Object)String.format("Edited filter Id {%s}, name {%s}", newId, this._targetFilterName));
        }
        Boolean bResult = this.handleFilterManagedEntities(listEntities, newId);
    }

    private FilterModel buildFilterTemplate() throws Exception {
        if (!this.isReadyToBuild().booleanValue()) {
            return null;
        }
        FilterModel phaFilter = new FilterModel();
        phaFilter.name = this._targetFilterName;
        phaFilter.id = null;
        phaFilter.providerId = this._providerId;
        HealthUpdateInfo[] huiList = this._infraHelper.getHealthManager().queryHealthUpdateInfos(this._providerId);
        if (huiList == null) {
            return null;
        }
        FilterHealthUpdateInfo[] filterInfoList = new FilterHealthUpdateInfo[huiList.length];
        int count = 0;
        for (HealthUpdateInfo hui : huiList) {
            FilterHealthUpdateInfo fhui = new FilterHealthUpdateInfo();
            fhui.component = hui.componentType;
            fhui.id = hui.id;
            fhui.description = hui.description;
            fhui.isFilterOn = false;
            filterInfoList[count++] = fhui;
        }
        phaFilter.filterHealthUpdateInfo = filterInfoList;
        phaFilter.isClusterLevelSet = true;
        ManagedObjectReference[] hostMorefs = this._infraHelper.getHostsUnderCluster();
        FilterHostInfo[] filterHostList = null;
        if (hostMorefs == null || hostMorefs.length == 0) {
            phaFilter.filterHostInfo = null;
            return phaFilter;
        }
        _logger.error((Object)("found hosts : count : " + hostMorefs.length));
        filterHostList = new FilterHostInfo[hostMorefs.length];
        count = 0;
        for (ManagedObjectReference morefHost : hostMorefs) {
            FilterHostInfo fhi = new FilterHostInfo();
            fhi.hostMoref = morefHost.getValue();
            fhi.name = this._infraHelper.getHostName(morefHost);
            fhi.isFilterOn = false;
            filterHostList[count++] = fhi;
        }
        phaFilter.filterHostInfo = filterHostList;
        return phaFilter;
    }

    private FilterModel buildFilter(String filterId) throws Exception {
        if (!this.isReadyToBuild().booleanValue()) {
            return null;
        }
        FilterModel filter = this.buildFilterTemplate();
        filter.isClusterLevelSet = false;
        String[] filterInfoIds = null;
        if (StringUtils.isNotEmpty((String)filterId)) {
            filterInfoIds = this._infraHelper.getHealthManager().queryFilterInfoIds(filterId);
        }
        for (FilterHealthUpdateInfo hui : filter.filterHealthUpdateInfo) {
            hui.isFilterOn = this.isPresent(hui.id, filterInfoIds);
        }
        ManagedObjectReference[] moRefs = this._infraHelper.getHealthManager().queryFilterEntities(filterId);
        if (moRefs != null && moRefs.length != 0) {
            for (ManagedObjectReference moRef : moRefs) {
                if (this._infraHelper.isCluster(moRef)) {
                    filter.isClusterLevelSet = true;
                    break;
                }
                this.turnOnFilterIfPresent(moRef, filter.filterHostInfo);
            }
        }
        return filter;
    }

    private Boolean isPresent(String id, String[] filterInfoIds) {
        for (String loopId : filterInfoIds) {
            if (!loopId.equals(id)) continue;
            return true;
        }
        return false;
    }

    private void turnOnFilterIfPresent(ManagedObjectReference moRef, FilterHostInfo[] hostInfos) {
        for (FilterHostInfo fhi : hostInfos) {
            if (!StringUtils.isNotEmpty((String)fhi.hostMoref) || !fhi.hostMoref.equals(moRef.getValue())) continue;
            fhi.isFilterOn = true;
        }
    }

    private String getTargetFilterId(String targetFilter) {
        if (!this.isReadyToBuild().booleanValue()) {
            return null;
        }
        HealthUpdateManager hm = this._infraHelper.getHealthManager();
        try {
            String[] filterIds;
            for (String id : filterIds = hm.queryFilterList(this._providerId)) {
                String filterName = hm.queryFilterName(id);
                _logger.error((Object)("Printing Filter Info : " + filterName));
                if (StringUtils.isEmpty((String)filterName) || !filterName.equals(targetFilter)) continue;
                return id;
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Filter Not found. This is normal since the filter may not be created yet");
        }
        return null;
    }

    private Boolean handleFilterManagedEntities(ArrayList<String> strMorefs, String filterId) throws NotFound {
        if (strMorefs == null || strMorefs.size() == 0) {
            return false;
        }
        ManagedObjectReference[] moList = new ManagedObjectReference[strMorefs.size()];
        int count = 0;
        for (String strMoref : strMorefs) {
            moList[count] = this._infraHelper.getMorefFromString(strMoref);
            _logger.debug((Object)String.format("To be Filtered Managed Entity {%s} ", moList[count].getValue()));
            ++count;
        }
        if (moList.length != 0) {
            this._infraHelper.getHealthManager().addFilterEntities(filterId, moList);
        }
        return true;
    }
}

