/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cluster.rp;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.cluster.rp.MorSerDes;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MorTree<M extends Serializable, I extends Serializable>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final Log _logger = LogFactory.getLog(MorTree.class);
    private M metadata;
    private ManagedObjectReference rootMor;
    private Map<ManagedObjectReference, List<ManagedObjectReference>> parentChildMap = new HashMap<ManagedObjectReference, List<ManagedObjectReference>>();
    private Set<ManagedObjectReference> morSet = new HashSet<ManagedObjectReference>();
    private Map<ManagedObjectReference, I> morToInfoMap = new HashMap<ManagedObjectReference, I>();
    private MorSerDes morSerDes = new MorSerDes();

    public M getMetadata() {
        return this.metadata;
    }

    public void setMetadata(M metadata) {
        this.metadata = metadata;
    }

    public ManagedObjectReference getRootMor() {
        return this.rootMor;
    }

    public void setRootMor(ManagedObjectReference rootMor) {
        Validate.notNull((Object)rootMor);
        if (this.rootMor != null) {
            throw new IllegalStateException("Root node already set");
        }
        this.rootMor = rootMor;
        this.morSet.add(rootMor);
    }

    public int getNodesCount() {
        return this.morSet.size();
    }

    public void addChild(ManagedObjectReference parent, ManagedObjectReference child) {
        Validate.notNull((Object)parent);
        Validate.notNull((Object)child);
        if (!this.morSet.contains(parent)) {
            throw new IllegalArgumentException("The parent node is not contained in the tree");
        }
        if (this.morSet.contains(child)) {
            throw new IllegalArgumentException("The child node is contained in the tree. Adding this node will transform the tree into graph");
        }
        this.morSet.add(child);
        List<ManagedObjectReference> childList = this.parentChildMap.get(parent);
        if (childList == null) {
            childList = new LinkedList<ManagedObjectReference>();
            this.parentChildMap.put(parent, childList);
        }
        childList.add(child);
    }

    public boolean removeChild(ManagedObjectReference parent, ManagedObjectReference child) {
        Validate.notNull((Object)parent);
        Validate.notNull((Object)child);
        List<ManagedObjectReference> childList = this.parentChildMap.get(parent);
        if (childList == null) {
            return false;
        }
        this.morSet.remove(child);
        boolean childContained = childList.remove(child);
        if (childList.isEmpty()) {
            this.parentChildMap.remove(parent);
        }
        return childContained;
    }

    public List<ManagedObjectReference> getChildren(ManagedObjectReference parent) {
        Validate.notNull((Object)parent);
        List<ManagedObjectReference> childList = this.parentChildMap.get(parent);
        if (childList == null) {
            return Collections.emptyList();
        }
        return new ArrayList<ManagedObjectReference>(childList);
    }

    public I getInfo(ManagedObjectReference mor) {
        Validate.notNull((Object)mor);
        return (I)((Serializable)this.morToInfoMap.get(mor));
    }

    public I putInfo(ManagedObjectReference mor, I info) {
        Validate.notNull((Object)mor);
        if (!this.morSet.contains(mor)) {
            throw new IllegalArgumentException("mor is not contained in the tree");
        }
        return (I)((Serializable)this.morToInfoMap.put(mor, info));
    }

    public I removeInfo(ManagedObjectReference mor) {
        Validate.notNull((Object)mor);
        return (I)((Serializable)this.morToInfoMap.remove(mor));
    }

    public void traverse(Visitor<? super I> visitor) throws Exception {
        ParentChildPair parentChildPair;
        Validate.notNull(visitor);
        LinkedList<ParentChildPair> refQueue = new LinkedList<ParentChildPair>();
        refQueue.add(new ParentChildPair(this, null, this.rootMor));
        while ((parentChildPair = (ParentChildPair)refQueue.poll()) != null) {
            Serializable info;
            boolean shouldContinue;
            ManagedObjectReference mor = parentChildPair.child;
            List<Object> children = this.parentChildMap.get(mor);
            if (children == null) {
                children = Collections.emptyList();
            }
            if (!(shouldContinue = visitor.visit(mor, info = (Serializable)this.morToInfoMap.get(mor), (Serializable)parentChildPair.parentInfo, (List<ManagedObjectReference>)children))) {
                return;
            }
            for (ManagedObjectReference managedObjectReference : children) {
                refQueue.add(new ParentChildPair(this, info, managedObjectReference));
            }
        }
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeObject(this.getMetadata());
        this.morSerDes.serialize(this.getRootMor(), out);
        out.writeInt(this.getNodesCount());
        try {
            this.traverse(new Visitor<Serializable>(){

                @Override
                public boolean visit(ManagedObjectReference mor, Serializable info, Serializable parentInfo, List<ManagedObjectReference> children) throws Exception {
                    MorTree.this.morSerDes.serialize(mor, out);
                    out.writeObject(info);
                    out.writeInt(children.size());
                    for (ManagedObjectReference child : children) {
                        MorTree.this.morSerDes.serialize(child, out);
                    }
                    return true;
                }
            });
        }
        catch (Exception e) {
            _logger.error((Object)"Error occurred during mor tree traversal ", (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setMetadata((Serializable)in.readObject());
        this.setRootMor(this.morSerDes.deserialize(in));
        int nodesCount = in.readInt();
        for (int i = 0; i < nodesCount; ++i) {
            ManagedObjectReference mor = this.morSerDes.deserialize(in);
            Serializable info = (Serializable)in.readObject();
            if (info != null) {
                this.putInfo(mor, info);
            }
            int childListSize = in.readInt();
            for (int j = 0; j < childListSize; ++j) {
                ManagedObjectReference child = this.morSerDes.deserialize(in);
                this.addChild(mor, child);
            }
        }
    }

    public static interface Visitor<I> {
        public boolean visit(ManagedObjectReference var1, I var2, I var3, List<ManagedObjectReference> var4) throws Exception;
    }

    private static class ParentChildPair {
        public I parentInfo;
        public ManagedObjectReference child;
        final /* synthetic */ MorTree this$0;

        public ParentChildPair(I parentInfo, ManagedObjectReference child) {
            this.this$0 = var1_1;
            this.parentInfo = parentInfo;
            this.child = child;
        }
    }
}

