/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cluster.rp;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.commands.DataFetchCommand;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.cluster.rp.ClusterDataModel;
import com.vmware.vsphere.client.cluster.rp.MorTree;
import com.vmware.vsphere.client.cluster.rp.RestoreRpTreeValidationResult;
import com.vmware.vsphere.client.cluster.rp.RpDataModel;
import com.vmware.vsphere.client.cluster.rp.RpInfo;
import com.vmware.vsphere.client.cluster.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class RestoreRpTreeValidator {
    private static final String[] REQUIRED_VMS_PRIVILEGES = new String[]{"Resource.AssignVMToPool"};
    private static final String PROPERTY_NAME = "name";
    private final ManagedObjectReference _clusterRef;
    private final MorTree<ManagedObjectReference, RpInfo> _rpTree;
    private final DataFetchCommand _dataFetchCommand;
    private final QueryService _queryService;

    public RestoreRpTreeValidator(ManagedObjectReference clusterRef, MorTree<ManagedObjectReference, RpInfo> rpTree, DataFetchCommand dataFetchCommand, QueryService queryService) {
        Validate.notNull((Object)clusterRef);
        Validate.notNull(rpTree);
        Validate.notNull((Object)dataFetchCommand);
        Validate.notNull((Object)queryService);
        this._clusterRef = clusterRef;
        this._rpTree = rpTree;
        this._dataFetchCommand = dataFetchCommand;
        this._queryService = queryService;
    }

    public RestoreRpTreeValidationResult validate() throws Exception {
        if (!this._clusterRef.equals((Object)this._rpTree.getMetadata())) {
            return new RestoreRpTreeValidationResult(RestoreRpTreeValidationResult.ValidationResultType.DIFFERENT_CLUSTER_ERROR);
        }
        ClusterDataModel clusterData = Util.getDataModel(ClusterDataModel.class, this._clusterRef, this._dataFetchCommand);
        if (clusterData == null) {
            throw new Exception("Error retrieving data for cluster: " + this._clusterRef);
        }
        if (!clusterData.drsEnabled) {
            return new RestoreRpTreeValidationResult(RestoreRpTreeValidationResult.ValidationResultType.DRS_DISABLED_ERROR);
        }
        if (clusterData.childRps != null && clusterData.childRps.length > 0) {
            return new RestoreRpTreeValidationResult(RestoreRpTreeValidationResult.ValidationResultType.HAS_CHILD_RP_ERROR);
        }
        List<String> vmsToMoveInToRps = this.getVmsToMoveInToRps();
        if (!vmsToMoveInToRps.isEmpty()) {
            return new RestoreRpTreeValidationResult(RestoreRpTreeValidationResult.ValidationResultType.VMS_WITH_MISSING_PRIVILEGES_ERROR, vmsToMoveInToRps);
        }
        return new RestoreRpTreeValidationResult(RestoreRpTreeValidationResult.ValidationResultType.SUCCESS);
    }

    private List<String> getVmsToMoveInToRps() throws Exception {
        RpDataModel rootRpData = Util.getDataModel(RpDataModel.class, this._rpTree.getRootMor(), this._dataFetchCommand);
        if (rootRpData == null) {
            throw new Exception("Error retrieving data for cluster root resource pool: " + this._rpTree.getRootMor());
        }
        ArrayList<String> vmsToMoveInToRpsNames = new ArrayList<String>();
        if (rootRpData.vms != null && rootRpData.vms.length > 0) {
            final HashSet presentVmsSet = new HashSet();
            Collections.addAll(presentVmsSet, rootRpData.vms);
            final ArrayList vmsToMoveInToRpsIds = new ArrayList();
            this._rpTree.traverse(new MorTree.Visitor<RpInfo>(){

                @Override
                public boolean visit(ManagedObjectReference mor, RpInfo info, RpInfo parentInfo, List<ManagedObjectReference> children) throws Exception {
                    if (parentInfo == null) {
                        return true;
                    }
                    for (ManagedObjectReference vm : info.getVms()) {
                        if (!presentVmsSet.contains(vm)) continue;
                        vmsToMoveInToRpsIds.add(vm);
                    }
                    return true;
                }
            });
            if (!vmsToMoveInToRpsIds.isEmpty()) {
                ResultSet resultSet = this._queryService.select(new String[]{"grantedPrivileges", PROPERTY_NAME}).from(new String[]{VirtualMachine.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, vmsToMoveInToRpsIds).fetch();
                for (ResourceItem item : resultSet.getItems()) {
                    String[] grantedPriv = (String[])item.get("grantedPrivileges");
                    if (!AuthorizationUtil.isPrivilegeGranted((String[])REQUIRED_VMS_PRIVILEGES, (String[])grantedPriv)) {
                        vmsToMoveInToRpsNames.add((String)item.get(PROPERTY_NAME));
                    }
                    if (vmsToMoveInToRpsNames.size() != 6) continue;
                    break;
                }
            }
        }
        return vmsToMoveInToRpsNames;
    }
}

