/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cluster.rp;

import com.vmware.vim.binding.vim.ResourceConfigSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.cluster.rp.MorSerDes;
import com.vmware.vsphere.client.cluster.rp.ResourceConfigSpecSerDes;
import com.vmware.vsphere.client.cluster.rp.RpDataModel;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class RpInfo
implements Externalizable {
    private static final long serialVersionUID = 2L;
    private String name;
    private ResourceConfigSpec configSpec;
    private List<ManagedObjectReference> vms = new LinkedList<ManagedObjectReference>();
    private ResourceConfigSpecSerDes resourceConfigSpecSerDes = new ResourceConfigSpecSerDes();
    private MorSerDes morSerDes = new MorSerDes();
    private boolean sharesScalable = false;

    public RpInfo() {
    }

    public RpInfo(RpDataModel rpDataModel) {
        Validate.notNull((Object)((Object)rpDataModel));
        this.name = rpDataModel.name;
        this.configSpec = rpDataModel.configSpec;
        if (rpDataModel.vms != null) {
            for (ManagedObjectReference vm : rpDataModel.vms) {
                this.vms.add(vm);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResourceConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public void setConfigSpec(ResourceConfigSpec configSpec) {
        this.configSpec = configSpec;
    }

    public boolean getSharesScalable() {
        return this.sharesScalable;
    }

    public void setSharesScalable(boolean sharesScalable) {
        this.sharesScalable = sharesScalable;
    }

    public void addVm(ManagedObjectReference vmRef) {
        Validate.notNull((Object)vmRef);
        this.vms.add(vmRef);
    }

    public boolean removeVm(ManagedObjectReference vmRef) {
        Validate.notNull((Object)vmRef);
        return this.vms.remove(vmRef);
    }

    public List<ManagedObjectReference> getVms() {
        return new ArrayList<ManagedObjectReference>(this.vms);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.name);
        this.resourceConfigSpecSerDes.serialize(this.configSpec, out);
        out.writeInt(this.vms.size());
        for (ManagedObjectReference vmMor : this.vms) {
            this.morSerDes.serialize(vmMor, out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = (String)in.readObject();
        this.configSpec = this.resourceConfigSpecSerDes.deserialize(in);
        int vmsSize = in.readInt();
        for (int i = 0; i < vmsSize; ++i) {
            this.vms.add(this.morSerDes.deserialize(in));
        }
    }
}

