/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.impl;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.clusterui.model.configuration.ClusterVclsDatastoresData;
import java.util.Arrays;
import java.util.Collection;

public class ClusterVclsPropertyProvider {
    private final QueryBindingService _queryBindingService;

    public ClusterVclsPropertyProvider(QueryBindingServiceFactory queryBindingServiceFactory) {
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
    }

    @PropertyProvider(value="ClusterComputeResource/vclsRestrictedDatastores")
    public ClusterVclsDatastoresData[] getVclsRestrictedDatastores(ManagedObjectReference clusterMoRef) throws Exception {
        ClusterComputeResource cluster = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)clusterMoRef);
        ManagedObjectReference[] restrictedDatastores = cluster.getSystemVMsRestrictedDatastores();
        if (restrictedDatastores != null) {
            Collection result = this._queryBindingService.prepare(ClusterVclsDatastoresData.class).fetch(Arrays.asList(restrictedDatastores));
            return result.toArray(new ClusterVclsDatastoresData[0]);
        }
        return new ClusterVclsDatastoresData[0];
    }
}

