/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.impl;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vsphere.client.clusterui.model.FtPortletData;
import com.vmware.vsphere.client.clusterui.model.services.VmFTPrimaryData;

public class FtStatusPropertyProvider
implements PropertyProviderBean {
    private final QueryBindingService _queryBindingService;

    public FtStatusPropertyProvider(QueryBindingService queryBindingService) {
        this._queryBindingService = queryBindingService;
    }

    @ModelMetadata(type={"VirtualMachine"}, propertyNamespace="ftportlet", property="ftdata")
    public FtPortletData getFtData(ManagedObjectReference vmMor) {
        VmFTPrimaryData ftPrimaryVmData = (VmFTPrimaryData)this._queryBindingService.prepare(VmFTPrimaryData.class).fetch((Object)vmMor);
        FtPortletData dataModel = new FtPortletData();
        if (ftPrimaryVmData == null || ftPrimaryVmData.ftState == null) {
            return dataModel;
        }
        if (this.isFtStateVisible(ftPrimaryVmData)) {
            dataModel.isFtStatusImageVisible = true;
            dataModel.isFtStateLabelVisible = true;
            dataModel.ftStateLabelKey = this.getFtStateLabelKey(ftPrimaryVmData);
        } else {
            dataModel.isFtStatusImageVisible = false;
            dataModel.isFtStateLabelVisible = false;
        }
        dataModel.ftStatusLabelKey = this.getStatusLabelKey(ftPrimaryVmData);
        String ftState = ftPrimaryVmData.ftState.name();
        boolean isLocationLinkVisible = false;
        switch (ftState) {
            case "starting": 
            case "enabled": 
            case "running": 
            case "disabled": {
                if (ftPrimaryVmData.secondaries == null || ftPrimaryVmData.secondaries.length <= 0) break;
                dataModel.secondaryHost = ftPrimaryVmData.secondaries[0].host;
                isLocationLinkVisible = true;
                dataModel.secondaryLocationHost = ftPrimaryVmData.secondaries[0].hostName;
                break;
            }
        }
        dataModel.isLocationBlockVisible = isLocationLinkVisible;
        dataModel.ftStatusDescription = this.getStatusDescriptionKey(ftPrimaryVmData.ftState, ftPrimaryVmData.powerState);
        dataModel.logBandwidth = ftPrimaryVmData.ftLogBandwidth;
        return dataModel;
    }

    private String getStatusLabelKey(VmFTPrimaryData ftData) {
        String ftState = ftData.ftState.name();
        String powerState = ftData.powerState == null ? null : ftData.powerState.name();
        String ftStatusLabel = null;
        switch (ftState) {
            case "disabled": 
            case "needSecondary": 
            case "starting": {
                ftStatusLabel = "ftStatus.notProtected";
                break;
            }
            case "enabled": {
                if ("poweredOn".equals(powerState)) {
                    ftStatusLabel = "ftStatus.protected";
                    break;
                }
                ftStatusLabel = "ftStatus.notProtected";
                break;
            }
            case "running": {
                ftStatusLabel = "ftStatus.protected";
            }
        }
        return ftStatusLabel;
    }

    private String getFtStateLabelKey(VmFTPrimaryData ftData) {
        String ftStateLabel = null;
        String ftState = ftData.ftState.name();
        String powerState = ftData.powerState == null ? null : ftData.powerState.name();
        switch (ftState) {
            case "needSecondary": {
                ftStateLabel = "ftState.needSecondary";
                break;
            }
            case "starting": {
                ftStateLabel = "ftState.starting";
                break;
            }
            case "enabled": {
                if ("poweredOn".equals(powerState)) break;
                ftStateLabel = "ftState.notRunning";
                break;
            }
        }
        return ftStateLabel;
    }

    private boolean isFtStateVisible(VmFTPrimaryData ftData) {
        VirtualMachine.FaultToleranceState ftState = ftData.ftState;
        VirtualMachine.PowerState powerState = ftData.powerState;
        boolean isVisible = false;
        if (VirtualMachine.FaultToleranceState.needSecondary.equals((Object)ftState) || VirtualMachine.FaultToleranceState.starting.equals((Object)ftState) || VirtualMachine.FaultToleranceState.enabled.equals((Object)ftState) && !VirtualMachine.PowerState.poweredOn.equals((Object)powerState)) {
            isVisible = true;
        }
        return isVisible;
    }

    private String getStatusDescriptionKey(VirtualMachine.FaultToleranceState ftState, VirtualMachine.PowerState powerState) {
        String ftStatusTooltip;
        if (ftState == null) {
            return "";
        }
        switch (ftState) {
            case disabled: {
                ftStatusTooltip = "ftStatusTooltip.suspended";
                break;
            }
            case needSecondary: {
                ftStatusTooltip = "ftStatusTooltip.needSecondary";
                break;
            }
            case starting: {
                ftStatusTooltip = "ftStatusTooltip.starting";
                break;
            }
            case enabled: {
                if (!powerState.equals((Object)VirtualMachine.PowerState.poweredOn)) {
                    ftStatusTooltip = "ftStatusTooltip.enabledNotPoweredOn";
                    break;
                }
                ftStatusTooltip = "ftStatusTooltip.enabledPoweredOn";
                break;
            }
            case running: {
                ftStatusTooltip = "ftStatusTooltip.running";
                break;
            }
            default: {
                ftStatusTooltip = "";
            }
        }
        return ftStatusTooltip;
    }
}

