/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.impl;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.cluster.DasAdvancedRuntimeInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.clusterui.model.services.HeartbeatDatastoreData;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.collections4.CollectionUtils;

public final class HaPropertyProvider {
    private final QueryBindingService _queryBindingService;

    public HaPropertyProvider(QueryBindingService queryBindingService) {
        this._queryBindingService = queryBindingService;
    }

    @PropertyProvider(value="ClusterComputeResource/heartbeatDatastores")
    public Collection<HeartbeatDatastoreData[]> getHeartbeatDatastores(Collection<ManagedObjectReference> clusters) throws Exception {
        if (CollectionUtils.isEmpty(clusters)) {
            throw new IllegalArgumentException("Clusters collection argument cannot be null or empty.");
        }
        ManagedObjectReference clusterRef = clusters.iterator().next();
        ClusterComputeResource cluster = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)clusterRef);
        DasAdvancedRuntimeInfo.HeartbeatDatastoreInfo[] datastoreInfos = cluster.retrieveDasAdvancedRuntimeInfo().getHeartbeatDatastoreInfo();
        if (datastoreInfos == null) {
            return Collections.singleton(new HeartbeatDatastoreData[0]);
        }
        HashMap<ManagedObjectReference, ManagedObjectReference[]> datastoresToHosts = new HashMap<ManagedObjectReference, ManagedObjectReference[]>();
        for (DasAdvancedRuntimeInfo.HeartbeatDatastoreInfo datastoreInfo : datastoreInfos) {
            datastoresToHosts.put(datastoreInfo.getDatastore(), datastoreInfo.getHosts());
        }
        Collection heartbeatDatastoresData = this._queryBindingService.prepare(HeartbeatDatastoreData.class).fetch(datastoresToHosts.keySet());
        for (HeartbeatDatastoreData heartbeatDatastoreData : heartbeatDatastoresData) {
            heartbeatDatastoreData.accessibleAndMountedHosts = Arrays.asList((ManagedObjectReference[])datastoresToHosts.get(heartbeatDatastoreData.provider));
        }
        return Collections.singleton(heartbeatDatastoresData.toArray(new HeartbeatDatastoreData[0]));
    }
}

