/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.core.model.monitor.IssueStatus;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.clusterui.util.Util;
import com.vmware.vsphere.client.issue.impl.IssueAdapterBase;

@type(value="Issue,HadcsIssue")
public class HadcsIssueAdapter
extends IssueAdapterBase {
    private static final String HADCS_ISSUE_TYPE = "HadcsIssue";
    private static final String HADCS_HEALTH_STATUS_PROPERTY = "summary.vcsHealthStatus";
    private final QueryService queryService;

    public HadcsIssueAdapter(QueryService queryService) {
        super(HADCS_ISSUE_TYPE);
        this.queryService = queryService;
    }

    protected IssueAdapterBase.IssueData[] getIssues(QuerySpec querySpec, IssueAdapterBase.RequestContext requestContext) {
        Object entity = this.extractEntityFromQuerySpec(querySpec);
        if (!(entity instanceof ManagedObjectReference) || !ManagedObjectUtil.isOfType((ManagedObjectReference)((ManagedObjectReference)entity), (String)ClusterComputeResource.class.getSimpleName())) {
            return new IssueAdapterBase.IssueData[0];
        }
        ResultSet resultSet = this.queryService.select(new String[]{HADCS_HEALTH_STATUS_PROPERTY}).from(new String[]{ClusterComputeResource.class.getSimpleName()}).where(new PropertyPredicate[]{this.buildIdentityFilter(entity)}).fetch();
        if (resultSet.getItems().isEmpty()) {
            return new IssueAdapterBase.IssueData[0];
        }
        String hadcsHealthStatus = (String)((ResourceItem)resultSet.getItems().get(0)).get(HADCS_HEALTH_STATUS_PROPERTY);
        if (!ClusterComputeResource.VcsHealthStatus.nonhealthy.name().equals(hadcsHealthStatus)) {
            return new IssueAdapterBase.IssueData[0];
        }
        IssueInfo issueInfo = new IssueInfo();
        issueInfo.description = Util.getLocalizedString("hadcs.quorumIssue.description", new String[0]);
        issueInfo.typeDisplayName = Util.getLocalizedString("hadcs.quorumIssue.displayName", new String[0]);
        issueInfo.entity = entity;
        issueInfo.status = IssueStatus.ERROR;
        IssueAdapterBase.IssueData issueData = new IssueAdapterBase.IssueData();
        issueData.key = entity.toString();
        issueData.issueInfo = issueInfo;
        return new IssueAdapterBase.IssueData[]{issueData};
    }

    private PropertyPredicate buildIdentityFilter(Object entity) {
        return new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, entity);
    }
}

