/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.clusterui.MoveClusterSpec;
import com.vmware.vsphere.client.mixed.ManagedEntityMoveSpec;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.ArrayUtils;

public class MoveClusterMutationProvider
implements MutationProvider {
    private final DataService _dataService;
    private final MutationService _mutationService;

    public MoveClusterMutationProvider(DataService _dataService, MutationService mutationService) {
        this._dataService = _dataService;
        this._mutationService = mutationService;
    }

    public OperationResult apply(ManagedObjectReference targetLocation, MoveClusterSpec spec) {
        OperationResult opResult = new OperationResult();
        ManagedEntityMoveSpec moveSpec = new ManagedEntityMoveSpec();
        moveSpec.entities = spec.entities;
        try {
            opResult = this._mutationService.apply((Object)targetLocation, (Object)moveSpec);
        }
        catch (Exception e) {
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public ValidationResult validate(ManagedObjectReference targetLocation, MoveClusterSpec spec) {
        Validate.notNull((Object)spec);
        Validate.notNull((Object)spec.entities);
        ValidationResult validationResult = new ValidationResult();
        ObjectIdentityConstraint targetLocationIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)targetLocation);
        Constraint[] sourceEntitiesObjectIdentityContsraint = new Constraint[spec.entities.length];
        for (int i = 0; i < spec.entities.length; ++i) {
            sourceEntitiesObjectIdentityContsraint[i] = QueryUtil.createObjectIdentityConstraint((Object)spec.entities[i]);
        }
        CompositeConstraint sourceEntitiesConstraint = QueryUtil.createCompositeConstraint((Constraint[])sourceEntitiesObjectIdentityContsraint, (Conjoiner)Conjoiner.OR);
        CompositeConstraint constraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{sourceEntitiesConstraint, QueryUtil.createRelationalConstraint((String)"childEntity", (Constraint)targetLocationIdentityConstraint, (Boolean)true, (String)ClusterComputeResource.class.getSimpleName())}, (Conjoiner)Conjoiner.AND);
        QuerySpec querySpec = new QuerySpec();
        querySpec.resourceSpec = QueryUtil.createEmptyResourceSpec();
        querySpec.resourceSpec.constraint = constraint;
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response response = this._dataService.getData(requestSpec);
        validationResult.result = ArrayUtils.isEmpty((Object[])response.resultSet);
        if (!((Boolean)validationResult.result).booleanValue()) {
            boolean areAllEntitiesInTheTarget;
            boolean bl = areAllEntitiesInTheTarget = response.resultSet[0].totalMatchedObjectCount <= spec.entities.length;
            if (spec.entities.length > 1) {
                areAllEntitiesInTheTarget = response.resultSet[0].totalMatchedObjectCount == 0;
            }
            validationResult.result = areAllEntitiesInTheTarget;
        }
        return validationResult;
    }
}

