/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model;

import com.vmware.cis.data.model.DerivedProperty;
import com.vmware.cis.data.model.SourceProperty;
import com.vmware.vim.binding.vim.AuthorizationManager;
import com.vmware.vim.binding.vim.Capability;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.cluster.DasAdmissionControlPolicy;
import com.vmware.vim.binding.vim.cluster.FailoverLevelAdmissionControlPolicy;
import com.vmware.vim.binding.vim.cluster.FailoverResourcesAdmissionControlPolicy;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.security.impl.VCAuthorizationUtil;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.lang3.Validate;

public class ClusterComputeResourceExtendedDataModel {
    @DerivedProperty(value="ClusterComputeResource/isHaAdvancedRuntimeInfoPortletAvailable")
    public static boolean isHaAdvancedRuntimeInfoPortletAvailable(@SourceProperty(value="ClusterComputeResource/configurationEx/dasConfig/admissionControlPolicy") DasAdmissionControlPolicy policy, @SourceProperty(value="ClusterComputeResource/configurationEx/dasConfig/admissionControlEnabled") boolean isAdmissionControlEnabled) {
        boolean isPolicyTypeCorrect = policy instanceof FailoverLevelAdmissionControlPolicy;
        return isPolicyTypeCorrect && isAdmissionControlEnabled;
    }

    @DerivedProperty(value="ClusterComputeResource/isHaAdvancedRuntimeInfoResourcesPortletAvailable")
    public static boolean isHaAdvancedRuntimeInfoResourcesPortletAvailable(@SourceProperty(value="ClusterComputeResource/configurationEx/dasConfig/admissionControlPolicy") DasAdmissionControlPolicy policy, @SourceProperty(value="ClusterComputeResource/configurationEx/dasConfig/admissionControlEnabled") boolean isAdmissionControlEnabled) {
        boolean isPolicyTypeCorrect = policy instanceof FailoverResourcesAdmissionControlPolicy;
        return isPolicyTypeCorrect && isAdmissionControlEnabled;
    }

    @DerivedProperty(value="ClusterComputeResource/environmentBrowserAvailable")
    public static boolean getEnvironmentBrowserAvailable(@SourceProperty(value="ClusterComputeResource/environmentBrowser") ManagedObjectReference environmentBrowser) {
        return environmentBrowser != null;
    }

    @DerivedProperty(value="ClusterComputeResource/isAutonomous")
    public static boolean isAutonomous(@SourceProperty(value="ClusterComputeResource/clusterType") String clusterType) {
        return ClusterComputeResource.ClusterType.autonomousCluster.toString().equals(clusterType);
    }

    @DerivedProperty(value="ClusterComputeResource/isAddHostsAvailable")
    public static boolean getIsAddHostsAvailable(@SourceProperty(value="ClusterComputeResource/@instanceUuid") String vcServerGuid, @SourceProperty(value="ClusterComputeResource/effectiveRole") int[] effectiveRole) throws Exception {
        String EDIT_CLUSTER_PRIVILEGE = "Host.Inventory.EditCluster";
        String ADD_HOST_TO_CLUSTER_PRIVILEGE = "Host.Inventory.AddHostToCluster";
        Validate.notNull((Object)vcServerGuid);
        boolean hciWorkflowSupported = false;
        Capability capability = ClusterComputeResourceExtendedDataModel.getCapability(vcServerGuid);
        if (capability != null) {
            hciWorkflowSupported = capability.getHciWorkflowSupported();
        }
        String[] grantedPrivileges = ClusterComputeResourceExtendedDataModel.getGrantedPrivileges(effectiveRole, vcServerGuid);
        if (hciWorkflowSupported) {
            return AuthorizationUtil.isPrivilegeGranted((String[])new String[]{"Host.Inventory.EditCluster"}, (String[])grantedPrivileges);
        }
        return AuthorizationUtil.isPrivilegeGranted((String[])new String[]{"Host.Inventory.AddHostToCluster"}, (String[])grantedPrivileges);
    }

    private static Capability getCapability(String vcServerGuid) {
        VcService service = VimSessionUtil.getService((String)vcServerGuid);
        if (service == null) {
            return null;
        }
        ServiceInstance serviceInstance = service.getServiceInstance();
        if (serviceInstance == null) {
            return null;
        }
        return serviceInstance.getCapability();
    }

    private static String[] getGrantedPrivileges(int[] effectiveRole, String vcServerGuid) throws Exception {
        if (effectiveRole == null) {
            return new String[0];
        }
        HashSet grantedPrivileges = new HashSet();
        for (int roleId : effectiveRole) {
            AuthorizationManager.Role r = VCAuthorizationUtil.getRole((Integer)roleId, (String)vcServerGuid);
            if (r == null || r.privilege == null) continue;
            Collections.addAll(grantedPrivileges, r.privilege);
        }
        return grantedPrivileges.toArray(new String[0]);
    }
}

