/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.configuration;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.EVCMode;
import com.vmware.vim.binding.vim.FeatureEVCMode;
import com.vmware.vim.binding.vim.host.FeatureCapability;
import com.vmware.vim.binding.vim.host.FeatureMask;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import org.apache.commons.lang3.ArrayUtils;

@QueryBinding(value="ClusterComputeResource")
public class EvcConfigData
extends IdentifiableQueryBinding {
    @Property(value="ClusterComputeResource/summary/currentEVCModeKey")
    public String evcModeKey;
    @Property(value="ClusterComputeResource/summary/currentEVCGraphicsModeKey")
    public String graphicsEvcModeKey;
    @Property(value="ClusterComputeResource/supportedEvcMode")
    public EVCMode[] supportedEvcModes;
    @Property(value="ClusterComputeResource/supportedGraphicsEvcMode")
    public FeatureEVCMode[] supportedGraphicsEvcModes;
    @Property(value="ClusterComputeResource/actualEvcFeatureMask")
    public transient FeatureMask[] realtimeEvcFeatureMask;
    @Property(value="ClusterComputeResource/actualEvcFeatureCapability")
    public transient FeatureCapability[] realtimeEvcFeatureCapability;

    public FeatureMask[] getActualEvcFeatureMask() {
        this.localizeFeatureNames(this.realtimeEvcFeatureMask);
        return this.realtimeEvcFeatureMask;
    }

    public FeatureCapability[] getActualEvcFeatureCapability() {
        this.localizeFeatureNames(this.realtimeEvcFeatureCapability);
        return this.realtimeEvcFeatureCapability;
    }

    public EVCMode getCurrentEvcMode() {
        if (this.evcModeKey == null || this.supportedEvcModes == null) {
            return null;
        }
        for (EVCMode evcMode : this.supportedEvcModes) {
            if (!evcMode.getKey().equals(this.evcModeKey)) continue;
            return evcMode;
        }
        return null;
    }

    public FeatureEVCMode getCurrentGraphicsEvcMode() {
        if (this.graphicsEvcModeKey == null || this.supportedGraphicsEvcModes == null) {
            return null;
        }
        for (FeatureEVCMode evcMode : this.supportedGraphicsEvcModes) {
            if (!this.graphicsEvcModeKey.equals(evcMode.getKey())) continue;
            return evcMode;
        }
        return null;
    }

    private void localizeFeatureNames(Object[] features) {
        if (!ArrayUtils.isEmpty((Object[])features)) {
            for (Object feature : features) {
                String localizedMaskName;
                String localizationKey = "";
                if (feature instanceof FeatureMask) {
                    FeatureMask featureMask = (FeatureMask)feature;
                    localizationKey = featureMask.getKey().toLowerCase();
                    localizedMaskName = LocalizationUtil.getLocalizedMessage((String)localizationKey);
                    featureMask.setFeatureName(localizedMaskName);
                }
                if (!(feature instanceof FeatureCapability)) continue;
                FeatureCapability featureCapability = (FeatureCapability)feature;
                localizationKey = featureCapability.getKey().toLowerCase();
                localizedMaskName = LocalizationUtil.getLocalizedMessage((String)localizationKey);
                featureCapability.setFeatureName(localizedMaskName);
            }
        }
    }
}

