/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.monitor.reservation;

import com.vmware.cis.data.model.NestedQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.BaseCapacityData;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.ResourcePoolCpuCapacityData;
import com.vmware.vsphere.client.clusterui.util.Util;

@QueryBinding(value="ClusterComputeResource")
public class ClusterCpuCapacityData
extends BaseCapacityData {
    @Property(value="ClusterComputeResource/isVclsEnabled")
    public boolean isVclsEnabled;
    @NestedQueryBinding
    @Relationship(value={"ClusterComputeResource/resourcePool"})
    public ResourcePoolCpuCapacityData resourcePool;
    @Property(value="ClusterComputeResource/systemVmCpuReservationMhz")
    protected long systemVmCpuReservationMhz;
    @Property(value="ClusterComputeResource/totalCpuCapacity")
    protected long totalCapacity;

    @Override
    public String getReservationCapacityFormatted() {
        if (this.isVclsEnabled) {
            return Util.getCpuFormatted(this.getResourcePool().getReservationCapacity() + this.systemVmCpuReservationMhz);
        }
        return this.getResourcePool().getRpReservationCapacityFormatted();
    }

    @Override
    public double getActivePercentage() {
        if (this.isVclsEnabled) {
            return Util.getPercentageValue(this.getResourcePool().getReservedCapacity(), this.getResourcePool().getReservationCapacity() + this.systemVmCpuReservationMhz);
        }
        return this.getResourcePool().getActivePercentage();
    }

    public String getVmReservationFormatted() {
        return Util.getCpuFormatted(this.systemVmCpuReservationMhz);
    }

    public String getTotalCapacityFormatted() {
        return Util.getCpuFormatted(this.totalCapacity);
    }

    public double getVclsActivePercentage() {
        return Util.getPercentageValue(this.systemVmCpuReservationMhz, this.getResourcePool().getReservationCapacity() + this.systemVmCpuReservationMhz);
    }

    @Override
    protected ResourcePoolCpuCapacityData getResourcePool() {
        return this.resourcePool;
    }
}

