/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.monitor.reservation;

import com.vmware.cis.data.model.NestedQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.BaseCapacityData;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.ResourcePoolMemoryCapacityData;
import com.vmware.vsphere.client.clusterui.util.Util;

@QueryBinding(value="ClusterComputeResource")
public class ClusterMemoryCapacityData
extends BaseCapacityData {
    @Property(value="ClusterComputeResource/isVclsEnabled")
    public boolean isVclsEnabled;
    @NestedQueryBinding
    @Relationship(value={"ClusterComputeResource/resourcePool"})
    public ResourcePoolMemoryCapacityData resourcePool;
    @Property(value="ClusterComputeResource/systemVmMemReservationMb")
    private long systemVmMemReservationMb;
    @Property(value="ClusterComputeResource/totalMemoryCapacity")
    protected long totalCapacity;

    @Override
    public String getReservationCapacityFormatted() {
        if (this.isVclsEnabled) {
            return Util.getBytesMemoryFormatted(this.getResourcePool().getReservationCapacity() + this.convertToByte(this.systemVmMemReservationMb));
        }
        return this.getResourcePool().getRpReservationCapacityFormatted();
    }

    @Override
    public double getActivePercentage() {
        if (this.isVclsEnabled) {
            return Util.getPercentageValue(this.getResourcePool().getReservedCapacity(), this.getResourcePool().getReservationCapacity() + this.convertToByte(this.systemVmMemReservationMb));
        }
        return this.getResourcePool().getActivePercentage();
    }

    public String getVmReservationFormatted() {
        return Util.getMbMemoryFormatted(this.systemVmMemReservationMb);
    }

    public String getTotalCapacityFormatted() {
        return Util.getMbMemoryFormatted(this.totalCapacity);
    }

    public double getVclsActivePercentage() {
        return Util.getPercentageValue(this.convertToByte(this.systemVmMemReservationMb), this.getResourcePool().getReservationCapacity() + this.convertToByte(this.systemVmMemReservationMb));
    }

    @Override
    protected ResourcePoolMemoryCapacityData getResourcePool() {
        return this.resourcePool;
    }

    private long convertToByte(long value) {
        return value * 0x100000L;
    }
}

