/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.monitor.reservation;

import com.vmware.cis.data.model.NestedQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.VmPMemReservationUsersData;
import com.vmware.vsphere.client.clusterui.util.Util;

@QueryBinding(value="ClusterComputeResource")
public class ClusterPMemCapacityData {
    @Property(value="ClusterComputeResource/pmemHaCapable")
    public boolean pMemHaCapable;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/admissionControlPolicy/pMemAdmissionControlEnabled")
    public boolean pMemAdmissionControlEnabled;
    @NestedQueryBinding
    @Relationship(value={"ClusterComputeResource/vm"})
    public VmPMemReservationUsersData[] vmPMemUsageData;
    @Property(value="ClusterComputeResource/totalPMemReservationCapacity")
    public long totalPMemReservationCapacity;
    @Property(value="ClusterComputeResource/pMemVmReservation")
    public long pMemVmReservation;
    @Property(value="ClusterComputeResource/totalPMemCapacity")
    private transient long totalPMemCapacity;
    @Property(value="ClusterComputeResource/pMemFailoverReservation")
    private transient long pMemFailoverReservation;

    public long getAvailablePMem() {
        return this.totalPMemReservationCapacity - this.pMemFailoverReservation - this.pMemVmReservation;
    }

    public String getTotalPMemCapacityFormatted() {
        return Util.getMbMemoryFormatted(this.totalPMemCapacity);
    }

    public String getTotalPMemReservationCapacityFormatted() {
        return Util.getMbMemoryFormatted(this.totalPMemReservationCapacity);
    }

    public String getPMemVmReservationFormatted() {
        return Util.getMbMemoryFormatted(this.pMemVmReservation);
    }

    public String getAvailablePMemFormatted() {
        return Util.getMbMemoryFormatted(this.getAvailablePMem());
    }

    public String getPMemFailoverReservationFormatted() {
        return Util.getMbMemoryFormatted(this.pMemFailoverReservation);
    }

    public double getPMemVmReservationPercentage() {
        return Util.getPercentageValue(this.pMemVmReservation, this.totalPMemReservationCapacity);
    }

    public double getAvailablePMemPercentage() {
        return Util.getPercentageValue(this.getAvailablePMem(), this.totalPMemReservationCapacity);
    }

    public double getPMemFailoverReservationPercentage() {
        return Util.getPercentageValue(this.pMemFailoverReservation, this.totalPMemReservationCapacity);
    }
}

