/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.monitor.reservation;

import com.vmware.cis.data.model.NestedQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vim.vm.device.VirtualDisk;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.VmStorageReservationUsersData;
import com.vmware.vsphere.client.drs.model.IdentifiableModelImpl;

@QueryBinding(value="Datastore")
public class DatastoreStorageVmData
extends IdentifiableModelImpl {
    @Property(value="Datastore/name")
    public String name;
    @NestedQueryBinding
    @Relationship(value={"Datastore/vm"})
    public VmStorageReservationUsersData[] vms;

    public int getTotalShares() {
        int totalShares = 0;
        for (VmStorageReservationUsersData vm : this.vms) {
            if (vm == null || vm.virtualDisks == null) continue;
            for (VirtualDisk vd : vm.virtualDisks) {
                if (vd == null || vd.shares == null) continue;
                totalShares += vd.shares.getShares();
            }
        }
        return totalShares;
    }
}

