/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.monitor.utilization;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.SharesInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.clusterui.model.monitor.utilization.MemoryBaseUtilizationData;
import com.vmware.vsphere.client.clusterui.util.Util;

@QueryBinding(value="AnyResourcePool")
public class ResourcePoolMemoryUtilizationData
extends MemoryBaseUtilizationData {
    @Property(value="AnyResourcePool/summary/quickStats/hostMemoryUsage")
    protected Long consummation;
    @Property(value="AnyResourcePool/summary/quickStats/consumedOverheadMemory")
    protected Long overheadMemory;
    @Property(value="AnyResourcePool/config/memoryAllocation/reservation")
    protected Long reservation;
    @Property(value="AnyResourcePool/config/memoryAllocation/limit")
    protected Long limit;
    @Property(value="AnyResourcePool/summary/configuredMemoryMB")
    protected Integer resourceSize;
    @Property(value="AnyResourcePool/config/memoryAllocation/shares")
    protected SharesInfo sharesInfo;
    @Property(value="AnyResourcePool/summary/quickStats/staticMemoryEntitlement")
    protected Integer staticEntitlement;
    @Relationship(value={"AnyResourcePool/cluster"})
    @Property(value="ClusterComputeResource/configurationEx/drsConfig/enabled")
    public boolean clusterDrsEnabled;
    @Relationship(value={"AnyResourcePool/owner"})
    @Property(value="AnyComputeResource/@modelKey")
    protected ManagedObjectReference owner;
    @Relationship(value={"AnyResourcePool/owner"})
    @Property(value="AnyComputeResource/summary/totalMemory")
    protected Long ownerCapacity;

    public String getOwnerCapacity() {
        return Util.getBytesMemoryFormatted(this.ownerCapacity);
    }

    public boolean getParentCluster() {
        return this.owner.getType().equals(ClusterComputeResource.class.getSimpleName());
    }

    @Override
    protected Long getLimitValue() {
        return this.limit;
    }

    @Override
    protected Long getReservationValue() {
        return this.reservation;
    }

    @Override
    protected Integer getStaticEntitlementValue() {
        return this.staticEntitlement;
    }

    @Override
    protected Long getResourceSizeValue() {
        return Util.getLongValue(this.resourceSize);
    }

    @Override
    protected Long getConsummationValue() {
        return this.consummation;
    }

    @Override
    protected Long getOverallDemand() {
        return this.overheadMemory;
    }

    @Override
    protected SharesInfo getSharesInfoValue() {
        return this.sharesInfo;
    }

    @Override
    protected Integer getNumMemoryValue() {
        return 16384;
    }
}

