/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.services;

import com.vmware.cis.data.model.NestedQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vim.option.OptionValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.clusterui.model.configuration.HostNameData;
import com.vmware.vsphere.client.clusterui.model.services.ClusterBaseHaData;
import com.vmware.vsphere.client.clusterui.model.services.HeartbeatDatastoreCandidateData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

@QueryBinding(value="ClusterComputeResource")
public class ClusterEditHaData
extends ClusterBaseHaData {
    private static final int LEAST_NUMBER_OF_HOSTS = 2;
    @NestedQueryBinding
    @Relationship(value={"ClusterComputeResource/configurationEx/dasConfig/admissionControlPolicy/failoverHosts"})
    public HostNameData[] hostData;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/defaultVmSettings/vmToolsMonitoringSettings/failureInterval")
    public int vmToolsMonitorFailureInt;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/defaultVmSettings/vmToolsMonitoringSettings/maxFailureWindow")
    public int vmToolsMonitorMaxFailureWindow;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/defaultVmSettings/vmToolsMonitoringSettings/maxFailures")
    public int vmToolsMonitorMaxFailures;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/defaultVmSettings/vmToolsMonitoringSettings/minUpTime")
    public int vmToolsMonitorMinUpTime;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/heartbeatDatastore")
    public transient ManagedObjectReference[] preferredHeartbeatDatastores;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/admissionControlPolicy/autoComputePercentages")
    public boolean autoComputePercentages;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/admissionControlPolicy/resourceReductionToToleratePercent")
    public int resourceReductionToToleratePercent;
    @Property(value="ClusterComputeResource/configurationEx/orchestration/defaultVmReadiness/readyCondition")
    public String readyCondition;
    @Property(value="ClusterComputeResource/configurationEx/orchestration/defaultVmReadiness/postReadyDelay")
    public int postReadyDelay;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/defaultVmSettings/restartPriorityTimeout")
    public int restartPriorityTimeout;
    @Property(value="ClusterComputeResource/host/length")
    public int hostsInCluster;
    @Property(value="ClusterComputeResource/host")
    public transient ManagedObjectReference[] hosts;
    @NestedQueryBinding
    @Relationship(value={"ClusterComputeResource/datastore"})
    public transient HeartbeatDatastoreCandidateData[] datastores;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/option")
    public transient OptionValue[] options;
    @Property(value="ClusterComputeResource/pmemHaCapable")
    public boolean pmemHaCapable;
    @Property(value="ClusterComputeResource/pmemFailoverLevelPolicyResPct")
    public Integer pmemFailoverLevelPolicyResPct;

    public Collection<HeartbeatDatastoreCandidateData> getHeartbeatDatastoreCandidates() {
        HashMap<ManagedObjectReference, HeartbeatDatastoreCandidateData> heartbeatDatastores = new HashMap<ManagedObjectReference, HeartbeatDatastoreCandidateData>();
        if (!ArrayUtils.isEmpty((Object[])this.hosts) && !ArrayUtils.isEmpty((Object[])this.datastores)) {
            for (HeartbeatDatastoreCandidateData datastore : this.datastores) {
                List<ManagedObjectReference> accessibleAndMountedHostMounts;
                if (datastore.type == null || "vsan".equalsIgnoreCase(datastore.type) || "vsanD".equalsIgnoreCase(datastore.type) || (accessibleAndMountedHostMounts = datastore.getAccessibleAndMountedHostsForDatastore()).isEmpty()) continue;
                HeartbeatDatastoreCandidateData heartbeatDatastoreCandidate = (HeartbeatDatastoreCandidateData)((Object)heartbeatDatastores.get(datastore.provider));
                for (ManagedObjectReference host : this.hosts) {
                    if (!accessibleAndMountedHostMounts.contains(host)) continue;
                    if (heartbeatDatastoreCandidate == null) {
                        heartbeatDatastores.put((ManagedObjectReference)datastore.provider, datastore);
                        heartbeatDatastoreCandidate = datastore;
                    }
                    if (heartbeatDatastoreCandidate.accessibleAndMountedHosts == null) {
                        heartbeatDatastoreCandidate.accessibleAndMountedHosts = new ArrayList<ManagedObjectReference>();
                    }
                    heartbeatDatastoreCandidate.accessibleAndMountedHosts.add(host);
                }
                if (heartbeatDatastoreCandidate == null || heartbeatDatastoreCandidate.accessibleAndMountedHosts != null && heartbeatDatastoreCandidate.accessibleAndMountedHosts.size() >= 2) continue;
                heartbeatDatastores.remove(datastore.provider);
            }
            if (this.preferredHeartbeatDatastores != null) {
                HashSet<ManagedObjectReference> preferredHbDsRefs = new HashSet<ManagedObjectReference>(Arrays.asList(this.preferredHeartbeatDatastores));
                for (HeartbeatDatastoreCandidateData heartbeatDatastore : heartbeatDatastores.values()) {
                    heartbeatDatastore.isPreferred = preferredHbDsRefs.contains(heartbeatDatastore.provider);
                }
            }
        }
        return heartbeatDatastores.values();
    }

    public int getRequiredDatastoreMounts() {
        int result = 2;
        if (this.options != null) {
            for (OptionValue option : this.options) {
                if (!"das.heartbeatDsPerHost".equals(option.getKey())) continue;
                result = Integer.parseInt((String)option.getValue());
                break;
            }
        }
        return result;
    }
}

