/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.services;

import com.vmware.cis.data.model.NestedQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.clusterui.model.services.ClusterBaseHaData;
import com.vmware.vsphere.client.clusterui.model.services.HeartbeatDatastoreData;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

@QueryBinding(value="ClusterComputeResource")
public class ClusterHaData
extends ClusterBaseHaData {
    @NestedQueryBinding
    @Relationship(value={"ClusterComputeResource/configurationEx/dasConfig/heartbeatDatastore"})
    private transient HeartbeatDatastoreData[] hbDatastores;
    @Property(value="ClusterComputeResource/configurationEx/infraUpdateHaConfig.enabled")
    public boolean infraUpdateHaEnabled;
    @Property(value="ClusterComputeResource/configurationEx/drsConfig/enabled")
    public boolean drsEnabled;
    @Property(value="ClusterComputeResource/pmemHaCapable")
    public boolean pmemHaCapable;
    @Property(value="ClusterComputeResource/host")
    public transient ManagedObjectReference[] hosts;
    @Property(value="ClusterComputeResource/heartbeatDatastores")
    public HeartbeatDatastoreData[] heartbeatDatastores;

    public HeartbeatDatastoreData[] getPreferredHeartbeatDatastores() {
        ArrayList<HeartbeatDatastoreData> result = new ArrayList<HeartbeatDatastoreData>();
        if (!ArrayUtils.isEmpty((Object[])this.hosts) && !ArrayUtils.isEmpty((Object[])this.hbDatastores)) {
            for (HeartbeatDatastoreData hbDatastore : this.hbDatastores) {
                List<ManagedObjectReference> accessibleAndMountedHostMounts = hbDatastore.getAccessibleAndMountedHostsForDatastore();
                for (ManagedObjectReference host : this.hosts) {
                    if (!accessibleAndMountedHostMounts.contains(host)) continue;
                    if (hbDatastore.accessibleAndMountedHosts == null) {
                        hbDatastore.accessibleAndMountedHosts = new ArrayList<ManagedObjectReference>();
                    }
                    hbDatastore.accessibleAndMountedHosts.add(host);
                }
                result.add(hbDatastore);
            }
        }
        return result.toArray(new HeartbeatDatastoreData[0]);
    }
}

