/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.services;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.cis.data.model.NestedQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vim.cluster.DpmConfigInfo;
import com.vmware.vim.binding.vim.cluster.DrsConfigInfo;
import com.vmware.vim.binding.vim.option.OptionValue;
import com.vmware.vsphere.client.clusterui.model.configuration.HostMaxOvercommitmentData;
import com.vmware.vsphere.client.clusterui.util.DrsUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@QueryBinding(value="ClusterComputeResource")
public class DrsConfigData
extends IdentifiableQueryBinding {
    private static final Log _logger = LogFactory.getLog(DrsConfigData.class);
    public static final String VM_EVEN_DISTRIBUTION_OPTION = "TryBalanceVmsPerHost";
    public static final int VM_EVEN_DISTRIBUTION_OPTION_VALUE = 1;
    public static final String CONSUMED_MEMORY_OPTION = "PercentIdleMBInMemDemand";
    public static final String CPU_OVERCOMMITMENT_OPTION = "MaxVcpusPerCore";
    @NestedQueryBinding
    @Relationship(value={"ClusterComputeResource/host"})
    public transient HostMaxOvercommitmentData[] hostMaxOvercommitmentData;
    @Property(value="ClusterComputeResource/configurationEx/drsConfig/enabled")
    public boolean drsEnabled;
    @Property(value="ClusterComputeResource/configurationEx/drsConfig/defaultVmBehavior")
    public DrsConfigInfo.DrsBehavior defaultDrsBehavior;
    @Property(value="ClusterComputeResource/configurationEx/drsConfig/vmotionRate")
    public int migrationRate;
    @Property(value="ClusterComputeResource/configurationEx/drsConfig/enableVmBehaviorOverrides")
    public boolean vmAutomationEnabled;
    @Property(value="ClusterComputeResource/configurationEx/dpmConfigInfo/enabled")
    public Boolean dpmEnabled;
    @Property(value="ClusterComputeResource/configurationEx/dpmConfigInfo/defaultDpmBehavior")
    public DpmConfigInfo.DpmBehavior defaultDpmBehavior;
    @Property(value="ClusterComputeResource/configurationEx/dpmConfigInfo/hostPowerActionRate")
    public int dpmRate;
    @Property(value="ClusterComputeResource/configurationEx/drsConfig/option")
    public OptionValue[] advancedOptions;
    @Property(value="ClusterComputeResource/configurationEx/proactiveDrsConfig/enabled")
    public boolean proactiveDrsEnabled;
    @Property(value="ClusterComputeResource/scheduledTasksCount")
    public long scheduledTasksCount;
    @Property(value="ClusterComputeResource/drsMemoryMetricConfigurable")
    public Boolean drsMemoryMetricConfigurable;
    @Property(value="ClusterComputeResource/configurationEx/drsConfig/scaleDescendantsShares")
    public String clusterScaleDescendantsShares;

    public int getMigrationThreshold() {
        return DrsUtil.getDrsVMotionMigrationThreshold(this.migrationRate);
    }

    public Integer getMaxCpuOvercommitmentValue() {
        if (this.hostMaxOvercommitmentData != null && this.hostMaxOvercommitmentData.length > 0) {
            int maxValue = this.hostMaxOvercommitmentData[0].maxHostSupportedVcpus;
            for (int i = 1; i < this.hostMaxOvercommitmentData.length; ++i) {
                if (this.hostMaxOvercommitmentData[i].maxHostSupportedVcpus <= maxValue) continue;
                maxValue = this.hostMaxOvercommitmentData[i].maxHostSupportedVcpus;
            }
            return maxValue;
        }
        return null;
    }

    public int getCpuOverCommitmentPercent() {
        Object val = this.getOptionValue(CPU_OVERCOMMITMENT_OPTION);
        int result = 0;
        if (val != null) {
            try {
                result = Integer.valueOf((String)val);
            }
            catch (NumberFormatException e) {
                _logger.warn((Object)"MaxVcpusPerCore is not a number, returning 0.");
            }
        }
        return result;
    }

    public boolean getEvenDistributionEnabled() {
        Object val = this.getOptionValue(VM_EVEN_DISTRIBUTION_OPTION);
        try {
            Integer evenDistribution = Integer.valueOf((String)val);
            return evenDistribution == 1;
        }
        catch (NumberFormatException e) {
            _logger.warn((Object)"TryBalanceVmsPerHost is not a number.");
            return false;
        }
    }

    public boolean getAllConsumedMemoryMetricEnabled() {
        Object val = this.getOptionValue(CONSUMED_MEMORY_OPTION);
        try {
            Integer allConsumedMemoryMetric = Integer.valueOf((String)val);
            return allConsumedMemoryMetric > 0;
        }
        catch (NumberFormatException e) {
            _logger.warn((Object)"PercentIdleMBInMemDemand is not a number.");
            return false;
        }
    }

    public boolean getCpuOverCommitment() {
        Object val = this.getOptionValue(CPU_OVERCOMMITMENT_OPTION);
        try {
            Integer.valueOf((String)val);
            return true;
        }
        catch (NumberFormatException e) {
            _logger.warn((Object)"MaxVcpusPerCore is not a number.");
            return false;
        }
    }

    private Object getOptionValue(String key) {
        if (StringUtils.isEmpty((CharSequence)key) || ArrayUtils.isEmpty((Object[])this.advancedOptions)) {
            return null;
        }
        for (OptionValue pair : this.advancedOptions) {
            String optionKey = pair.key.trim();
            if (!optionKey.equals(key)) continue;
            return pair.value;
        }
        return null;
    }
}

