/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.util;

import com.vmware.vise.util.FormatUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class Util {
    public static final String CLUSTER_SERVICE = "clusterservice";

    public static String getLocalizedString(String key, String ... params) {
        String localizedString = ResourceUtil.getString((String)CLUSTER_SERVICE, (String)key, (String[])params, (ClassLoader)Util.class.getClassLoader());
        assert (!localizedString.equals(key)) : "Localization key `" + key + "` could not be found in resource bundle " + "clusterservice";
        return localizedString;
    }

    public static double getPercentageValue(long value, long total) {
        double percentage = 0.0;
        if (total != 0L) {
            percentage = (double)value / (double)total * 100.0;
        }
        return percentage;
    }

    public static String formatPercentageValue(double valueToFormat) {
        Locale locale = ResourceUtil.getLocale();
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
        DecimalFormat df = new DecimalFormat("#.##", symbols);
        return df.format(valueToFormat);
    }

    public static String getCpuFrequencyFormatted(Long value) {
        if (value == null) {
            return "";
        }
        return FormatUtil.getFrequencyFormatted((Number)value, (int)2, (long)1000000L, (long)-1L, (boolean)true);
    }

    public static String getMbMemoryFormatted(Long value) {
        if (value == null) {
            return "";
        }
        return FormatUtil.getStorageFormatted((Long)value, (long)0x100000L, (long)-1L);
    }

    public static long max(long ... args) {
        long res = args[0];
        for (int i = 1; i < args.length; ++i) {
            if (args[i] <= res) continue;
            res = args[i];
        }
        return res;
    }

    public static String getCpuFormatted(long value) {
        return FormatUtil.getFrequencyFormatted((Number)value, (int)2, (long)1000000L, (long)-1L, (boolean)true);
    }

    public static String getBytesMemoryFormatted(long value) {
        return FormatUtil.getStorageFormatted((Long)value, (long)1L, (long)-1L);
    }

    public static Long getLongValue(Integer value) {
        return value == null ? null : Long.valueOf(value.intValue());
    }
}

