/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.util;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.vim.binding.vim.Capability;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.clusterui.model.VcCapability;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class VcCapabilityUtil {
    private static final String SERVICE_INSTANCE_CAPABILITY_DS_PROPERTY = "capability";
    private static final String SERVICE_INSTANCE_CAPABILITY_VSAN_MAX_DS_PROPERTY = "capability.vsanMaxSupported";

    public static VcCapability getCapability(QueryService queryService, String serverGuid) {
        ManagedObjectReference serviceInstanceRef = new ManagedObjectReference(ServiceInstance.class.getSimpleName(), ServiceInstance.class.getSimpleName(), serverGuid);
        ResultSet resultSet = queryService.select(new String[]{SERVICE_INSTANCE_CAPABILITY_DS_PROPERTY, SERVICE_INSTANCE_CAPABILITY_VSAN_MAX_DS_PROPERTY}).from(new String[]{ServiceInstance.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)serviceInstanceRef).fetch();
        if (resultSet == null) {
            return null;
        }
        List resultItems = resultSet.getItems();
        if (CollectionUtils.isEmpty((Collection)resultItems)) {
            return null;
        }
        VcCapability vcCapability = new VcCapability();
        vcCapability.capability = (Capability)((ResourceItem)resultItems.get(0)).get(SERVICE_INSTANCE_CAPABILITY_DS_PROPERTY);
        vcCapability.vsanMaxSupported = (Boolean)((ResourceItem)resultItems.get(0)).get(SERVICE_INSTANCE_CAPABILITY_VSAN_MAX_DS_PROPERTY);
        return vcCapability;
    }
}

