/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.topn.metricid;

import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounter;
import com.vmware.opsmgmt.client.advperfcharts.topn.data.VmDevicesData;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.MetricIdData;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.MetricIdProvider;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.PredefinedInstanceNameTranslator;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vim.vm.device.VirtualController;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AnyStorageVmsMetricIdProvider
implements MetricIdProvider {
    public static final List<String> ANY_STORAGE_VMS_REPORTS = Arrays.asList("vmDiskReadLatencyReport", "vmDiskWriteLatencyReport", "vmDiskNumberReadReport", "vmDiskNumberWriteReport");

    public MetricIdData getMetricIdData(List<ManagedObjectReference> relevantDatastores, List<VmDevicesData> vms, List<PerformanceCounter> queriedCounters) {
        HashMap<ManagedObjectReference, String> objectNames = new HashMap<ManagedObjectReference, String>(vms.size());
        HashMap<ManagedObjectReference, Map<String, String>> diskNamesByObject = new HashMap<ManagedObjectReference, Map<String, String>>(vms.size());
        HashMap<ManagedObjectReference, List<PerformanceManager.MetricId>> queriedMetricIdsByObject = new HashMap<ManagedObjectReference, List<PerformanceManager.MetricId>>(vms.size());
        for (VmDevicesData vmData : vms) {
            HashMap<Integer, VirtualController> controllerDevices = new HashMap<Integer, VirtualController>();
            ArrayList<VirtualDevice> diskDevices = new ArrayList<VirtualDevice>();
            HashMap<String, String> vmDeviceNames = new HashMap<String, String>();
            for (VirtualDevice device : vmData.devices) {
                if (device instanceof VirtualController) {
                    controllerDevices.put(device.key, (VirtualController)device);
                    continue;
                }
                if (!(device.backing instanceof VirtualDevice.FileBackingInfo)) continue;
                VirtualDevice.FileBackingInfo fileBackingInfo = (VirtualDevice.FileBackingInfo)device.backing;
                if (!relevantDatastores.contains(fileBackingInfo.datastore)) continue;
                diskDevices.add(device);
            }
            for (VirtualDevice device : diskDevices) {
                String deviceString = this.getDeviceString(device, controllerDevices);
                String diskLabel = this.getDiskLabel(device);
                if (deviceString == null || diskLabel == null) continue;
                vmDeviceNames.put(deviceString, diskLabel);
            }
            diskNamesByObject.put((ManagedObjectReference)vmData.provider, vmDeviceNames);
            objectNames.put((ManagedObjectReference)vmData.provider, vmData.name);
        }
        for (ManagedObjectReference vm : diskNamesByObject.keySet()) {
            Set instances = ((Map)diskNamesByObject.get(vm)).keySet();
            ArrayList<PerformanceManager.MetricId> queriedMetricIds = new ArrayList<PerformanceManager.MetricId>(instances.size() * queriedCounters.size());
            for (String instance : instances) {
                for (PerformanceCounter counter : queriedCounters) {
                    PerformanceManager.MetricId metricId = new PerformanceManager.MetricId();
                    metricId.counterId = counter.id;
                    metricId.instance = instance;
                    queriedMetricIds.add(metricId);
                }
            }
            queriedMetricIdsByObject.put(vm, queriedMetricIds);
        }
        MetricIdData result = new MetricIdData();
        result.queriedMetricIds = queriedMetricIdsByObject;
        result.nameTranslator = new PredefinedInstanceNameTranslator(this.getInstanceNames(objectNames, diskNamesByObject));
        return result;
    }

    private Map<ManagedObjectReference, Map<String, String>> getInstanceNames(Map<ManagedObjectReference, String> vmNames, Map<ManagedObjectReference, Map<String, String>> instanceNamesByObject) {
        HashMap<ManagedObjectReference, Map<String, String>> result = new HashMap<ManagedObjectReference, Map<String, String>>(instanceNamesByObject.size());
        for (ManagedObjectReference vm : instanceNamesByObject.keySet()) {
            Set<String> instances = instanceNamesByObject.get(vm).keySet();
            HashMap<String, String> instanceNames = new HashMap<String, String>(instances.size());
            for (String instance : instances) {
                String instanceName;
                if (instances.size() > 1) {
                    String diskName = instanceNamesByObject.get(vm).get(instance);
                    instanceName = ResourceUtil.getString((String)"AdvPerfCharts", (String)"topNChart.storagePodVirtualMachines.instance.format", (String[])new String[]{vmNames.get(vm), diskName}, (ClassLoader)AnyStorageVmsMetricIdProvider.class.getClassLoader());
                } else {
                    instanceName = vmNames.get(vm);
                }
                instanceNames.put(instance, instanceName);
            }
            result.put(vm, instanceNames);
        }
        return result;
    }

    private String getDeviceString(VirtualDevice disk, Map<Integer, VirtualController> controllerDevices) {
        if (disk.unitNumber == null || disk.controllerKey == null) {
            return null;
        }
        VirtualController controller = controllerDevices.get(disk.controllerKey);
        if (controller.deviceInfo == null) {
            return null;
        }
        return this.formatDeviceString(controller.deviceInfo.label, controller.busNumber, disk.unitNumber);
    }

    private String formatDeviceString(String deviceLabel, Integer busNumber, Integer nodeNumber) {
        String deviceTypePrefix = deviceLabel.split("\\s")[0].toLowerCase();
        return String.format("%s%s:%s", deviceTypePrefix, busNumber, nodeNumber);
    }

    private String getDiskLabel(VirtualDevice virtualDisk) {
        if (virtualDisk.deviceInfo == null) {
            return null;
        }
        return virtualDisk.deviceInfo.label;
    }
}

