/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.topn.metricid;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounter;
import com.vmware.opsmgmt.client.advperfcharts.topn.data.StoragePodSiocData;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.MetricIdData;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.SiocMetricIdProvider;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StoragePodSiocMetricIdProvider
extends SiocMetricIdProvider {
    private static final Log _logger = LogFactory.getLog(StoragePodSiocMetricIdProvider.class);
    public static final List<String> STORAGEPOD_SIOC_REPORTS = Arrays.asList("storagePodOverallLatencyReport", "storagePodOveralIOPSReport", "storagePodSIOCActivityReport", "storagePodVMObservedLatencyReport");
    private final QueryBindingService _queryBindingService;

    public StoragePodSiocMetricIdProvider(QueryBindingService queryBindingService) {
        this._queryBindingService = queryBindingService;
    }

    @Override
    public MetricIdData getMetricIdData(ManagedObjectReference object, List<PerformanceCounter> queriedCounters) {
        StoragePodSiocData storagePodData = (StoragePodSiocData)this._queryBindingService.prepare(StoragePodSiocData.class).fetch((Object)object);
        if (ArrayUtils.isEmpty((Object[])storagePodData.datastores)) {
            _logger.error((Object)("No datastores in StoragePod " + object));
            MetricIdData result = new MetricIdData();
            result.queriedMetricIds = Collections.emptyMap();
            return result;
        }
        return this.getMetricIdData(storagePodData.datastores, queriedCounters);
    }
}

