/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.topn.metricid;

import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounter;
import com.vmware.opsmgmt.client.advperfcharts.topn.metricid.InstanceNameTranslator;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.util.List;

public class VmFtInstanceNameTranslator
implements InstanceNameTranslator {
    private final ManagedObjectReference _primary;
    private final List<PerformanceCounter> _queriedCounters;

    public VmFtInstanceNameTranslator(ManagedObjectReference primary, List<PerformanceCounter> queriedCounters) {
        this._primary = primary;
        this._queriedCounters = queriedCounters;
    }

    @Override
    public String getInstanceName(ManagedObjectReference object, PerformanceManager.MetricId metricId) {
        if (!metricId.instance.equals("") && this.isCpuCounter(metricId.counterId)) {
            if (object.equals((Object)this._primary)) {
                return this.getString("report.legend.title.faultTolerance.cpu.primary", metricId.instance);
            }
            return this.getString("report.legend.title.faultTolerance.cpu.secondary", metricId.instance);
        }
        if (object.equals((Object)this._primary)) {
            return this.getString("report.legend.title.faultTolerance.primary");
        }
        return this.getString("report.legend.title.faultTolerance.secondary");
    }

    private boolean isCpuCounter(int counterId) {
        for (PerformanceCounter counter : this._queriedCounters) {
            if (counter.id != counterId) continue;
            return "cpu".equals(counter.groupId);
        }
        return false;
    }

    private String getString(String key, String parameter) {
        return ResourceUtil.getString((String)"AdvPerfCharts", (String)key, (String[])new String[]{parameter}, (ClassLoader)VmFtInstanceNameTranslator.class.getClassLoader());
    }

    private String getString(String key) {
        return ResourceUtil.getString((String)"AdvPerfCharts", (String)key, (ClassLoader)VmFtInstanceNameTranslator.class.getClassLoader());
    }
}

