/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.util;

import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounter;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceMetricTimeIntervals;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceCounterProvider;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;

public class PerObjectPerformanceCounterProvider
implements PerformanceCounterProvider {
    private List<PerformanceCounter> _availableCounterList;

    public PerObjectPerformanceCounterProvider(List<PerformanceCounter> cachedCounters) {
        Validate.notNull(cachedCounters);
        this._availableCounterList = cachedCounters;
    }

    @Override
    public List<PerformanceManager.MetricId> getAvailableMetricIds(ManagedObjectReference entity, List<Integer> counterIds, List<String> relatedDeviceIds, PerformanceMetricTimeIntervals interval) {
        ArrayList<PerformanceManager.MetricId> requiredMetrics = new ArrayList<PerformanceManager.MetricId>();
        if (counterIds == null || relatedDeviceIds == null) {
            return requiredMetrics;
        }
        PerformanceMetricTimeIntervals cmpInterval = this.isHistorical(interval) ? PerformanceMetricTimeIntervals.HISTORICAL_STATS : interval;
        for (PerformanceCounter counter : this._availableCounterList) {
            boolean isDeviceIncluded;
            boolean isConterIntervalEquals = cmpInterval == counter.interval;
            boolean isCounterIncluded = counterIds.contains(counter.id);
            boolean bl = isDeviceIncluded = relatedDeviceIds.contains(counter.relatedDeviceId) || "*".equals(relatedDeviceIds.get(0));
            if (!isCounterIncluded || !isConterIntervalEquals || !isDeviceIncluded || this.containsMetricId(counter.metricId, requiredMetrics)) continue;
            requiredMetrics.add(counter.metricId);
        }
        return requiredMetrics;
    }

    @Override
    public PerformanceCounter findCounterInfo(ManagedObjectReference entity, PerformanceManager.MetricId metricId) {
        for (PerformanceCounter counter : this._availableCounterList) {
            if (counter.id != metricId.getCounterId() || !counter.relatedDeviceId.equals(metricId.getInstance())) continue;
            return counter;
        }
        return null;
    }

    private boolean containsMetricId(PerformanceManager.MetricId metricId, List<PerformanceManager.MetricId> metricIds) {
        for (PerformanceManager.MetricId singleMetric : metricIds) {
            boolean sameCounter;
            boolean sameInstance = singleMetric.instance.equals(metricId.instance);
            boolean bl = sameCounter = singleMetric.counterId == metricId.counterId;
            if (!sameInstance || !sameCounter) continue;
            return true;
        }
        return false;
    }

    private boolean isHistorical(PerformanceMetricTimeIntervals interval) {
        return PerformanceMetricTimeIntervals.CUSTOM.equals((Object)interval) || PerformanceMetricTimeIntervals.LAST_DAY.equals((Object)interval) || PerformanceMetricTimeIntervals.LAST_WEEK.equals((Object)interval) || PerformanceMetricTimeIntervals.LAST_MONTH.equals((Object)interval) || PerformanceMetricTimeIntervals.LAST_YEAR.equals((Object)interval) || PerformanceMetricTimeIntervals.RAW_DATA_FEED.equals((Object)interval);
    }
}

