/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.util;

import com.vmware.vim.binding.vim.ElementDescription;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerformanceCounterCache {
    private static final Log _logger = LogFactory.getLog(PerformanceCounterCache.class);
    private static final String CACHE_COUNTERS_SETTING = "cachePerformanceCounters";
    private final ConcurrentMap<String, ConcurrentMap<Integer, PerformanceManager.CounterInfo>> _cache;
    private final boolean _useCache;

    public PerformanceCounterCache(ConfigurationService configurationService) {
        this._useCache = PropertyUtil.getBooleanProperty((ConfigurationService)configurationService, (String)CACHE_COUNTERS_SETTING, (boolean)true);
        this._cache = this._useCache ? new ConcurrentHashMap<String, ConcurrentMap<Integer, PerformanceManager.CounterInfo>>() : null;
    }

    public Map<Integer, PerformanceManager.CounterInfo> getCounterInfoMapForMetrics(PerformanceManager.MetricId[] realtimeMetrics, PerformanceManager.MetricId[] historicalMetrics, PerformanceManager perfManager) {
        HashMap<Integer, PerformanceManager.CounterInfo> result;
        if (this._useCache) {
            result = new HashMap();
            ConcurrentMap<Integer, PerformanceManager.CounterInfo> cache = this.cacheForServer(perfManager);
            if (cache != null) {
                HashSet<Integer> missingKeys = new HashSet<Integer>();
                PerformanceCounterCache.fetchCountersForMetricIds(realtimeMetrics, cache, result, missingKeys);
                PerformanceCounterCache.fetchCountersForMetricIds(historicalMetrics, cache, result, missingKeys);
                PerformanceCounterCache.fillMissingCounterInfos(perfManager, missingKeys, cache, result);
                PerformanceCounterCache.localizeResultMap(result);
            }
        } else {
            result = this.fetchCounterInfos(realtimeMetrics, historicalMetrics, perfManager);
        }
        return result;
    }

    public PerformanceManager.CounterInfo getCounterById(PerformanceManager perfManager, int id) {
        PerformanceManager.CounterInfo result;
        if (this._useCache) {
            ConcurrentMap<Integer, PerformanceManager.CounterInfo> cache = this.cacheForServer(perfManager);
            if (cache != null) {
                result = (PerformanceManager.CounterInfo)cache.get(id);
                if (result == null) {
                    HashMap<Integer, PerformanceManager.CounterInfo> resultMap = new HashMap<Integer, PerformanceManager.CounterInfo>(1);
                    PerformanceCounterCache.fillMissingCounterInfos(perfManager, Collections.singleton(id), cache, resultMap);
                    result = (PerformanceManager.CounterInfo)resultMap.get(id);
                }
                if (result != null) {
                    result = PerformanceCounterCache.localizeCachedCounterInfo(result);
                }
            } else {
                result = null;
            }
        } else {
            PerformanceManager.CounterInfo[] counterInfos = perfManager.queryCounter(new int[]{id});
            if (counterInfos != null) {
                result = counterInfos[0];
            } else {
                _logger.warn((Object)("Could not find counter with id: " + id));
                result = null;
            }
        }
        return result;
    }

    public Collection<PerformanceManager.CounterInfo> getCountersForServer(PerformanceManager perfManager) {
        if (this._useCache) {
            ConcurrentMap<Integer, PerformanceManager.CounterInfo> cache = this.cacheForServer(perfManager);
            Collection nonLocalizedResult = cache.values();
            ArrayList<PerformanceManager.CounterInfo> result = new ArrayList<PerformanceManager.CounterInfo>(nonLocalizedResult.size());
            for (PerformanceManager.CounterInfo ci : nonLocalizedResult) {
                result.add(PerformanceCounterCache.localizeCachedCounterInfo(ci));
            }
            return result;
        }
        PerformanceManager.CounterInfo[] result = perfManager.getPerfCounter();
        return result == null ? Collections.emptyList() : Arrays.asList(result);
    }

    private ConcurrentMap<Integer, PerformanceManager.CounterInfo> cacheForServer(PerformanceManager perfManager) {
        String serverGuid = perfManager._getRef().getServerGuid();
        ConcurrentMap result = (ConcurrentMap)this._cache.get(serverGuid);
        if (result == null) {
            PerformanceManager.CounterInfo[] counterInfos = perfManager.getPerfCounter();
            if (counterInfos != null) {
                ConcurrentHashMap<Integer, PerformanceManager.CounterInfo> countersForServer = new ConcurrentHashMap<Integer, PerformanceManager.CounterInfo>(counterInfos.length);
                for (PerformanceManager.CounterInfo ci : counterInfos) {
                    countersForServer.putIfAbsent(ci.key, PerformanceCounterCache.prepareCounterInfoForCache(ci));
                }
                this._cache.putIfAbsent(serverGuid, countersForServer);
                result = (ConcurrentMap)this._cache.get(serverGuid);
            } else {
                _logger.warn((Object)("PerfManager returned zero counters for server " + serverGuid));
            }
        }
        return result;
    }

    private Map<Integer, PerformanceManager.CounterInfo> fetchCounterInfos(PerformanceManager.MetricId[] realtime, PerformanceManager.MetricId[] historical, PerformanceManager perfManager) {
        assert (realtime != null && historical != null && realtime.length + historical.length > 0);
        HashMap<Integer, PerformanceManager.CounterInfo> counterInfosById = new HashMap<Integer, PerformanceManager.CounterInfo>();
        for (PerformanceManager.MetricId mid : realtime) {
            counterInfosById.put(mid.counterId, null);
        }
        for (PerformanceManager.MetricId mid : historical) {
            counterInfosById.put(mid.counterId, null);
        }
        int[] counterIds = new int[counterInfosById.size()];
        int i = 0;
        for (Integer counterIdBoxed : counterInfosById.keySet()) {
            counterIds[i++] = counterIdBoxed;
        }
        PerformanceManager.CounterInfo[] counterInfos = perfManager.queryCounter(counterIds);
        if (counterInfos.length != counterIds.length) {
            _logger.warn((Object)String.format("Requested information for %d counters, but received %d results.", counterIds.length, counterInfos.length));
        }
        for (PerformanceManager.CounterInfo ci : counterInfos) {
            counterInfosById.put(ci.key, ci);
        }
        return counterInfosById;
    }

    private static void fetchCountersForMetricIds(PerformanceManager.MetricId[] metricIds, ConcurrentMap<Integer, PerformanceManager.CounterInfo> cache, Map<Integer, PerformanceManager.CounterInfo> result, Set<Integer> missing) {
        if (metricIds == null) {
            return;
        }
        for (PerformanceManager.MetricId mid : metricIds) {
            int counterId = mid.counterId;
            if (result.containsKey(counterId)) continue;
            PerformanceManager.CounterInfo info = (PerformanceManager.CounterInfo)cache.get(counterId);
            if (info != null) {
                result.put(info.key, info);
                continue;
            }
            missing.add(counterId);
        }
    }

    private static void fillMissingCounterInfos(PerformanceManager perfManager, Set<Integer> missing, ConcurrentMap<Integer, PerformanceManager.CounterInfo> cache, Map<Integer, PerformanceManager.CounterInfo> result) {
        if (!missing.isEmpty()) {
            int[] missingKeysArr = new int[missing.size()];
            int i = 0;
            for (Integer k : missing) {
                missingKeysArr[i++] = k;
            }
            PerformanceManager.CounterInfo[] missingInfos = perfManager.queryCounter(missingKeysArr);
            if (missingInfos == null || missingInfos.length != missingKeysArr.length) {
                _logger.warn((Object)("Could not get all missing counter IDs! Missing keys: " + Arrays.toString(missingKeysArr)));
                if (missingInfos == null) {
                    return;
                }
            }
            for (PerformanceManager.CounterInfo ci : missingInfos) {
                PerformanceManager.CounterInfo internedCounter = PerformanceCounterCache.prepareCounterInfoForCache(ci);
                cache.put(ci.key, internedCounter);
                result.put(ci.key, internedCounter);
            }
        }
    }

    private static PerformanceManager.CounterInfo prepareCounterInfoForCache(PerformanceManager.CounterInfo original) {
        original.nameInfo = PerformanceCounterCache.prepareElementForCache(original.nameInfo);
        original.unitInfo = PerformanceCounterCache.prepareElementForCache(original.unitInfo);
        original.groupInfo = PerformanceCounterCache.prepareElementForCache(original.groupInfo);
        return original;
    }

    private static ElementDescription prepareElementForCache(ElementDescription e) {
        if (e != null) {
            e.label = null;
            e.key = e.key == null ? null : e.key.intern();
            e.summary = null;
        }
        return e;
    }

    private static void localizeResultMap(Map<?, PerformanceManager.CounterInfo> map) {
        for (Map.Entry<?, PerformanceManager.CounterInfo> entry : map.entrySet()) {
            PerformanceManager.CounterInfo unlocalized = entry.getValue();
            PerformanceManager.CounterInfo localized = PerformanceCounterCache.localizeCachedCounterInfo(unlocalized);
            entry.setValue(localized);
        }
    }

    private static PerformanceManager.CounterInfo localizeCachedCounterInfo(PerformanceManager.CounterInfo ci) {
        PerformanceManager.CounterInfo result = new PerformanceManager.CounterInfo();
        result.key = ci.key;
        result.associatedCounterId = ci.associatedCounterId;
        result.level = ci.level;
        result.perDeviceLevel = ci.perDeviceLevel;
        result.rollupType = ci.rollupType;
        result.statsType = ci.statsType;
        result.groupInfo = PerformanceCounterCache.localizeCachedElementDescription(ci.groupInfo, LocalizedElementType.GROUP);
        result.nameInfo = PerformanceCounterCache.localizedCounterDescription(ci.nameInfo, ci.groupInfo);
        result.unitInfo = PerformanceCounterCache.localizeCachedElementDescription(ci.unitInfo, LocalizedElementType.UNIT);
        return result;
    }

    private static ElementDescription localizedCounterDescription(ElementDescription nameInfo, ElementDescription groupInfo) {
        ElementDescription result = new ElementDescription();
        result.key = nameInfo.key;
        result.label = LocalizationUtil.getLocalizedMessage((String)(LocalizedElementType.COUNTER.localizationKeyPrefix + groupInfo.key + "." + nameInfo.key + ".label"));
        result.summary = LocalizationUtil.getLocalizedMessage((String)(LocalizedElementType.COUNTER.localizationKeyPrefix + groupInfo.key + "." + nameInfo.key + ".summary"));
        return result;
    }

    private static ElementDescription localizeCachedElementDescription(ElementDescription ed, LocalizedElementType type2) {
        assert (ed.label == null && ed.summary == null);
        ElementDescription result = new ElementDescription();
        result.key = ed.key;
        result.label = LocalizationUtil.getLocalizedMessage((String)(type2.localizationKeyPrefix + result.key + ".label"));
        result.summary = LocalizationUtil.getLocalizedMessage((String)(type2.localizationKeyPrefix + result.key + ".summary"));
        return result;
    }

    private static enum LocalizedElementType {
        COUNTER("counter."),
        GROUP("group."),
        UNIT("unit.");

        final String localizationKeyPrefix;

        private LocalizedElementType(String localizationKeyPrefix) {
            this.localizationKeyPrefix = localizationKeyPrefix;
        }
    }
}

