/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.devsetup.registration;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.vmware.devsetup.registration.PrefixOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class DevServerRegistrator {
    private static final String CFG_ZIP_FILE = "ui-cfg.zip";
    private static final String TMP_DIR = System.getProperty("java.io.tmpdir");
    private final String _host;
    private final int _port;
    private final String _rootPassword;
    private final File _vmwareCfgFolder;
    private final boolean _verbose;

    public DevServerRegistrator(String host, int port, String rootPassword, String vmwareCfgFolder, boolean verboseOutput) {
        Objects.requireNonNull(host);
        Objects.requireNonNull(rootPassword);
        Objects.requireNonNull(vmwareCfgFolder);
        this._host = host;
        this._port = port;
        this._rootPassword = rootPassword;
        this._vmwareCfgFolder = new File(vmwareCfgFolder);
        this._verbose = verboseOutput;
    }

    public void run() {
        JSch jsch = new JSch();
        try {
            Session session = jsch.getSession("root", this._host, this._port);
            session.setPassword(this._rootPassword);
            session.setConfig("StrictHostKeyChecking", "no");
            try {
                session.connect();
                this.generateConfigZip(session);
                this.downloadConfigZip(session);
                this.cleanupConfigFolder();
                this.unzipConfig();
                this.editTomcatConfig();
            }
            finally {
                session.disconnect();
            }
        }
        catch (JSchException | SftpException | IOException | URISyntaxException ex) {
            throw new IllegalStateException("Error communicating with vCenter Server.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void generateConfigZip(Session session) throws JSchException, IOException, URISyntaxException {
        ChannelExec channelExec = null;
        channelExec = (ChannelExec)session.openChannel("exec");
        channelExec.setCommand(this.prepareRemoteScript());
        channelExec.setInputStream(null);
        channelExec.setOutputStream(new PrefixOutputStream(System.out, "ssh out: "));
        channelExec.setErrStream(new PrefixOutputStream(System.err, "ssh err: "));
        channelExec.connect();
        while (true) {
            if (channelExec.isClosed()) {
                int exitStatus = channelExec.getExitStatus();
                if (exitStatus == 0) return;
                throw new IllegalStateException("SSH command completed with exit status " + exitStatus + ". Could not register the development server with vCenter Server " + this._host + ".");
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ee) {
                if (channelExec == null) return;
                channelExec.disconnect();
                return;
            }
        }
        finally {
            if (channelExec != null) {
                channelExec.disconnect();
            }
        }
    }

    private byte[] prepareRemoteScript() throws IOException, URISyntaxException {
        byte[] envVarCommand = ("export KEYSTORE='" + new File(this._vmwareCfgFolder, "store.jks").toString().replace("\\", "\\\\") + "'; ").getBytes();
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("dev-setup.sh");
        ByteArrayOutputStream out = new ByteArrayOutputStream(envVarCommand.length + in.available());
        out.write(envVarCommand);
        IOUtils.copy(in, (OutputStream)out);
        return out.toByteArray();
    }

    private void downloadConfigZip(Session session) throws JSchException, IOException, SftpException {
        ChannelSftp downloadChannel = null;
        try {
            downloadChannel = (ChannelSftp)session.openChannel("sftp");
            downloadChannel.connect();
            this.downloadFile(downloadChannel, TMP_DIR, CFG_ZIP_FILE);
        }
        finally {
            if (downloadChannel != null) {
                downloadChannel.disconnect();
            }
        }
    }

    private void downloadFile(ChannelSftp downloadChannel, String destDir, String filename) {
        this.verbose("Downloading ~/" + filename + " to " + destDir + " ...");
        new File(destDir).mkdirs();
        try (FileOutputStream fos = new FileOutputStream(new File(destDir, filename));){
            downloadChannel.get(filename, fos);
            fos.flush();
        }
        catch (SftpException | IOException ex) {
            throw new IllegalStateException("Problem downloading ~/" + filename + ".", ex);
        }
        this.verbose("Downloaded ~/" + filename + " to " + destDir + ".");
    }

    private void cleanupConfigFolder() {
        try {
            if (this._vmwareCfgFolder.exists()) {
                this.verbose("Cleaning up " + this._vmwareCfgFolder + " ...");
                FileUtils.cleanDirectory(this._vmwareCfgFolder);
                this.verbose("Cleaned up " + this._vmwareCfgFolder + ".");
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to clean up " + this._vmwareCfgFolder + ".", ex);
        }
    }

    private void unzipConfig() {
        File zipFile = Paths.get(TMP_DIR, CFG_ZIP_FILE).toFile();
        try {
            this.verbose("Unzipping " + zipFile + " in " + this._vmwareCfgFolder + " ...");
            DevServerRegistrator.unzip(zipFile, this._vmwareCfgFolder);
            this.verbose("Unzipped " + zipFile + " in " + this._vmwareCfgFolder + ".");
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not unzip " + zipFile + " to " + this._vmwareCfgFolder + ".", ex);
        }
    }

    private static void unzip(File file, File destDir) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File entryDestination = new File(destDir, entry.getName());
                if (entry.isDirectory()) {
                    entryDestination.mkdirs();
                    continue;
                }
                entryDestination.getParentFile().mkdirs();
                InputStream in = zipFile.getInputStream(entry);
                try (FileOutputStream out = new FileOutputStream(entryDestination);){
                    IOUtils.copy(in, (OutputStream)out);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
    }

    private void editTomcatConfig() {
        Path tomcatConfigPath = DevServerRegistrator.tomcatServerPath();
        if (tomcatConfigPath == null) {
            System.err.println("Tomcat configuration will not be updated.");
            return;
        }
        try {
            this.verbose("Updating Tomcat configuration " + tomcatConfigPath + "...");
            String content = new String(Files.readAllBytes(tomcatConfigPath), StandardCharsets.UTF_8);
            String[] contentParts = content.split("port=\"\\$\\{https\\.port}\"");
            String changedLastPart = contentParts[contentParts.length - 1].replaceFirst("compression=\"on\"", "compression=\"off\"");
            String replacement = Matcher.quoteReplacement("certificateKeystoreFile=\"" + new File(this._vmwareCfgFolder, "store.jks").toString().replace("\\", "\\\\") + "\"");
            String resultContent = content.replace(contentParts[contentParts.length - 1], changedLastPart).replaceFirst("certificateKeystoreFile=\".*store[.]jks\"", replacement);
            Files.write(tomcatConfigPath, resultContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            this.verbose("Updated Tomcat configuration " + tomcatConfigPath + ".");
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not update Tomcat configuration " + tomcatConfigPath + ".", ex);
        }
    }

    private static Path tomcatServerPath() {
        String h5ClientPath = System.getenv("H5_CLIENT");
        if (h5ClientPath != null) {
            return Paths.get(h5ClientPath, "server/conf/server.xml");
        }
        String sdkHomeDir = System.getenv("VSPHERE_SDK_HOME");
        if (sdkHomeDir != null) {
            return Paths.get(sdkHomeDir, "vsphere-ui/server/conf/server.xml");
        }
        System.err.print("WARNING: VSPHERE_SDK_HOME environment variable not set. ");
        return null;
    }

    private void verbose(String message) {
        if (this._verbose) {
            System.out.println(message);
        }
    }
}

