/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.devsetup.registration;

import com.vmware.devsetup.registration.DevServerRegistrator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ServerRegistration {
    private static boolean _verbose = false;

    public static void main(String[] args) {
        Options options = ServerRegistration.createOptions();
        String user = "root";
        String password = null;
        String host = null;
        int port = 22;
        CommandLine commandLine = null;
        DefaultParser parser = new DefaultParser();
        try {
            block6: {
                commandLine = parser.parse(options, args, true);
                _verbose = commandLine.hasOption("v");
                password = commandLine.getOptionValue("pw");
                host = commandLine.getOptionValue("vcip");
                try {
                    String portStr = commandLine.getOptionValue("p");
                    port = portStr != null ? Integer.parseInt(portStr) : 22;
                }
                catch (NumberFormatException e) {
                    if (!_verbose) break block6;
                    e.printStackTrace();
                }
            }
            String vmwareCfgFolder = System.getenv("VMWARE_CFG_DIR");
            if (vmwareCfgFolder == null) {
                System.err.println("VMWARE_CFG_DIR environment variable not set.");
                System.exit(-1);
            }
            if (_verbose) {
                System.out.println("VMWARE_CFG_DIR set to " + vmwareCfgFolder);
                System.out.println();
            }
            new DevServerRegistrator(host, port, password, vmwareCfgFolder, _verbose).run();
        }
        catch (ParseException e) {
            ServerRegistration.printHelp(options, e.getMessage());
        }
    }

    private static Options createOptions() {
        Options options = new Options();
        options.addOption(Option.builder("vcip").longOpt("vCenterIP").hasArg().argName("vc server ip").desc("vCenter server IP address").required().build());
        options.addOption(Option.builder("pw").longOpt("password").hasArg().argName("SSH Password").desc("vCenter server ssh password").required().build());
        options.addOption(Option.builder("p").longOpt("port").hasArg().argName("vc server ssh port").desc("vCenter server ssh port, by default 22").required(false).build());
        options.addOption(Option.builder("v").longOpt("verbose").argName("verbose error message").desc("Print stack trace in case of an exception").required(false).build());
        return options;
    }

    private static void printHelp(Options options, String footer) {
        new HelpFormatter().printHelp("server-registration", "Register client to vCenter server", options, "\n" + footer, true);
    }
}

