/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storage.impl;

import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.SessionManager;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.StorageResourceManager;
import com.vmware.vim.binding.vim.VimVasaProviderInfo;
import com.vmware.vim.binding.vim.host.DatastoreSystem;
import com.vmware.vim.binding.vim.host.DiskPartitionInfo;
import com.vmware.vim.binding.vim.host.MultipathInfo;
import com.vmware.vim.binding.vim.host.MultipathStateInfo;
import com.vmware.vim.binding.vim.host.PlugStoreTopology;
import com.vmware.vim.binding.vim.host.ScsiDisk;
import com.vmware.vim.binding.vim.host.ScsiLun;
import com.vmware.vim.binding.vim.host.StorageDeviceInfo;
import com.vmware.vim.binding.vim.host.StorageSystem;
import com.vmware.vim.binding.vim.host.UnresolvedVmfsExtent;
import com.vmware.vim.binding.vim.host.UnresolvedVmfsVolume;
import com.vmware.vim.binding.vim.host.VmfsDatastoreExpandSpec;
import com.vmware.vim.binding.vim.host.VmfsDatastoreInfo;
import com.vmware.vim.binding.vim.host.VmfsDatastoreOption;
import com.vmware.vim.binding.vim.host.VvolDatastoreInfo;
import com.vmware.vim.binding.vim.host.VvolVolume;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualDisk;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.Version;
import com.vmware.vise.util.client.configuration.ClientCapabilitiesService;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import com.vmware.vsphere.client.common.util.ObjectNamesRetriever;
import com.vmware.vsphere.client.storage.DatastoreCreateOptionsQuerySpec;
import com.vmware.vsphere.client.storage.DatastoreFilePathsSpec;
import com.vmware.vsphere.client.storage.DatastoreFilePathsSpecEx;
import com.vmware.vsphere.client.storage.DatastoreIncreaseOptionsQuerySpec;
import com.vmware.vsphere.client.storage.DeviceMultipathingInfo;
import com.vmware.vsphere.client.storage.FileTransferEndpoint;
import com.vmware.vsphere.client.storage.ScsiDiskInfo;
import com.vmware.vsphere.client.storage.StorageDataService;
import com.vmware.vsphere.client.storage.VmfsExtentInfo;
import com.vmware.vsphere.client.storage.adapters.StoragePathData;
import com.vmware.vsphere.client.storage.i18n.I18nUtil;
import com.vmware.vsphere.client.storage.util.HostStoragePropertyCache;
import com.vmware.vsphere.client.storage.util.StorageUtil;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;
import sun.net.util.IPAddressUtil;

public class DatastorePropertyProvider
implements PropertyProviderBean {
    private static final String NAME = "name";
    private static final String PARENT = "parent";
    private static final String DS_INFO_PROPERTY = "info";
    private static final String HOST_CONNECTION_STATE_PROPERTY = "runtime.connectionState";
    private static final String HOST_NAME_PROPERTY = "name";
    private static final String HOST_VERSION_PROPERTY = "config.product.version";
    private static final String HOST_MOUNT_PROPERTY = "hostMount";
    private static final String HOST_DATASTORE_SYSTEM_PROPERTY = "datastoreSystem";
    private static final String HOST_STORAGE_SYSTEM_PROPERTY = "storageSystem";
    private static final String STORAGE_POD_RELATIONSHIP = "parentPod";
    private static final String SDRS_ENABLED_PROPERTY = "podStorageDrsEntry.storageDrsConfig.podConfig.enabled";
    private static final String DATASTORE_VMS_COUNT = "vm._length";
    private static final String DATACENTER = "datacenterId";
    private static final String DATASTORE_PATH = "datastorePath";
    private static final String IS_STREAM_FORMAT = "isStreamFormat";
    private static final String DC_PATH_PARAM = "dcPath";
    private static final String DS_NAME_PARAM = "dsName";
    private static final String DISK_FORMAT_PARAM = "diskFormat";
    private static final String DISK_FORMAT_STEAM = "StreamVmdk";
    private static final String FOLDER_ENDPOINT = "/folder/";
    private static final String ENCODING_FORMAT_PARAM = "enc";
    private static final String SINGLE_ENCODING_VALUE = "std";
    private static final String ALWAYS_TRANSFER_THROUGH_VC_CONFIGURATION = "filesbrowser.alwaysDownloadUploadFromVc";
    private static final List<String> ESX_DATACENTER_NAME = new ArrayList<String>();
    private static final HashSet<String> pathEncodedChars = new HashSet<String>(Arrays.asList("+"));
    private static final String UTF_8 = "UTF-8";
    private static final String PATH_PART_GROUP_NAME = "pathPart";
    private static final String ESX_ENDPOINT_PROTOCOL = "https://";
    private static final Version VERSION_65;
    private static final Version VERSION_66;
    private static final String PATH_SEPARATOR_ENCODED = "%2f";
    private static final String PATH_SEPARATOR = "/";
    private static final String IPV6_HOSTNAME_FORMAT = "[%s]";
    private static final String HOST_CONFIG_SYSTEM_MANAGEMENT_PRIV = "Host.Config.SystemManagement";
    private static final Pattern DATASTORE_PATH_PATTERN;
    private static final String FILE_PATH_GROUP = "filePath";
    private static final String DEFAULT_DATASTORE_NAME;
    private static final String DATASTORE_TYPE;
    private static final Log _logger;
    private LegacyAuthorizationService _authorizationService;
    private DataService _dataService;
    private StorageDataService _storageDataService;
    private ConfigurationService _configurationService;
    private ClientCapabilitiesService _clientCapabilitiesService;
    private ThreadPoolExecutor _threadPoolExecutor;

    public DatastorePropertyProvider(LegacyAuthorizationService authorizationService, DataService dataService, StorageDataService storageDataService, ConfigurationService configurationService, ThreadPoolExecutor threadPoolExecutor, ClientCapabilitiesService clientCapabilitiesService) {
        this._authorizationService = authorizationService;
        this._dataService = dataService;
        this._storageDataService = storageDataService;
        this._configurationService = configurationService;
        this._threadPoolExecutor = threadPoolExecutor;
        this._clientCapabilitiesService = clientCapabilitiesService;
    }

    @type(value="Datastore")
    public ManagedObjectReference getConnectedHost(ManagedObjectReference dsRef) throws Exception {
        return StorageUtil.getConnectedHostForDatastore((ManagedObjectReference)dsRef, (boolean)true, (DataService)this._dataService);
    }

    @type(value="Datastore")
    public VmfsDatastoreOption[] getVmfsDatastoreIncreaseOptions(ManagedObjectReference datastoreRef, DatastoreIncreaseOptionsQuerySpec spec) throws Exception {
        if (datastoreRef == null) {
            _logger.error((Object)"getVmfsDatastoreIncreaseOptions: datastoreRef can't be null.");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.invalidDatastore"));
        }
        DatastorePropertyProvider.validateDatastoreIncreaseOptionsQuerySpec(spec);
        DatastoreSystem datastoreSystem = this._storageDataService.getHostDatastoreSystem(spec.host);
        if (datastoreSystem == null) {
            _logger.error((Object)"Failed to retrieve host's DatastoreSystem.");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.failedToRetrieveHostInfo"));
        }
        if (spec.scsiDiskInfo.expandable) {
            VmfsDatastoreOption[] expandOptions = DatastorePropertyProvider.getExpandAndExtendOptions(datastoreRef, datastoreSystem, spec);
            return expandOptions;
        }
        VmfsDatastoreOption[] extendOptions = datastoreSystem.queryVmfsDatastoreExtendOptions(datastoreRef, spec.scsiDiskInfo.disk.devicePath, Boolean.valueOf(false));
        return extendOptions;
    }

    @type(value="HostSystem")
    public VmfsDatastoreOption[] getVmfsDatastoreCreateOptions(ManagedObjectReference hostRef, DatastoreCreateOptionsQuerySpec spec) throws Exception {
        DatastorePropertyProvider.validateDatastoreCreateOptionsQuerySpec(spec);
        DatastoreSystem datastoreSystem = this._storageDataService.getHostDatastoreSystem(hostRef);
        if (datastoreSystem == null) {
            _logger.error((Object)"getVmfsDatastoreCreateOptions: Failed to retrieve host's datastoreSystem");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.failedToRetrieveHostInfo"));
        }
        VmfsDatastoreOption[] options = datastoreSystem.queryVmfsDatastoreCreateOptions(spec.scsiDiskInfo.disk.devicePath, Integer.valueOf(spec.vmfsMajorVersion));
        return options;
    }

    @type(value="Datastore")
    public long getSharesValue(ManagedObjectReference datastoreRef) throws Exception {
        if (datastoreRef == null) {
            _logger.error((Object)"datastoreRef can't be null.");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.invalidDatastore"));
        }
        Constraint dsVmsConstraint = QueryUtil.createConstraintForRelationship((Object)datastoreRef, (String)"vm", (String)"VirtualMachine");
        QuerySpec dsVirtualDisksQuery = QueryUtil.buildQuerySpec((Constraint)dsVmsConstraint, (String[])new String[]{"virtualDisks"});
        ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)dsVirtualDisksQuery);
        if (resultSet.items.length == 0) {
            return 0L;
        }
        long dsShares = 0L;
        for (ResultItem resItem : resultSet.items) {
            VirtualDisk[] vDisks;
            if (resItem.properties[0].value == null) continue;
            for (VirtualDisk vDisk : vDisks = (VirtualDisk[])resItem.properties[0].value) {
                if (!(vDisk.backing instanceof VirtualDevice.FileBackingInfo)) continue;
                VirtualDevice.FileBackingInfo fileBacking = (VirtualDevice.FileBackingInfo)vDisk.backing;
                if (!ManagedObjectUtil.areEqual((ManagedObjectReference)fileBacking.datastore, (ManagedObjectReference)datastoreRef).booleanValue()) continue;
                if (vDisk.storageIOAllocation == null) {
                    if (vDisk.shares == null) continue;
                    dsShares += (long)vDisk.shares.shares;
                    continue;
                }
                if (vDisk.storageIOAllocation.shares == null) continue;
                dsShares += (long)vDisk.storageIOAllocation.shares.shares;
            }
        }
        return dsShares;
    }

    @type(value="Datastore")
    public double getDeviceModelIntercept(ManagedObjectReference datastoreRef) throws Exception {
        StorageResourceManager srm;
        StorageResourceManager.IORMDeviceModel iormModel;
        double intercept = 0.0;
        if (this.isVC51orLater(datastoreRef.getServerGuid()) && (iormModel = (srm = StorageUtil.getStorageManager((ManagedObjectReference)datastoreRef)).GetStorageIORMDeviceModel(datastoreRef)) != null) {
            intercept = iormModel.lqIntercept;
        }
        return intercept;
    }

    @type(value="HostSystem")
    public ScsiDiskInfo[] getAvailableDisksForVmfs(ManagedObjectReference hostRef, final ManagedObjectReference datastoreRef) throws Throwable {
        final HttpServletRequest threadContext = SessionUtil.getHttpRequest();
        SessionUtil.setHttpRequest((HttpServletRequest)threadContext);
        PropertyValue[] hostProperties = QueryUtil.getProperties((DataService)this._dataService, (Object)hostRef, (String[])new String[]{HOST_DATASTORE_SYSTEM_PROPERTY, HOST_STORAGE_SYSTEM_PROPERTY});
        ManagedObjectReference datastoreSystemMor = null;
        ManagedObjectReference storageSystemMor = null;
        for (int i = 0; i < hostProperties.length; ++i) {
            if (HOST_DATASTORE_SYSTEM_PROPERTY.equals(hostProperties[i].propertyName)) {
                datastoreSystemMor = (ManagedObjectReference)hostProperties[i].value;
                continue;
            }
            if (!HOST_STORAGE_SYSTEM_PROPERTY.equals(hostProperties[i].propertyName)) continue;
            storageSystemMor = (ManagedObjectReference)hostProperties[i].value;
        }
        final DatastoreSystem datastoreSystem = (DatastoreSystem)this.getManagedObject(datastoreSystemMor);
        if (datastoreSystem == null) {
            _logger.error((Object)"getAvailableDisksForVmfs: Failed to retrieve host's datastoreSystem.");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.failedToRetrieveHostInfo"));
        }
        final StorageSystem storageSystem = (StorageSystem)this.getManagedObject(storageSystemMor);
        if (storageSystem == null) {
            _logger.error((Object)"Failed to retrieve host's StorageSystem.");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.failedToRetrieveStorageSystemInfo"));
        }
        List<Future<Object>> vmfsDataQueries = this.executeInParallel(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SessionUtil.setHttpRequest((HttpServletRequest)threadContext);
                return QueryUtil.getProperty((DataService)DatastorePropertyProvider.this._dataService, (Object)storageSystem._getRef(), (String)"storageDeviceInfo");
            }
        }, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return datastoreSystem.queryAvailableDisksForVmfs(datastoreRef);
            }
        }, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (datastoreRef == null) {
                    SessionUtil.setHttpRequest((HttpServletRequest)threadContext);
                    return storageSystem.queryUnresolvedVmfsVolume();
                }
                if (!StorageUtil.isVmfsExtentExpansionSupported((DatastoreSystem)datastoreSystem)) {
                    return null;
                }
                SessionUtil.setHttpRequest((HttpServletRequest)threadContext);
                return datastoreSystem.queryVmfsDatastoreExpandOptions(datastoreRef);
            }
        });
        StorageDeviceInfo deviceInfo = (StorageDeviceInfo)this.getFutureResult(vmfsDataQueries.get(0));
        if (deviceInfo == null) {
            _logger.error((Object)"Failed to retrieve host's StorageDeviceInfo.");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.failedToRetrieveHostInfo"));
        }
        ScsiDisk[] disks = (ScsiDisk[])this.getFutureResult(vmfsDataQueries.get(1));
        List<ScsiDiskInfo> diskInfos = DatastorePropertyProvider.createScsiDiskInfos(disks, deviceInfo);
        if (datastoreRef == null) {
            UnresolvedVmfsVolume[] unresolvedVmfsVolumes = (UnresolvedVmfsVolume[])this.getFutureResult(vmfsDataQueries.get(2));
            DatastorePropertyProvider.populateUnresolvedVmfsVolumeInfo(diskInfos, unresolvedVmfsVolumes);
        } else {
            VmfsDatastoreOption[] expandOptions = (VmfsDatastoreOption[])this.getFutureResult(vmfsDataQueries.get(2));
            DatastorePropertyProvider.populateExpandableProperties(diskInfos, expandOptions, deviceInfo);
        }
        return diskInfos.toArray(new ScsiDiskInfo[diskInfos.size()]);
    }

    @SafeVarargs
    private final List<Future<Object>> executeInParallel(Callable<Object> ... tasks) {
        try {
            return this._threadPoolExecutor.invokeAll(Arrays.asList(tasks));
        }
        catch (InterruptedException e) {
            _logger.error((Object)"DatastorePropertyProvider: The executor has been interrupted:", (Throwable)e);
            return new ArrayList<Future<Object>>(tasks.length);
        }
    }

    private <T extends ManagedObject> T getManagedObject(ManagedObjectReference mor) throws Exception {
        if (mor == null) {
            return null;
        }
        return (T)ManagedObjectUtil.getManagedObject((ManagedObjectReference)mor);
    }

    private <T> T getFutureResult(Future<Object> future) throws Throwable {
        if (future == null) {
            return null;
        }
        try {
            return (T)future.get();
        }
        catch (InterruptedException e) {
            _logger.error((Object)"DatastorePropertyProvider: The executor has been interrupted:", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
        return null;
    }

    @type(value="HostSystem")
    public DeviceMultipathingInfo getDeviceMultipathingInfo(ManagedObjectReference hostRef, String deviceCanonicalName) throws Exception {
        if (hostRef == null) {
            _logger.error((Object)"getDeviceMultipathingInfo: hostRef can't be null.");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.invalidHost"));
        }
        if (deviceCanonicalName == null || deviceCanonicalName.length() == 0) {
            _logger.error((Object)"getDeviceMultipathingInfo: invalid deviceCanonicalName.");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.invalidArgument"));
        }
        HostSystem.ConnectionState hostConnectionState = (HostSystem.ConnectionState)QueryUtil.getProperty((DataService)this._dataService, (Object)hostRef, (String)HOST_CONNECTION_STATE_PROPERTY);
        if (hostConnectionState != HostSystem.ConnectionState.connected) {
            _logger.warn((Object)"getDeviceMultipathingInfo:Host is disconnected.");
            return null;
        }
        StorageDeviceInfo sdi = this._storageDataService.getHostStorageDeviceInfo(hostRef);
        if (sdi == null) {
            _logger.error((Object)"getDeviceMultipathingInfo:Failed to retrieve host's StorageDeviceInfo.");
            return null;
        }
        MultipathStateInfo msi = this._storageDataService.getHostMultipathStateInfo(hostRef);
        if (msi == null) {
            _logger.error((Object)"getDeviceMultipathingInfo:Failed to retrieve host's MultipathStateInfo.");
            return null;
        }
        HostStoragePropertyCache cache = new HostStoragePropertyCache(sdi, msi);
        return DatastorePropertyProvider.getDeviceMultipathingInfoInternal(cache, deviceCanonicalName);
    }

    @type(value="HostSystem")
    public DeviceMultipathingInfo[] getExtentsMultipathingInfo(ManagedObjectReference hostRef, ManagedObjectReference datastoreRef) throws Exception {
        if (hostRef == null) {
            _logger.error((Object)"getExtentsMultipathingInfo: hostRef can't be null.");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.invalidHost"));
        }
        if (datastoreRef == null) {
            _logger.error((Object)"getExtentsMultipathingInfo: datastoreRef can't be null.");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.invalidDatastore"));
        }
        Datastore.Info dsInfo = (Datastore.Info)QueryUtil.getProperty((DataService)this._dataService, (Object)datastoreRef, (String)DS_INFO_PROPERTY);
        if (!(dsInfo instanceof VmfsDatastoreInfo)) {
            _logger.error((Object)"getExtentsMultipathingInfo: datastore is not VMFS.");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.dsIsNotVMFS"));
        }
        HostSystem.ConnectionState hostConnectionState = (HostSystem.ConnectionState)QueryUtil.getProperty((DataService)this._dataService, (Object)hostRef, (String)HOST_CONNECTION_STATE_PROPERTY);
        if (hostConnectionState != HostSystem.ConnectionState.connected) {
            return new DeviceMultipathingInfo[0];
        }
        StorageDeviceInfo sdi = this._storageDataService.getHostStorageDeviceInfo(hostRef);
        if (sdi == null) {
            _logger.error((Object)"getExtentsMultipathingInfo:Failed to retrieve host's StorageDeviceInfo.");
            return new DeviceMultipathingInfo[0];
        }
        MultipathStateInfo msi = this._storageDataService.getHostMultipathStateInfo(hostRef);
        if (msi == null) {
            _logger.error((Object)"getExtentsMultipathingInfo:Failed to retrieve host's MultipathStateInfo.");
            return new DeviceMultipathingInfo[0];
        }
        HostStoragePropertyCache cache = new HostStoragePropertyCache(sdi, msi);
        return DatastorePropertyProvider.getExtentsMultipathingInfoInternal((VmfsDatastoreInfo)dsInfo, cache);
    }

    private static DeviceMultipathingInfo[] getExtentsMultipathingInfoInternal(VmfsDatastoreInfo vmfsInfo, HostStoragePropertyCache cache) {
        if (vmfsInfo.vmfs == null || vmfsInfo.vmfs.extent == null || vmfsInfo.vmfs.extent.length == 0) {
            return new DeviceMultipathingInfo[0];
        }
        DeviceMultipathingInfo[] deviceInfos = new DeviceMultipathingInfo[vmfsInfo.vmfs.extent.length];
        for (int i = 0; i < deviceInfos.length; ++i) {
            deviceInfos[i] = DatastorePropertyProvider.getDeviceMultipathingInfoInternal(cache, vmfsInfo.vmfs.extent[i].diskName);
        }
        return deviceInfos;
    }

    private static DeviceMultipathingInfo getDeviceMultipathingInfoInternal(HostStoragePropertyCache cache, String deviceCanonicalName) {
        for (ScsiLun scsiLun : cache.storageDeviceInfo.scsiLun) {
            if (!deviceCanonicalName.equals(scsiLun.canonicalName)) continue;
            DeviceMultipathingInfo deviceInfo = new DeviceMultipathingInfo();
            deviceInfo.deviceDisplayName = scsiLun.displayName;
            deviceInfo.canonicalName = scsiLun.canonicalName;
            MultipathInfo.LogicalUnit logicalUnit = (MultipathInfo.LogicalUnit)cache.lunLogicalUnits.get(scsiLun.key);
            if (logicalUnit != null) {
                deviceInfo.logicalUnitId = logicalUnit.id;
                deviceInfo.pathSelectionPolicy = logicalUnit.policy;
                deviceInfo.storageArrayTypePolicy = logicalUnit.storageArrayTypePolicy;
            }
            deviceInfo.ownerPlugin = StorageUtil.getLunPluginName((HostStoragePropertyCache)cache, (ScsiLun)scsiLun);
            PlugStoreTopology.Device device = (PlugStoreTopology.Device)cache.lunDevices.get(scsiLun.key);
            if (device.path == null) {
                deviceInfo.paths = new StoragePathData[0];
            } else {
                PlugStoreTopology.Plugin[] pstPluginsArray = cache.pstPlugins.values().toArray(new PlugStoreTopology.Plugin[cache.pstPlugins.size()]);
                ArrayList<StoragePathData> paths = new ArrayList<StoragePathData>();
                for (int pathIndex = 0; pathIndex < device.path.length; ++pathIndex) {
                    if (StorageUtil.isPathMasked((String)device.path[pathIndex], (PlugStoreTopology.Plugin[])pstPluginsArray)) continue;
                    paths.add(StorageUtil.buildStoragePathData((String)device.path[pathIndex], (HostStoragePropertyCache)cache));
                }
                deviceInfo.paths = paths.toArray(new StoragePathData[paths.size()]);
            }
            return deviceInfo;
        }
        return null;
    }

    @type(value="Datastore")
    public VmfsExtentInfo[] getVmfsDatastoreExtents(ManagedObjectReference datastoreRef) throws Exception {
        if (datastoreRef == null) {
            _logger.error((Object)"getVmfsDatastoreExtents: datastoreRef can't be null.");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.invalidDatastore"));
        }
        Datastore.Info dsInfo = (Datastore.Info)QueryUtil.getProperty((DataService)this._dataService, (Object)datastoreRef, (String)DS_INFO_PROPERTY);
        if (!(dsInfo instanceof VmfsDatastoreInfo)) {
            _logger.error((Object)"getVmfsDatastoreExtents: datastore is not VMFS.");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.invalidDatastore"));
        }
        ManagedObjectReference hostRef = StorageUtil.getConnectedHostForDatastore((ManagedObjectReference)datastoreRef, (boolean)false, (DataService)this._dataService);
        if (hostRef == null) {
            return new VmfsExtentInfo[0];
        }
        return this.getDatastoreExtentsInternal((VmfsDatastoreInfo)dsInfo, hostRef);
    }

    @type(value="Datastore")
    public boolean getShouldWarnOnDatastoreEnterMaintenanceMode(ManagedObjectReference datastoreRef) throws Exception {
        Integer vmCount;
        if (datastoreRef == null) {
            _logger.error((Object)"getShouldWarnOnDatastoreEnterMaintenanceMode : datastoreRef can't be null.");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.invalidDatastore"));
        }
        boolean isSDRSDisabled = false;
        PropertyValue[] sdrsEnabledPV = QueryUtil.getPropertyForRelatedObjects((DataService)this._dataService, (Object)datastoreRef, (String)STORAGE_POD_RELATIONSHIP, (String)StoragePod.class.getSimpleName(), (String)SDRS_ENABLED_PROPERTY);
        if (sdrsEnabledPV != null && sdrsEnabledPV.length > 0) {
            isSDRSDisabled = (Boolean)sdrsEnabledPV[0].value == false;
        }
        boolean vmsFound = false;
        if (isSDRSDisabled && (vmCount = (Integer)QueryUtil.getProperty((DataService)this._dataService, (Object)datastoreRef, (String)DATASTORE_VMS_COUNT)) > 0) {
            vmsFound = true;
        }
        return isSDRSDisabled && vmsFound;
    }

    @type(value="Datastore")
    public String getVvolStorageProvider(ManagedObjectReference datastoreRef) throws Exception {
        if (datastoreRef == null) {
            _logger.error((Object)"getVvolStorageProvider: datastoreRef can't be null.");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.invalidDatastore"));
        }
        Datastore.Info dsInfo = (Datastore.Info)QueryUtil.getProperty((DataService)this._dataService, (Object)datastoreRef, (String)DS_INFO_PROPERTY);
        if (!(dsInfo instanceof VvolDatastoreInfo)) {
            _logger.error((Object)"getVvolStorageProvider: datastore is not VVOL.");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.invalidDatastoreType"));
        }
        String vVolSPName = StorageUtil.getVvolDeviceName((VvolVolume)((VvolDatastoreInfo)dsInfo).vvolDS);
        return vVolSPName;
    }

    @type(value="Datastore")
    public VimVasaProviderInfo[] getDatastoreStorageProvidersData(ManagedObjectReference datastoreRef) throws Exception {
        if (datastoreRef == null) {
            _logger.error((Object)"getDatastoreStorageProvidersData: datastoreRef can't be null.");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.invalidDatastore"));
        }
        Datastore.Info dsInfo = (Datastore.Info)QueryUtil.getProperty((DataService)this._dataService, (Object)datastoreRef, (String)DS_INFO_PROPERTY);
        if (dsInfo == null || !(dsInfo instanceof VvolDatastoreInfo)) {
            _logger.error((Object)"getDatastoreStorageProvidersData: datastore is not VVOL.");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.invalidDatastoreType"));
        }
        VvolVolume vvolDS = ((VvolDatastoreInfo)dsInfo).vvolDS;
        if (vvolDS != null && vvolDS.vasaProviderInfo != null) {
            VimVasaProviderInfo[] providers = vvolDS.vasaProviderInfo;
            return providers;
        }
        return new VimVasaProviderInfo[0];
    }

    private VmfsExtentInfo[] getDatastoreExtentsInternal(VmfsDatastoreInfo vmfsInfo, ManagedObjectReference hostRef) throws Exception {
        if (vmfsInfo.vmfs == null || vmfsInfo.vmfs.extent == null || vmfsInfo.vmfs.extent.length == 0) {
            return new VmfsExtentInfo[0];
        }
        StorageDeviceInfo storageDeviceInfo = this._storageDataService.getHostStorageDeviceInfo(hostRef);
        if (storageDeviceInfo == null) {
            return new VmfsExtentInfo[0];
        }
        VmfsExtentInfo[] extents = new VmfsExtentInfo[vmfsInfo.vmfs.extent.length];
        String[] devicePaths = new String[extents.length];
        block0: for (int i = 0; i < extents.length; ++i) {
            extents[i] = new VmfsExtentInfo();
            extents[i].extentPartition = vmfsInfo.vmfs.extent[i];
            for (ScsiLun scsiLun : storageDeviceInfo.scsiLun) {
                if (!extents[i].extentPartition.diskName.equals(scsiLun.canonicalName)) continue;
                extents[i].deviceDisplayName = scsiLun.displayName;
                devicePaths[i] = ((ScsiDisk)scsiLun).devicePath;
                extents[i].isSsd = ((ScsiDisk)scsiLun).ssd;
                extents[i].scsiDiskType = ((ScsiDisk)scsiLun).scsiDiskType;
                continue block0;
            }
        }
        StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
        DiskPartitionInfo[] partitionInfos = storageSystem.retrieveDiskPartitionInfo(devicePaths);
        if (partitionInfos != null && partitionInfos.length == extents.length) {
            for (int i = 0; i < extents.length; ++i) {
                extents[i].partitionInfo = partitionInfos[i];
            }
        }
        return extents;
    }

    private static void validateDatastoreCreateOptionsQuerySpec(DatastoreCreateOptionsQuerySpec spec) {
        if (spec == null) {
            _logger.error((Object)"Invalid argument - DatastoreCreateOptionsQuerySpec");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.invalidArgument"));
        }
        if (spec.scsiDiskInfo == null) {
            _logger.error((Object)"Invalid argument - DatastoreCreateOptionsQuerySpec.scsiDiskInfo");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.invalidArgument"));
        }
    }

    private static void validateDatastoreIncreaseOptionsQuerySpec(DatastoreIncreaseOptionsQuerySpec spec) {
        if (spec == null) {
            _logger.error((Object)"Invalid argument - DatastoreIncreaseOptionsQuerySpec");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.invalidArgument"));
        }
        if (spec.host == null) {
            _logger.error((Object)"Invalid argument - DatastoreIncreaseOptionsQuerySpec.host");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.invalidArgument"));
        }
        if (spec.scsiDiskInfo == null) {
            _logger.error((Object)"Invalid argument - DatastoreIncreaseOptionsQuerySpec.scsiDiskInfo");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.invalidArgument"));
        }
    }

    private static VmfsDatastoreOption[] getExpandAndExtendOptions(ManagedObjectReference datastoreRef, DatastoreSystem datastoreSystem, DatastoreIncreaseOptionsQuerySpec spec) throws Exception {
        ArrayList<VmfsDatastoreOption> options = DatastorePropertyProvider.filterExpandOptionByDevice(spec.scsiDiskInfo.disk, datastoreSystem.queryVmfsDatastoreExpandOptions(datastoreRef));
        VmfsDatastoreOption[] extendOptions = datastoreSystem.queryVmfsDatastoreExtendOptions(datastoreRef, spec.scsiDiskInfo.disk.devicePath, Boolean.valueOf(true));
        if (options.size() != 0) {
            if (extendOptions != null) {
                for (VmfsDatastoreOption extendOption : extendOptions) {
                    options.add(extendOption);
                }
            }
            return options.toArray(new VmfsDatastoreOption[0]);
        }
        return extendOptions;
    }

    private static ArrayList<VmfsDatastoreOption> filterExpandOptionByDevice(ScsiDisk disk, VmfsDatastoreOption[] options) {
        ArrayList<VmfsDatastoreOption> filteredOptions = new ArrayList<VmfsDatastoreOption>();
        for (VmfsDatastoreOption vmfsOption : options) {
            if (!DatastorePropertyProvider.isVmfsExpandOptionForDevice(vmfsOption, disk)) continue;
            filteredOptions.add(vmfsOption);
        }
        return filteredOptions;
    }

    private static boolean isVmfsExpandOptionForDevice(VmfsDatastoreOption vmfsOption, ScsiDisk scsiDisk) {
        if (vmfsOption != null && scsiDisk != null && vmfsOption.spec instanceof VmfsDatastoreExpandSpec) {
            return ((VmfsDatastoreExpandSpec)vmfsOption.spec).extent.diskName.equals(scsiDisk.canonicalName);
        }
        return false;
    }

    private static void populateUnresolvedVmfsVolumeInfo(List<ScsiDiskInfo> diskInfos, UnresolvedVmfsVolume[] unresolvedVolumes) {
        if (unresolvedVolumes == null || unresolvedVolumes.length == 0) {
            return;
        }
        for (UnresolvedVmfsVolume unresolvedVolume : unresolvedVolumes) {
            block1: for (UnresolvedVmfsExtent unresolvedVmfsExtent : unresolvedVolume.extent) {
                String extentPath = unresolvedVmfsExtent.devicePath;
                int lastColon = unresolvedVmfsExtent.devicePath.lastIndexOf(58);
                if (lastColon != -1) {
                    extentPath = extentPath.substring(0, lastColon);
                }
                for (ScsiDiskInfo diskInfo : diskInfos) {
                    if (!diskInfo.disk.devicePath.equals(extentPath)) continue;
                    if (diskInfo.unresolvedExtent != null && diskInfo.unresolvedExtent.isHeadExtent) continue block1;
                    diskInfo.vmfsLabel = unresolvedVolume.vmfsLabel;
                    diskInfo.unresolvedExtent = unresolvedVmfsExtent;
                    diskInfo.resolveStatus = unresolvedVolume.resolveStatus;
                    diskInfo.volumeSignature = unresolvedVolume.vmfsUuid;
                    continue block1;
                }
            }
        }
    }

    private static void populateExpandableProperties(List<ScsiDiskInfo> diskInfos, VmfsDatastoreOption[] expandOptions, StorageDeviceInfo storageDeviceInfo) {
        if (expandOptions == null || expandOptions.length == 0) {
            return;
        }
        block0: for (VmfsDatastoreOption vmfsOption : expandOptions) {
            String vmfsOptionDiskName;
            boolean isVmfsOptionDiskFound = false;
            for (ScsiDiskInfo diskInfo : diskInfos) {
                if (!DatastorePropertyProvider.isVmfsExpandOptionForDevice(vmfsOption, diskInfo.disk)) continue;
                diskInfo.expandable = true;
                isVmfsOptionDiskFound = true;
            }
            if (isVmfsOptionDiskFound || !(vmfsOption.spec instanceof VmfsDatastoreExpandSpec) || storageDeviceInfo.scsiLun == null || (vmfsOptionDiskName = ((VmfsDatastoreExpandSpec)vmfsOption.spec).extent.diskName) == null || vmfsOptionDiskName.isEmpty()) continue;
            for (ScsiLun scsiLun : storageDeviceInfo.scsiLun) {
                if (!(scsiLun instanceof ScsiDisk) || !vmfsOptionDiskName.equals(scsiLun.canonicalName)) continue;
                ScsiDiskInfo diskInfo = DatastorePropertyProvider.createScsiDiskInfo((ScsiDisk)scsiLun, storageDeviceInfo);
                diskInfo.expandable = true;
                diskInfos.add(diskInfo);
                continue block0;
            }
        }
    }

    private static List<ScsiDiskInfo> createScsiDiskInfos(ScsiDisk[] disks, StorageDeviceInfo deviceInfo) {
        ArrayList<ScsiDiskInfo> result = new ArrayList<ScsiDiskInfo>();
        if (disks == null) {
            return result;
        }
        for (ScsiDisk disk : disks) {
            result.add(DatastorePropertyProvider.createScsiDiskInfo(disk, deviceInfo));
        }
        return result;
    }

    private static ScsiDiskInfo createScsiDiskInfo(ScsiDisk disk, StorageDeviceInfo storageDeviceInfo) {
        ScsiDiskInfo result = new ScsiDiskInfo();
        result.disk = disk;
        result.lun = StorageUtil.getDiskLunNumber((StorageDeviceInfo)storageDeviceInfo, (String)disk.canonicalName);
        result.expandable = false;
        return result;
    }

    private boolean isVC51orLater(String serverGuid) {
        try {
            VcService service = VimSessionUtil.getService((String)serverGuid);
            Version version = new Version(service.getServiceVersion());
            return version.compareTo(new Version("5.1.0")) >= 0;
        }
        catch (Exception exception) {
            _logger.error((Object)"[DatastorePropertyProvider failed in determining VC version]", (Throwable)exception);
            return false;
        }
    }

    @type(value="Folder,Datacenter,HostSystem,ComputeResource,ClusterComputeResource")
    public String getNewUniqueDatastoreName(ManagedObjectReference context) {
        ArrayList<String> existingNames = this.getAllDatastoreNames(context);
        String newUniqueDatastoreName = StringUtil.getIndexedString(existingNames, (String)DEFAULT_DATASTORE_NAME, (String)" ");
        return newUniqueDatastoreName;
    }

    private ArrayList<String> getAllDatastoreNames(ManagedObjectReference context) {
        ArrayList existingNames = null;
        try {
            existingNames = ObjectNamesRetriever.getNamesOfAllObjectsWithinDatacenter((DataService)this._dataService, (ManagedObjectReference)context, (String)DATASTORE_TYPE, (String)DEFAULT_DATASTORE_NAME);
        }
        catch (Exception e) {
            _logger.error((Object)e);
        }
        return existingNames;
    }

    @type(value="Datastore")
    public String[] getDatastoreFilesUrls(ManagedObjectReference datastore, Map<String, Object> fileSpecMap) throws Exception {
        DatastoreFilePathsSpec param = new DatastoreFilePathsSpec();
        param.datacenter = (ManagedObjectReference)fileSpecMap.get(DATACENTER);
        param.datastorePaths = (String[])fileSpecMap.get(DATASTORE_PATH);
        param.isStreamFormat = Boolean.TRUE.equals(fileSpecMap.get(IS_STREAM_FORMAT));
        return this.getFilesUrls(datastore, param);
    }

    @type(value="Datastore")
    public String[] getFilesUrls(ManagedObjectReference datastore, DatastoreFilePathsSpec fileSpec) throws Exception {
        ArrayList<String> fileUrls = new ArrayList<String>();
        String vcServiceUrl = this.getServiceUrl(datastore.getServerGuid());
        List<String> datacenterPath = this.getInventoryPath(fileSpec.datacenter);
        String datastoreName = this.getDatastoreName(datastore);
        for (String datastorePath : fileSpec.datastorePaths) {
            String filePath = DatastorePropertyProvider.getFilePath(datastorePath);
            String fileUrl = DatastorePropertyProvider.createFileUrl(vcServiceUrl, datacenterPath, datastoreName, filePath, false, fileSpec.isStreamFormat);
            if (fileUrl == null) continue;
            fileUrls.add(fileUrl);
        }
        return fileUrls.toArray(new String[fileUrls.size()]);
    }

    @type(value="Datastore")
    public FileTransferEndpoint[] getFileTransferEndpoints(ManagedObjectReference datastore, DatastoreFilePathsSpec fileSpec) throws Exception {
        boolean alwaysTransferThroughVc;
        ArrayList<FileTransferEndpoint> endpoints = new ArrayList<FileTransferEndpoint>();
        String alwaysTransferThroughVcCfg = this._configurationService.getProperty(ALWAYS_TRANSFER_THROUGH_VC_CONFIGURATION);
        boolean bl = alwaysTransferThroughVc = alwaysTransferThroughVcCfg == null ? this._clientCapabilitiesService.isFileBrowserDownloadUploadFromVcEnabled() : Boolean.TRUE.toString().equalsIgnoreCase(alwaysTransferThroughVcCfg);
        if (fileSpec instanceof DatastoreFilePathsSpecEx) {
            boolean bl2 = alwaysTransferThroughVc = alwaysTransferThroughVc || ((DatastoreFilePathsSpecEx)fileSpec).alwaysTransferThroughVc;
        }
        if (alwaysTransferThroughVc) {
            this.addProxyEndpoints(datastore, fileSpec, endpoints);
            _logger.info((Object)DatastorePropertyProvider.formatDebugInfo(alwaysTransferThroughVc, endpoints));
            return endpoints.toArray(new FileTransferEndpoint[0]);
        }
        PropertyValue[] propertyValues = QueryUtil.getProperties((DataService)this._dataService, (Object)datastore, (String[])new String[]{"name", HOST_MOUNT_PROPERTY});
        Datastore.HostMount[] hostMounts = null;
        String datastoreName = null;
        for (PropertyValue propertyValue : propertyValues) {
            if ("name".equals(propertyValue.propertyName)) {
                datastoreName = (String)propertyValue.value;
                continue;
            }
            if (!HOST_MOUNT_PROPERTY.equals(propertyValue.propertyName)) continue;
            hostMounts = (Datastore.HostMount[])propertyValue.value;
        }
        if (ArrayUtils.isEmpty(hostMounts) || datastoreName == null) {
            return null;
        }
        HostData hostData = this.getAccessibleConnectedHostData(hostMounts);
        if (hostData == null) {
            this.addProxyEndpoints(datastore, fileSpec, endpoints);
        } else {
            this.addEndpoints(datastore, fileSpec, hostData, datastoreName, endpoints);
        }
        _logger.info((Object)DatastorePropertyProvider.formatDebugInfo(alwaysTransferThroughVc, endpoints));
        return endpoints.toArray(new FileTransferEndpoint[0]);
    }

    private void addProxyEndpoints(ManagedObjectReference datastore, DatastoreFilePathsSpec fileSpec, List<FileTransferEndpoint> endpoints) throws Exception {
        String[] proxyUrls = this.getFilesUrls(datastore, fileSpec);
        if (proxyUrls == null) {
            return;
        }
        for (String proxyUrl : proxyUrls) {
            String ticket = null;
            SessionManager.GenericServiceTicket candidateVcTicket = this.requestTicket(proxyUrl, datastore.getServerGuid());
            if (candidateVcTicket != null && SessionManager.GenericServiceTicket.TicketType.VcServiceTicket.toString().equals(candidateVcTicket.getTicketType())) {
                ticket = candidateVcTicket.getId();
            }
            endpoints.add(new FileTransferEndpoint(proxyUrl, ticket));
        }
    }

    private void addEndpoints(ManagedObjectReference datastore, DatastoreFilePathsSpec fileSpec, HostData hostData, String datastoreName, List<FileTransferEndpoint> endpoints) throws URISyntaxException, UnsupportedEncodingException {
        String hostName = hostData.getName();
        if (IPAddressUtil.isIPv6LiteralAddress(hostName)) {
            hostName = String.format(IPV6_HOSTNAME_FORMAT, hostName);
        }
        boolean isHost65 = hostData.is65();
        for (String datastorePath : fileSpec.datastorePaths) {
            String filePath = DatastorePropertyProvider.getFilePath(datastorePath);
            String fileUrl = DatastorePropertyProvider.createFileUrl(ESX_ENDPOINT_PROTOCOL + hostName, ESX_DATACENTER_NAME, datastoreName, filePath, isHost65, fileSpec.isStreamFormat);
            if (fileUrl == null) continue;
            SessionManager.GenericServiceTicket ticket = this.requestTicket(fileUrl, datastore.getServerGuid());
            endpoints.add(new FileTransferEndpoint(fileUrl, ticket != null ? ticket.getId() : null));
        }
    }

    private SessionManager.GenericServiceTicket requestTicket(String remoteURL, String serverUuid) {
        SessionManager.GenericServiceTicket ticket;
        try {
            ticket = VcServiceUtil.acquireGenericServiceTicket(null, (String)remoteURL, (String)serverUuid);
        }
        catch (Exception e) {
            _logger.error((Object)"Not able to acquire generic service ticket for the purpose of file transfer", (Throwable)e);
            return null;
        }
        return ticket;
    }

    private HostData getAccessibleConnectedHostData(Datastore.HostMount[] hostMounts) throws Exception {
        Object[] accessibleHosts = this.getAccessibleHosts(hostMounts);
        if (ArrayUtils.isEmpty((Object[])accessibleHosts)) {
            return null;
        }
        return this.getConnectedHostData((ManagedObjectReference[])accessibleHosts);
    }

    private ManagedObjectReference[] getAccessibleHosts(Datastore.HostMount[] hostMounts) throws Exception {
        ArrayList<ManagedObjectReference> result = new ArrayList<ManagedObjectReference>();
        for (Datastore.HostMount hostMount : hostMounts) {
            if (!hostMount.getMountInfo().accessible.booleanValue()) continue;
            result.add(hostMount.key);
        }
        return result.toArray(new ManagedObjectReference[result.size()]);
    }

    private HostData getConnectedHostData(ManagedObjectReference[] hosts) throws Exception {
        String[] propertyNames = new String[]{"name", HOST_VERSION_PROPERTY, HOST_CONNECTION_STATE_PROPERTY, "grantedPrivileges"};
        PropertyValue[] propertyValues = QueryUtil.getProperties((DataService)this._dataService, (Object[])hosts, (String[])propertyNames);
        HashMap<ManagedObjectReference, HashMap<String, Object>> propertiesByHost = new HashMap<ManagedObjectReference, HashMap<String, Object>>();
        for (PropertyValue propertyValue : propertyValues) {
            ManagedObjectReference host = (ManagedObjectReference)propertyValue.resourceObject;
            HashMap<String, Object> properties = (HashMap<String, Object>)propertiesByHost.get(host);
            if (properties == null) {
                properties = new HashMap<String, Object>();
                propertiesByHost.put(host, properties);
            }
            properties.put(propertyValue.propertyName, propertyValue.value);
        }
        for (ManagedObjectReference host : propertiesByHost.keySet()) {
            Map properties = (Map)propertiesByHost.get(host);
            String hostVersion = (String)properties.get(HOST_VERSION_PROPERTY);
            HostSystem.ConnectionState hostConnectionState = (HostSystem.ConnectionState)properties.get(HOST_CONNECTION_STATE_PROPERTY);
            if (!this.isConnected(hostConnectionState) || !this.isDirectTransferSupported(hostVersion) || !this.hasHostConfigManagementPrivilege((String[])properties.get("grantedPrivileges"))) continue;
            return new HostData((String)properties.get("name"), hostVersion);
        }
        return null;
    }

    private boolean hasHostConfigManagementPrivilege(String[] grantedPrivileges) {
        return AuthorizationUtil.isPrivilegeGranted((String[])new String[]{HOST_CONFIG_SYSTEM_MANAGEMENT_PRIV}, (String[])grantedPrivileges);
    }

    private boolean isConnected(HostSystem.ConnectionState hostConnectionState) {
        return hostConnectionState == HostSystem.ConnectionState.connected;
    }

    private boolean isDirectTransferSupported(String esxVersion) {
        return new Version(esxVersion).compareTo(VERSION_65) >= 0;
    }

    private String getServiceUrl(String vcServiceGuid) {
        String vcServiceURL = VimSessionUtil.getService((String)vcServiceGuid).getServiceUrl();
        return vcServiceURL;
    }

    private List<String> getInventoryPath(ManagedObjectReference entity) throws Exception {
        LinkedList<String> result = new LinkedList<String>();
        while (entity != null && !ManagedObjectUtil.isRootFolder((ManagedObjectReference)entity)) {
            PropertyValue[] propertyValues = QueryUtil.getProperties((DataService)this._dataService, (Object)entity, (String[])new String[]{"name", PARENT});
            String name = null;
            ManagedObjectReference parent = null;
            for (PropertyValue value : propertyValues) {
                if ("name".equals(value.propertyName) && value.value != null) {
                    name = value.value.toString();
                    continue;
                }
                if (!PARENT.equals(value.propertyName) || !(value.value instanceof ManagedObjectReference)) continue;
                parent = (ManagedObjectReference)value.value;
            }
            result.add(0, name);
            entity = parent;
        }
        return result;
    }

    private String getDatastoreName(ManagedObjectReference datastore) throws Exception {
        String datastoreName = (String)QueryUtil.getProperty((DataService)this._dataService, (Object)datastore, (String)"name");
        return datastoreName;
    }

    private static String getFilePath(String datastorePath) {
        String filePath = null;
        Matcher matcher = DATASTORE_PATH_PATTERN.matcher(datastorePath);
        if (matcher.matches()) {
            filePath = matcher.group(FILE_PATH_GROUP).trim();
        } else {
            _logger.error((Object)String.format("Datastore path: '%s' doesn't match pattern '%s'!", datastorePath, DATASTORE_PATH_PATTERN.pattern()));
        }
        return filePath;
    }

    private static String createFileUrl(String vcServiceUrl, List<String> datacenterPath, String datastoreName, String filePath, boolean encodeTwice, boolean isStreamFormat) throws URISyntaxException, UnsupportedEncodingException {
        if (vcServiceUrl == null || datastoreName == null || datacenterPath == null || filePath == null) {
            return null;
        }
        URIBuilder uriBuilder = new URIBuilder(vcServiceUrl);
        uriBuilder.setPath(FOLDER_ENDPOINT.concat(filePath));
        StringBuilder dcEncodedPath = new StringBuilder();
        for (String dcPathPart : datacenterPath) {
            String currentPathEncoded = DatastorePropertyProvider.preEncodeVcEsxEndpointParams(dcPathPart, encodeTwice);
            if (dcEncodedPath.length() > 0) {
                dcEncodedPath.append(encodeTwice ? PATH_SEPARATOR_ENCODED : PATH_SEPARATOR);
            }
            dcEncodedPath.append(currentPathEncoded);
        }
        uriBuilder.setParameter(DC_PATH_PARAM, dcEncodedPath.toString());
        String datastoreNameEncoded = DatastorePropertyProvider.preEncodeVcEsxEndpointParams(datastoreName, encodeTwice);
        uriBuilder.setParameter(DS_NAME_PARAM, datastoreNameEncoded);
        if (isStreamFormat && filePath.endsWith(".vmdk")) {
            String diskFormatEncoded = DatastorePropertyProvider.preEncodeVcEsxEndpointParams(DISK_FORMAT_STEAM, encodeTwice);
            uriBuilder.setParameter(DISK_FORMAT_PARAM, diskFormatEncoded);
        }
        if (!encodeTwice) {
            uriBuilder.setParameter(ENCODING_FORMAT_PARAM, SINGLE_ENCODING_VALUE);
        }
        return DatastorePropertyProvider.encodeCharsInPathComponent(uriBuilder.toString());
    }

    private static String preEncodeVcEsxEndpointParams(String value, boolean encodeTwice) throws UnsupportedEncodingException {
        StringBuilder preEncodedValue = new StringBuilder();
        block5: for (int i = 0; i < value.length(); ++i) {
            switch (value.charAt(i)) {
                case '%': {
                    preEncodedValue.append("%25");
                    continue block5;
                }
                case '/': {
                    preEncodedValue.append(PATH_SEPARATOR_ENCODED);
                    continue block5;
                }
                case '\\': {
                    preEncodedValue.append("%5c");
                    continue block5;
                }
                default: {
                    preEncodedValue.append(value.charAt(i));
                }
            }
        }
        return encodeTwice ? URLEncoder.encode(preEncodedValue.toString(), UTF_8) : preEncodedValue.toString();
    }

    private static String encodeCharsInPathComponent(String uri) throws UnsupportedEncodingException {
        if (uri == null || uri.isEmpty()) {
            return uri;
        }
        Matcher matcher = Pattern.compile(FOLDER_ENDPOINT.replaceAll(PATH_SEPARATOR, "\\\\/") + "(?<" + PATH_PART_GROUP_NAME + ">.+?)\\?").matcher(uri);
        if (!matcher.find()) {
            return uri;
        }
        String originalPathComponent = matcher.group(PATH_PART_GROUP_NAME);
        if (originalPathComponent == null) {
            return uri;
        }
        String pathComponent = originalPathComponent;
        for (String characterToEncode : pathEncodedChars) {
            pathComponent = pathComponent.replaceAll(Pattern.quote(characterToEncode), URLEncoder.encode(characterToEncode, UTF_8));
        }
        return uri.replace(originalPathComponent, pathComponent);
    }

    private static String formatDebugInfo(boolean alwaysTransferThroughVc, List<FileTransferEndpoint> endpoints) {
        return String.format("Property '%s': '%s'. File transfer endpoints: [%s].", ALWAYS_TRANSFER_THROUGH_VC_CONFIGURATION, alwaysTransferThroughVc, StringUtils.join(endpoints, (char)','));
    }

    static {
        ESX_DATACENTER_NAME.add("ha-datacenter");
        VERSION_65 = new Version("6.5.0");
        VERSION_66 = new Version("6.6.0");
        DATASTORE_PATH_PATTERN = Pattern.compile("^\\[(?<datastoreName>.*?)\\]\\s{0,1}/{0,1}(?<filePath>.*)");
        DEFAULT_DATASTORE_NAME = I18nUtil.getLocalizedString("datastore.defaultName");
        DATASTORE_TYPE = Datastore.class.getSimpleName();
        _logger = LogFactory.getLog(DatastorePropertyProvider.class);
    }

    private static final class HostData {
        private String name;
        private Version version;

        public HostData(String name, String version) {
            this.name = name;
            this.version = new Version(version);
        }

        public boolean is65() {
            return this.version.compareTo(VERSION_65) >= 0 && this.version.compareTo(VERSION_66) < 0;
        }

        public String getName() {
            return this.name;
        }
    }
}

